/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.ResultParser;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VCardResultParser
extends ResultParser {
    private static final Pattern BEGIN_VCARD = Pattern.compile("BEGIN:VCARD", 2);
    private static final Pattern VCARD_LIKE_DATE = Pattern.compile("\\d{4}-?\\d{2}-?\\d{2}");
    private static final Pattern CR_LF_SPACE_TAB = Pattern.compile("\r\n[ \t]");
    private static final Pattern NEWLINE_ESCAPE = Pattern.compile("\\\\[nN]");
    private static final Pattern VCARD_ESCAPES = Pattern.compile("\\\\([,;\\\\])");
    private static final Pattern EQUALS = Pattern.compile("=");
    private static final Pattern SEMICOLON = Pattern.compile(";");
    private static final Pattern UNESCAPED_SEMICOLONS = Pattern.compile("(?<!\\\\);+");
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern SEMICOLON_OR_COMMA = Pattern.compile("[;,]");

    @Override
    public AddressBookParsedResult parse(Result result) {
        String[] stringArray;
        List<String> list;
        String string = VCardResultParser.getMassagedText(result);
        Matcher matcher = BEGIN_VCARD.matcher(string);
        if (!matcher.find() || matcher.start() != 0) {
            return null;
        }
        List<List<String>> list2 = VCardResultParser.matchVCardPrefixedField("FN", string, true, false);
        if (list2 == null) {
            list2 = VCardResultParser.matchVCardPrefixedField("N", string, true, false);
            VCardResultParser.formatNames(list2);
        }
        String[] stringArray2 = (list = VCardResultParser.matchSingleVCardPrefixedField("NICKNAME", string, true, false)) == null ? null : COMMA.split(list.get(0));
        List<List<String>> list3 = VCardResultParser.matchVCardPrefixedField("TEL", string, true, false);
        List<List<String>> list4 = VCardResultParser.matchVCardPrefixedField("EMAIL", string, true, false);
        List<String> list5 = VCardResultParser.matchSingleVCardPrefixedField("NOTE", string, false, false);
        List<List<String>> list6 = VCardResultParser.matchVCardPrefixedField("ADR", string, true, true);
        List<String> list7 = VCardResultParser.matchSingleVCardPrefixedField("ORG", string, true, true);
        List<String> list8 = VCardResultParser.matchSingleVCardPrefixedField("BDAY", string, true, false);
        if (list8 != null && !VCardResultParser.isLikeVCardDate(list8.get(0))) {
            list8 = null;
        }
        List<String> list9 = VCardResultParser.matchSingleVCardPrefixedField("TITLE", string, true, false);
        List<List<String>> list10 = VCardResultParser.matchVCardPrefixedField("URL", string, true, false);
        List<String> list11 = VCardResultParser.matchSingleVCardPrefixedField("IMPP", string, true, false);
        List<String> list12 = VCardResultParser.matchSingleVCardPrefixedField("GEO", string, true, false);
        String[] stringArray3 = stringArray = list12 == null ? null : SEMICOLON_OR_COMMA.split(list12.get(0));
        if (stringArray != null && stringArray.length != 2) {
            stringArray = null;
        }
        return new AddressBookParsedResult(VCardResultParser.toPrimaryValues(list2), stringArray2, null, VCardResultParser.toPrimaryValues(list3), VCardResultParser.toTypes(list3), VCardResultParser.toPrimaryValues(list4), VCardResultParser.toTypes(list4), VCardResultParser.toPrimaryValue(list11), VCardResultParser.toPrimaryValue(list5), VCardResultParser.toPrimaryValues(list6), VCardResultParser.toTypes(list6), VCardResultParser.toPrimaryValue(list7), VCardResultParser.toPrimaryValue(list8), VCardResultParser.toPrimaryValue(list9), VCardResultParser.toPrimaryValues(list10), stringArray);
    }

    static List<List<String>> matchVCardPrefixedField(CharSequence charSequence, String string, boolean bl, boolean bl2) {
        ArrayList arrayList = null;
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            Matcher matcher = Pattern.compile("(?:^|\n)" + charSequence + "(?:;([^:]*))?:", 2).matcher(string);
            if (n > 0) {
                --n;
            }
            if (!matcher.find(n)) break;
            n = matcher.end(0);
            String string2 = matcher.group(1);
            ArrayList<String> arrayList2 = null;
            boolean bl3 = false;
            String string3 = null;
            if (string2 != null) {
                for (String string4 : SEMICOLON.split(string2)) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String>(1);
                    }
                    arrayList2.add(string4);
                    String[] stringArray = EQUALS.split(string4, 2);
                    if (stringArray.length <= 1) continue;
                    String string5 = stringArray[0];
                    String string6 = stringArray[1];
                    if ("ENCODING".equalsIgnoreCase(string5) && "QUOTED-PRINTABLE".equalsIgnoreCase(string6)) {
                        bl3 = true;
                        continue;
                    }
                    if (!"CHARSET".equalsIgnoreCase(string5)) continue;
                    string3 = string6;
                }
            }
            int n3 = n;
            while ((n = string.indexOf(10, n)) >= 0) {
                if (n < string.length() - 1 && (string.charAt(n + 1) == ' ' || string.charAt(n + 1) == '\t')) {
                    n += 2;
                    continue;
                }
                if (!bl3 || (n < 1 || string.charAt(n - 1) != '=') && (n < 2 || string.charAt(n - 2) != '=')) break;
                ++n;
            }
            if (n < 0) {
                n = n2;
                continue;
            }
            if (n > n3) {
                if (arrayList == null) {
                    arrayList = new ArrayList(1);
                }
                if (n >= 1 && string.charAt(n - 1) == '\r') {
                    --n;
                }
                String string7 = string.substring(n3, n);
                if (bl) {
                    string7 = string7.trim();
                }
                if (bl3) {
                    string7 = VCardResultParser.decodeQuotedPrintable(string7, string3);
                    if (bl2) {
                        string7 = UNESCAPED_SEMICOLONS.matcher(string7).replaceAll("\n").trim();
                    }
                } else {
                    if (bl2) {
                        string7 = UNESCAPED_SEMICOLONS.matcher(string7).replaceAll("\n").trim();
                    }
                    string7 = CR_LF_SPACE_TAB.matcher(string7).replaceAll("");
                    string7 = NEWLINE_ESCAPE.matcher(string7).replaceAll("\n");
                    string7 = VCARD_ESCAPES.matcher(string7).replaceAll("$1");
                }
                if (arrayList2 == null) {
                    ArrayList<String> arrayList3 = new ArrayList<String>(1);
                    arrayList3.add(string7);
                    arrayList.add(arrayList3);
                } else {
                    arrayList2.add(0, string7);
                    arrayList.add(arrayList2);
                }
                ++n;
                continue;
            }
            ++n;
        }
        return arrayList;
    }

    private static String decodeQuotedPrintable(CharSequence charSequence, String string) {
        int n = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        block4: for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '=': {
                    char c2;
                    if (i >= n - 2 || (c2 = charSequence.charAt(i + 1)) == '\r' || c2 == '\n') continue block4;
                    char c3 = charSequence.charAt(i + 2);
                    int n2 = VCardResultParser.parseHexDigit(c2);
                    int n3 = VCardResultParser.parseHexDigit(c3);
                    if (n2 >= 0 && n3 >= 0) {
                        byteArrayOutputStream.write((n2 << 4) + n3);
                    }
                    i += 2;
                    continue block4;
                }
                default: {
                    VCardResultParser.maybeAppendFragment(byteArrayOutputStream, string, stringBuilder);
                    stringBuilder.append(c);
                }
            }
        }
        VCardResultParser.maybeAppendFragment(byteArrayOutputStream, string, stringBuilder);
        return stringBuilder.toString();
    }

    private static void maybeAppendFragment(ByteArrayOutputStream byteArrayOutputStream, String string, StringBuilder stringBuilder) {
        if (byteArrayOutputStream.size() > 0) {
            String string2;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (string == null) {
                string2 = new String(byArray, Charset.forName("UTF-8"));
            } else {
                try {
                    string2 = new String(byArray, string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string2 = new String(byArray, Charset.forName("UTF-8"));
                }
            }
            byteArrayOutputStream.reset();
            stringBuilder.append(string2);
        }
    }

    static List<String> matchSingleVCardPrefixedField(CharSequence charSequence, String string, boolean bl, boolean bl2) {
        List<List<String>> list = VCardResultParser.matchVCardPrefixedField(charSequence, string, bl, bl2);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    private static String toPrimaryValue(List<String> list) {
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    private static String[] toPrimaryValues(Collection<List<String>> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (List<String> list : collection) {
            String string = list.get(0);
            if (string == null || string.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[collection.size()]);
    }

    private static String[] toTypes(Collection<List<String>> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (List<String> list : collection) {
            String string = null;
            for (int i = 1; i < list.size(); ++i) {
                String string2 = list.get(i);
                int n = string2.indexOf(61);
                if (n < 0) {
                    string = string2;
                    break;
                }
                if (!"TYPE".equalsIgnoreCase(string2.substring(0, n))) continue;
                string = string2.substring(n + 1);
                break;
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[collection.size()]);
    }

    private static boolean isLikeVCardDate(CharSequence charSequence) {
        return charSequence == null || VCARD_LIKE_DATE.matcher(charSequence).matches();
    }

    private static void formatNames(Iterable<List<String>> iterable) {
        if (iterable != null) {
            for (List<String> list : iterable) {
                int n;
                String string = list.get(0);
                String[] stringArray = new String[5];
                int n2 = 0;
                for (int i = 0; i < stringArray.length - 1 && (n = string.indexOf(59, n2)) >= 0; ++i) {
                    stringArray[i] = string.substring(n2, n);
                    n2 = n + 1;
                }
                stringArray[i] = string.substring(n2);
                StringBuilder stringBuilder = new StringBuilder(100);
                VCardResultParser.maybeAppendComponent(stringArray, 3, stringBuilder);
                VCardResultParser.maybeAppendComponent(stringArray, 1, stringBuilder);
                VCardResultParser.maybeAppendComponent(stringArray, 2, stringBuilder);
                VCardResultParser.maybeAppendComponent(stringArray, 0, stringBuilder);
                VCardResultParser.maybeAppendComponent(stringArray, 4, stringBuilder);
                list.set(0, stringBuilder.toString().trim());
            }
        }
    }

    private static void maybeAppendComponent(String[] stringArray, int n, StringBuilder stringBuilder) {
        if (stringArray[n] != null && !stringArray[n].isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[n]);
        }
    }
}

