/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.common.BitArray;

public final class BitMatrix {
    private final int width;
    private final int height;
    private final int rowSize;
    private final int[] bits;

    public BitMatrix(int n) {
        this(n, n);
    }

    public BitMatrix(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("Both dimensions must be greater than 0");
        }
        this.width = n;
        this.height = n2;
        this.rowSize = n + 31 >> 5;
        this.bits = new int[this.rowSize * n2];
    }

    public boolean get(int n, int n2) {
        int n3 = n2 * this.rowSize + (n >> 5);
        return (this.bits[n3] >>> (n & 0x1F) & 1) != 0;
    }

    public void set(int n, int n2) {
        int n3;
        int n4 = n3 = n2 * this.rowSize + (n >> 5);
        this.bits[n4] = this.bits[n4] | 1 << (n & 0x1F);
    }

    public void flip(int n, int n2) {
        int n3;
        int n4 = n3 = n2 * this.rowSize + (n >> 5);
        this.bits[n4] = this.bits[n4] ^ 1 << (n & 0x1F);
    }

    public void clear() {
        int n = this.bits.length;
        for (int i = 0; i < n; ++i) {
            this.bits[i] = 0;
        }
    }

    public void setRegion(int n, int n2, int n3, int n4) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("Left and top must be nonnegative");
        }
        if (n4 < 1 || n3 < 1) {
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (n6 > this.height || n5 > this.width) {
            throw new IllegalArgumentException("The region must fit inside the matrix");
        }
        for (int i = n2; i < n6; ++i) {
            int n7 = i * this.rowSize;
            for (int j = n; j < n5; ++j) {
                int n8 = n7 + (j >> 5);
                this.bits[n8] = this.bits[n8] | 1 << (j & 0x1F);
            }
        }
    }

    public BitArray getRow(int n, BitArray bitArray) {
        if (bitArray == null || bitArray.getSize() < this.width) {
            bitArray = new BitArray(this.width);
        }
        int n2 = n * this.rowSize;
        for (int i = 0; i < this.rowSize; ++i) {
            bitArray.setBulk(i << 5, this.bits[n2 + i]);
        }
        return bitArray;
    }

    public void setRow(int n, BitArray bitArray) {
        System.arraycopy(bitArray.getBitArray(), 0, this.bits, n * this.rowSize, this.rowSize);
    }

    public int[] getEnclosingRectangle() {
        int n;
        int n2;
        int n3 = this.width;
        int n4 = this.height;
        int n5 = -1;
        int n6 = -1;
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.rowSize; ++n) {
                int n7;
                int n8 = this.bits[n2 * this.rowSize + n];
                if (n8 == 0) continue;
                if (n2 < n4) {
                    n4 = n2;
                }
                if (n2 > n6) {
                    n6 = n2;
                }
                if (n * 32 < n3) {
                    n7 = 0;
                    while (n8 << 31 - n7 == 0) {
                        ++n7;
                    }
                    if (n * 32 + n7 < n3) {
                        n3 = n * 32 + n7;
                    }
                }
                if (n * 32 + 31 <= n5) continue;
                n7 = 31;
                while (n8 >>> n7 == 0) {
                    --n7;
                }
                if (n * 32 + n7 <= n5) continue;
                n5 = n * 32 + n7;
            }
        }
        n2 = n5 - n3;
        n = n6 - n4;
        if (n2 < 0 || n < 0) {
            return null;
        }
        return new int[]{n3, n4, n2, n};
    }

    public int[] getTopLeftOnBit() {
        int n;
        for (n = 0; n < this.bits.length && this.bits[n] == 0; ++n) {
        }
        if (n == this.bits.length) {
            return null;
        }
        int n2 = n / this.rowSize;
        int n3 = n % this.rowSize << 5;
        int n4 = this.bits[n];
        int n5 = 0;
        while (n4 << 31 - n5 == 0) {
            ++n5;
        }
        return new int[]{n3 += n5, n2};
    }

    public int[] getBottomRightOnBit() {
        int n;
        for (n = this.bits.length - 1; n >= 0 && this.bits[n] == 0; --n) {
        }
        if (n < 0) {
            return null;
        }
        int n2 = n / this.rowSize;
        int n3 = n % this.rowSize << 5;
        int n4 = this.bits[n];
        int n5 = 31;
        while (n4 >>> n5 == 0) {
            --n5;
        }
        return new int[]{n3 += n5, n2};
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitMatrix)) {
            return false;
        }
        BitMatrix bitMatrix = (BitMatrix)object;
        if (this.width != bitMatrix.width || this.height != bitMatrix.height || this.rowSize != bitMatrix.rowSize || this.bits.length != bitMatrix.bits.length) {
            return false;
        }
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == bitMatrix.bits[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.width;
        n = 31 * n + this.width;
        n = 31 * n + this.height;
        n = 31 * n + this.rowSize;
        for (int n2 : this.bits) {
            n = 31 * n + n2;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.height * (this.width + 1));
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                stringBuilder.append(this.get(j, i) ? "X " : "  ");
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

