/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.Binarizer;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;

public class GlobalHistogramBinarizer
extends Binarizer {
    private static final int LUMINANCE_BITS = 5;
    private static final int LUMINANCE_SHIFT = 3;
    private static final int LUMINANCE_BUCKETS = 32;
    private static final byte[] EMPTY = new byte[0];
    private byte[] luminances = EMPTY;
    private final int[] buckets = new int[32];

    public GlobalHistogramBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
    }

    @Override
    public BitArray getBlackRow(int n, BitArray bitArray) throws NotFoundException {
        int n2;
        int n3;
        LuminanceSource luminanceSource = this.getLuminanceSource();
        int n4 = luminanceSource.getWidth();
        if (bitArray == null || bitArray.getSize() < n4) {
            bitArray = new BitArray(n4);
        } else {
            bitArray.clear();
        }
        this.initArrays(n4);
        byte[] byArray = luminanceSource.getRow(n, this.luminances);
        int[] nArray = this.buckets;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = byArray[n3] & 0xFF;
            int n5 = n2 >> 3;
            nArray[n5] = nArray[n5] + 1;
        }
        n3 = GlobalHistogramBinarizer.estimateBlackPoint(nArray);
        n2 = byArray[0] & 0xFF;
        int n6 = byArray[1] & 0xFF;
        for (int i = 1; i < n4 - 1; ++i) {
            int n7 = byArray[i + 1] & 0xFF;
            int n8 = (n6 << 2) - n2 - n7 >> 1;
            if (n8 < n3) {
                bitArray.set(i);
            }
            n2 = n6;
            n6 = n7;
        }
        return bitArray;
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        int n;
        int n2;
        int n3;
        int n4;
        LuminanceSource luminanceSource = this.getLuminanceSource();
        int n5 = luminanceSource.getWidth();
        int n6 = luminanceSource.getHeight();
        BitMatrix bitMatrix = new BitMatrix(n5, n6);
        this.initArrays(n5);
        int[] nArray = this.buckets;
        for (n4 = 1; n4 < 5; ++n4) {
            int n7 = n6 * n4 / 5;
            byte[] byArray = luminanceSource.getRow(n7, this.luminances);
            n3 = (n5 << 2) / 5;
            for (n2 = n5 / 5; n2 < n3; ++n2) {
                n = byArray[n2] & 0xFF;
                int n8 = n >> 3;
                nArray[n8] = nArray[n8] + 1;
            }
        }
        n4 = GlobalHistogramBinarizer.estimateBlackPoint(nArray);
        byte[] byArray = luminanceSource.getMatrix();
        for (int i = 0; i < n6; ++i) {
            n3 = i * n5;
            for (n2 = 0; n2 < n5; ++n2) {
                n = byArray[n3 + n2] & 0xFF;
                if (n >= n4) continue;
                bitMatrix.set(n2, i);
            }
        }
        return bitMatrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new GlobalHistogramBinarizer(luminanceSource);
    }

    private void initArrays(int n) {
        if (this.luminances.length < n) {
            this.luminances = new byte[n];
        }
        for (int i = 0; i < 32; ++i) {
            this.buckets[i] = 0;
        }
    }

    private static int estimateBlackPoint(int[] nArray) throws NotFoundException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = nArray.length;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            if (nArray[n4] > n8) {
                n7 = n4;
                n8 = nArray[n4];
            }
            if (nArray[n4] <= n6) continue;
            n6 = nArray[n4];
        }
        n4 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = n3 - n7;
            n = nArray[n3] * n2 * n2;
            if (n <= n9) continue;
            n4 = n3;
            n9 = n;
        }
        if (n7 > n4) {
            n3 = n7;
            n7 = n4;
            n4 = n3;
        }
        if (n4 - n7 <= n5 >> 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        n3 = n4 - 1;
        n2 = -1;
        for (n = n4 - 1; n > n7; --n) {
            int n10 = n - n7;
            int n11 = n10 * n10 * (n4 - n) * (n6 - nArray[n]);
            if (n11 <= n2) continue;
            n3 = n;
            n2 = n11;
        }
        return n3 << 3;
    }
}

