/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.Binarizer;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GlobalHistogramBinarizer;

public final class HybridBinarizer
extends GlobalHistogramBinarizer {
    private static final int BLOCK_SIZE_POWER = 3;
    private static final int BLOCK_SIZE = 8;
    private static final int BLOCK_SIZE_MASK = 7;
    private static final int MINIMUM_DIMENSION = 40;
    private static final int MIN_DYNAMIC_RANGE = 24;
    private BitMatrix matrix;

    public HybridBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        if (this.matrix != null) {
            return this.matrix;
        }
        LuminanceSource luminanceSource = this.getLuminanceSource();
        int n = luminanceSource.getWidth();
        int n2 = luminanceSource.getHeight();
        if (n >= 40 && n2 >= 40) {
            byte[] byArray = luminanceSource.getMatrix();
            int n3 = n >> 3;
            if ((n & 7) != 0) {
                ++n3;
            }
            int n4 = n2 >> 3;
            if ((n2 & 7) != 0) {
                ++n4;
            }
            int[][] nArray = HybridBinarizer.calculateBlackPoints(byArray, n3, n4, n, n2);
            BitMatrix bitMatrix = new BitMatrix(n, n2);
            HybridBinarizer.calculateThresholdForBlock(byArray, n3, n4, n, n2, nArray, bitMatrix);
            this.matrix = bitMatrix;
        } else {
            this.matrix = super.getBlackMatrix();
        }
        return this.matrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new HybridBinarizer(luminanceSource);
    }

    private static void calculateThresholdForBlock(byte[] byArray, int n, int n2, int n3, int n4, int[][] nArray, BitMatrix bitMatrix) {
        for (int i = 0; i < n2; ++i) {
            int n5 = i << 3;
            int n6 = n4 - 8;
            if (n5 > n6) {
                n5 = n6;
            }
            for (int j = 0; j < n; ++j) {
                int n7;
                int n8 = j << 3;
                int n9 = n3 - 8;
                if (n8 > n9) {
                    n8 = n9;
                }
                int n10 = HybridBinarizer.cap(j, 2, n - 3);
                int n11 = HybridBinarizer.cap(i, 2, n2 - 3);
                int n12 = 0;
                for (n7 = -2; n7 <= 2; ++n7) {
                    int[] nArray2 = nArray[n11 + n7];
                    n12 += nArray2[n10 - 2] + nArray2[n10 - 1] + nArray2[n10] + nArray2[n10 + 1] + nArray2[n10 + 2];
                }
                n7 = n12 / 25;
                HybridBinarizer.thresholdBlock(byArray, n8, n5, n7, n3, bitMatrix);
            }
        }
    }

    private static int cap(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    private static void thresholdBlock(byte[] byArray, int n, int n2, int n3, int n4, BitMatrix bitMatrix) {
        int n5 = 0;
        int n6 = n2 * n4 + n;
        while (n5 < 8) {
            for (int i = 0; i < 8; ++i) {
                if ((byArray[n6 + i] & 0xFF) > n3) continue;
                bitMatrix.set(n + i, n2 + n5);
            }
            ++n5;
            n6 += n4;
        }
    }

    private static int[][] calculateBlackPoints(byte[] byArray, int n, int n2, int n3, int n4) {
        int[][] nArray = new int[n2][n];
        for (int i = 0; i < n2; ++i) {
            int n5 = i << 3;
            int n6 = n4 - 8;
            if (n5 > n6) {
                n5 = n6;
            }
            for (int j = 0; j < n; ++j) {
                int n7 = j << 3;
                int n8 = n3 - 8;
                if (n7 > n8) {
                    n7 = n8;
                }
                int n9 = 0;
                int n10 = 255;
                int n11 = 0;
                int n12 = 0;
                int n13 = n5 * n3 + n7;
                while (n12 < 8) {
                    int n14;
                    for (n14 = 0; n14 < 8; ++n14) {
                        int n15 = byArray[n13 + n14] & 0xFF;
                        n9 += n15;
                        if (n15 < n10) {
                            n10 = n15;
                        }
                        if (n15 <= n11) continue;
                        n11 = n15;
                    }
                    if (n11 - n10 > 24) {
                        ++n12;
                        n13 += n3;
                        while (n12 < 8) {
                            for (n14 = 0; n14 < 8; ++n14) {
                                n9 += byArray[n13 + n14] & 0xFF;
                            }
                            ++n12;
                            n13 += n3;
                        }
                    }
                    ++n12;
                    n13 += n3;
                }
                n12 = n9 >> 6;
                if (n11 - n10 <= 24) {
                    n12 = n10 >> 1;
                    if (i > 0 && j > 0 && n10 < (n13 = nArray[i - 1][j] + 2 * nArray[i][j - 1] + nArray[i - 1][j - 1] >> 2)) {
                        n12 = n13;
                    }
                }
                nArray[i][j] = n12;
            }
        }
        return nArray;
    }
}

