/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GenericGFPoly;

public final class GenericGF {
    public static final GenericGF AZTEC_DATA_12 = new GenericGF(4201, 4096, 1);
    public static final GenericGF AZTEC_DATA_10 = new GenericGF(1033, 1024, 1);
    public static final GenericGF AZTEC_DATA_6 = new GenericGF(67, 64, 1);
    public static final GenericGF AZTEC_PARAM = new GenericGF(19, 16, 1);
    public static final GenericGF QR_CODE_FIELD_256 = new GenericGF(285, 256, 0);
    public static final GenericGF DATA_MATRIX_FIELD_256;
    public static final GenericGF AZTEC_DATA_8;
    public static final GenericGF MAXICODE_FIELD_64;
    private static final int INITIALIZATION_THRESHOLD = 0;
    private int[] expTable;
    private int[] logTable;
    private GenericGFPoly zero;
    private GenericGFPoly one;
    private final int size;
    private final int primitive;
    private final int generatorBase;
    private boolean initialized = false;

    public GenericGF(int n, int n2, int n3) {
        this.primitive = n;
        this.size = n2;
        this.generatorBase = n3;
        if (n2 <= 0) {
            this.initialize();
        }
    }

    private void initialize() {
        int n;
        this.expTable = new int[this.size];
        this.logTable = new int[this.size];
        int n2 = 1;
        for (n = 0; n < this.size; ++n) {
            this.expTable[n] = n2;
            if ((n2 <<= 1) < this.size) continue;
            n2 ^= this.primitive;
            n2 &= this.size - 1;
        }
        for (n = 0; n < this.size - 1; ++n) {
            this.logTable[this.expTable[n]] = n;
        }
        this.zero = new GenericGFPoly(this, new int[]{0});
        this.one = new GenericGFPoly(this, new int[]{1});
        this.initialized = true;
    }

    private void checkInit() {
        if (!this.initialized) {
            this.initialize();
        }
    }

    GenericGFPoly getZero() {
        this.checkInit();
        return this.zero;
    }

    GenericGFPoly getOne() {
        this.checkInit();
        return this.one;
    }

    GenericGFPoly buildMonomial(int n, int n2) {
        this.checkInit();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            return this.zero;
        }
        int[] nArray = new int[n + 1];
        nArray[0] = n2;
        return new GenericGFPoly(this, nArray);
    }

    static int addOrSubtract(int n, int n2) {
        return n ^ n2;
    }

    int exp(int n) {
        this.checkInit();
        return this.expTable[n];
    }

    int log(int n) {
        this.checkInit();
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        return this.logTable[n];
    }

    int inverse(int n) {
        this.checkInit();
        if (n == 0) {
            throw new ArithmeticException();
        }
        return this.expTable[this.size - this.logTable[n] - 1];
    }

    int multiply(int n, int n2) {
        this.checkInit();
        if (n == 0 || n2 == 0) {
            return 0;
        }
        return this.expTable[(this.logTable[n] + this.logTable[n2]) % (this.size - 1)];
    }

    public int getSize() {
        return this.size;
    }

    public int getGeneratorBase() {
        return this.generatorBase;
    }

    public String toString() {
        return "GF(0x" + Integer.toHexString(this.primitive) + "," + this.size + ")";
    }

    static {
        AZTEC_DATA_8 = DATA_MATRIX_FIELD_256 = new GenericGF(301, 256, 1);
        MAXICODE_FIELD_64 = AZTEC_DATA_6;
    }
}

