/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GenericGF;

final class GenericGFPoly {
    private final GenericGF field;
    private final int[] coefficients;

    GenericGFPoly(GenericGF genericGF, int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.field = genericGF;
        int n = nArray.length;
        if (n > 1 && nArray[0] == 0) {
            int n2;
            for (n2 = 1; n2 < n && nArray[n2] == 0; ++n2) {
            }
            if (n2 == n) {
                this.coefficients = genericGF.getZero().coefficients;
            } else {
                this.coefficients = new int[n - n2];
                System.arraycopy(nArray, n2, this.coefficients, 0, this.coefficients.length);
            }
        } else {
            this.coefficients = nArray;
        }
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int n) {
        return this.coefficients[this.coefficients.length - 1 - n];
    }

    int evaluateAt(int n) {
        if (n == 0) {
            return this.getCoefficient(0);
        }
        int n2 = this.coefficients.length;
        if (n == 1) {
            int n3 = 0;
            for (int n4 : this.coefficients) {
                n3 = GenericGF.addOrSubtract(n3, n4);
            }
            return n3;
        }
        int n5 = this.coefficients[0];
        for (int i = 1; i < n2; ++i) {
            n5 = GenericGF.addOrSubtract(this.field.multiply(n, n5), this.coefficients[i]);
        }
        return n5;
    }

    GenericGFPoly addOrSubtract(GenericGFPoly genericGFPoly) {
        int[] nArray;
        if (!this.field.equals(genericGFPoly.field)) {
            throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
        }
        if (this.isZero()) {
            return genericGFPoly;
        }
        if (genericGFPoly.isZero()) {
            return this;
        }
        int[] nArray2 = this.coefficients;
        int[] nArray3 = genericGFPoly.coefficients;
        if (nArray2.length > nArray3.length) {
            nArray = nArray2;
            nArray2 = nArray3;
            nArray3 = nArray;
        }
        nArray = new int[nArray3.length];
        int n = nArray3.length - nArray2.length;
        System.arraycopy(nArray3, 0, nArray, 0, n);
        for (int i = n; i < nArray3.length; ++i) {
            nArray[i] = GenericGF.addOrSubtract(nArray2[i - n], nArray3[i]);
        }
        return new GenericGFPoly(this.field, nArray);
    }

    GenericGFPoly multiply(GenericGFPoly genericGFPoly) {
        if (!this.field.equals(genericGFPoly.field)) {
            throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
        }
        if (this.isZero() || genericGFPoly.isZero()) {
            return this.field.getZero();
        }
        int[] nArray = this.coefficients;
        int n = nArray.length;
        int[] nArray2 = genericGFPoly.coefficients;
        int n2 = nArray2.length;
        int[] nArray3 = new int[n + n2 - 1];
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                nArray3[i + j] = GenericGF.addOrSubtract(nArray3[i + j], this.field.multiply(n3, nArray2[j]));
            }
        }
        return new GenericGFPoly(this.field, nArray3);
    }

    GenericGFPoly multiply(int n) {
        if (n == 0) {
            return this.field.getZero();
        }
        if (n == 1) {
            return this;
        }
        int n2 = this.coefficients.length;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.field.multiply(this.coefficients[i], n);
        }
        return new GenericGFPoly(this.field, nArray);
    }

    GenericGFPoly multiplyByMonomial(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            return this.field.getZero();
        }
        int n3 = this.coefficients.length;
        int[] nArray = new int[n3 + n];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.field.multiply(this.coefficients[i], n2);
        }
        return new GenericGFPoly(this.field, nArray);
    }

    GenericGFPoly[] divide(GenericGFPoly genericGFPoly) {
        if (!this.field.equals(genericGFPoly.field)) {
            throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
        }
        if (genericGFPoly.isZero()) {
            throw new IllegalArgumentException("Divide by 0");
        }
        GenericGFPoly genericGFPoly2 = this.field.getZero();
        GenericGFPoly genericGFPoly3 = this;
        int n = genericGFPoly.getCoefficient(genericGFPoly.getDegree());
        int n2 = this.field.inverse(n);
        while (genericGFPoly3.getDegree() >= genericGFPoly.getDegree() && !genericGFPoly3.isZero()) {
            int n3 = genericGFPoly3.getDegree() - genericGFPoly.getDegree();
            int n4 = this.field.multiply(genericGFPoly3.getCoefficient(genericGFPoly3.getDegree()), n2);
            GenericGFPoly genericGFPoly4 = genericGFPoly.multiplyByMonomial(n3, n4);
            GenericGFPoly genericGFPoly5 = this.field.buildMonomial(n3, n4);
            genericGFPoly2 = genericGFPoly2.addOrSubtract(genericGFPoly5);
            genericGFPoly3 = genericGFPoly3.addOrSubtract(genericGFPoly4);
        }
        return new GenericGFPoly[]{genericGFPoly2, genericGFPoly3};
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(8 * this.getDegree());
        for (int i = this.getDegree(); i >= 0; --i) {
            int n = this.getCoefficient(i);
            if (n == 0) continue;
            if (n < 0) {
                stringBuilder.append(" - ");
                n = -n;
            } else if (stringBuilder.length() > 0) {
                stringBuilder.append(" + ");
            }
            if (i == 0 || n != 1) {
                int n2 = this.field.log(n);
                if (n2 == 0) {
                    stringBuilder.append('1');
                } else if (n2 == 1) {
                    stringBuilder.append('a');
                } else {
                    stringBuilder.append("a^");
                    stringBuilder.append(n2);
                }
            }
            if (i == 0) continue;
            if (i == 1) {
                stringBuilder.append('x');
                continue;
            }
            stringBuilder.append("x^");
            stringBuilder.append(i);
        }
        return stringBuilder.toString();
    }
}

