/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.GenericGFPoly;
import java.util.ArrayList;
import java.util.List;

public final class ReedSolomonEncoder {
    private final GenericGF field;
    private final List<GenericGFPoly> cachedGenerators;

    public ReedSolomonEncoder(GenericGF genericGF) {
        this.field = genericGF;
        this.cachedGenerators = new ArrayList<GenericGFPoly>();
        this.cachedGenerators.add(new GenericGFPoly(genericGF, new int[]{1}));
    }

    private GenericGFPoly buildGenerator(int n) {
        if (n >= this.cachedGenerators.size()) {
            GenericGFPoly genericGFPoly = this.cachedGenerators.get(this.cachedGenerators.size() - 1);
            for (int i = this.cachedGenerators.size(); i <= n; ++i) {
                GenericGFPoly genericGFPoly2 = genericGFPoly.multiply(new GenericGFPoly(this.field, new int[]{1, this.field.exp(i - 1 + this.field.getGeneratorBase())}));
                this.cachedGenerators.add(genericGFPoly2);
                genericGFPoly = genericGFPoly2;
            }
        }
        return this.cachedGenerators.get(n);
    }

    public void encode(int[] nArray, int n) {
        if (n == 0) {
            throw new IllegalArgumentException("No error correction bytes");
        }
        int n2 = nArray.length - n;
        if (n2 <= 0) {
            throw new IllegalArgumentException("No data bytes provided");
        }
        GenericGFPoly genericGFPoly = this.buildGenerator(n);
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        GenericGFPoly genericGFPoly2 = new GenericGFPoly(this.field, nArray2);
        genericGFPoly2 = genericGFPoly2.multiplyByMonomial(n, 1);
        GenericGFPoly genericGFPoly3 = genericGFPoly2.divide(genericGFPoly)[1];
        int[] nArray3 = genericGFPoly3.getCoefficients();
        int n3 = n - nArray3.length;
        for (int i = 0; i < n3; ++i) {
            nArray[n2 + i] = 0;
        }
        System.arraycopy(nArray3, 0, nArray, n2 + n3, nArray3.length);
    }
}

