/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.datamatrix.decoder.Decoder;
import com.google.zxing.datamatrix.detector.Detector;
import java.util.List;
import java.util.Map;

public final class DataMatrixReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        String string;
        ResultPoint[] resultPointArray;
        DecoderResult decoderResult;
        Object object;
        if (map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            object = DataMatrixReader.extractPureBits(binaryBitmap.getBlackMatrix());
            decoderResult = this.decoder.decode((BitMatrix)object);
            resultPointArray = NO_POINTS;
        } else {
            object = new Detector(binaryBitmap.getBlackMatrix()).detect();
            decoderResult = this.decoder.decode(((DetectorResult)object).getBits());
            resultPointArray = ((DetectorResult)object).getPoints();
        }
        object = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.DATA_MATRIX);
        List<byte[]> list = decoderResult.getByteSegments();
        if (list != null) {
            ((Result)object).putMetadata(ResultMetadataType.BYTE_SEGMENTS, list);
        }
        if ((string = decoderResult.getECLevel()) != null) {
            ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string);
        }
        return object;
    }

    @Override
    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int[] nArray = bitMatrix.getTopLeftOnBit();
        int[] nArray2 = bitMatrix.getBottomRightOnBit();
        if (nArray == null || nArray2 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n = DataMatrixReader.moduleSize(nArray, bitMatrix);
        int n2 = nArray[1];
        int n3 = nArray2[1];
        int n4 = nArray[0];
        int n5 = nArray2[0];
        int n6 = (n5 - n4 + 1) / n;
        int n7 = (n3 - n2 + 1) / n;
        if (n6 <= 0 || n7 <= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n8 = n >> 1;
        n2 += n8;
        n4 += n8;
        BitMatrix bitMatrix2 = new BitMatrix(n6, n7);
        for (int i = 0; i < n7; ++i) {
            int n9 = n2 + i * n;
            for (int j = 0; j < n6; ++j) {
                if (!bitMatrix.get(n4 + j * n, n9)) continue;
                bitMatrix2.set(j, i);
            }
        }
        return bitMatrix2;
    }

    private static int moduleSize(int[] nArray, BitMatrix bitMatrix) throws NotFoundException {
        int n;
        int n2 = bitMatrix.getWidth();
        int n3 = nArray[1];
        for (n = nArray[0]; n < n2 && bitMatrix.get(n, n3); ++n) {
        }
        if (n == n2) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n4 = n - nArray[0];
        if (n4 == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n4;
    }
}

