/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Dimension;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.encoder.DefaultPlacement;
import com.google.zxing.datamatrix.encoder.ErrorCorrection;
import com.google.zxing.datamatrix.encoder.HighLevelEncoder;
import com.google.zxing.datamatrix.encoder.SymbolInfo;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import java.util.Map;

public final class DataMatrixWriter
implements Writer {
    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map<EncodeHintType, ?> map) {
        Object object;
        Object object2;
        Object object3;
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (barcodeFormat != BarcodeFormat.DATA_MATRIX) {
            throw new IllegalArgumentException("Can only encode DATA_MATRIX, but got " + barcodeFormat);
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + n + "x" + n2);
        }
        Object object4 = SymbolShapeHint.FORCE_NONE;
        Object object5 = null;
        Object object6 = null;
        if (map != null) {
            object3 = (SymbolShapeHint)((Object)map.get((Object)EncodeHintType.DATA_MATRIX_SHAPE));
            if (object3 != null) {
                object4 = object3;
            }
            if ((object2 = (Dimension)map.get((Object)EncodeHintType.MIN_SIZE)) != null) {
                object5 = object2;
            }
            if ((object = (Dimension)map.get((Object)EncodeHintType.MAX_SIZE)) != null) {
                object6 = object;
            }
        }
        object3 = HighLevelEncoder.encodeHighLevel(string, object4, object5, object6);
        object2 = SymbolInfo.lookup(((String)object3).length(), object4, object5, object6, true);
        object = ErrorCorrection.encodeECC200((String)object3, (SymbolInfo)object2);
        DefaultPlacement defaultPlacement = new DefaultPlacement((CharSequence)object, ((SymbolInfo)object2).getSymbolDataWidth(), ((SymbolInfo)object2).getSymbolDataHeight());
        defaultPlacement.place();
        return DataMatrixWriter.encodeLowLevel(defaultPlacement, (SymbolInfo)object2);
    }

    private static BitMatrix encodeLowLevel(DefaultPlacement defaultPlacement, SymbolInfo symbolInfo) {
        int n = symbolInfo.getSymbolDataWidth();
        int n2 = symbolInfo.getSymbolDataHeight();
        ByteMatrix byteMatrix = new ByteMatrix(symbolInfo.getSymbolWidth(), symbolInfo.getSymbolHeight());
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5;
            if (i % symbolInfo.matrixHeight == 0) {
                n5 = 0;
                for (n4 = 0; n4 < symbolInfo.getSymbolWidth(); ++n4) {
                    byteMatrix.set(n5, n3, n4 % 2 == 0);
                    ++n5;
                }
                ++n3;
            }
            n5 = 0;
            for (n4 = 0; n4 < n; ++n4) {
                if (n4 % symbolInfo.matrixWidth == 0) {
                    byteMatrix.set(n5, n3, true);
                    ++n5;
                }
                byteMatrix.set(n5, n3, defaultPlacement.getBit(n4, i));
                ++n5;
                if (n4 % symbolInfo.matrixWidth != symbolInfo.matrixWidth - 1) continue;
                byteMatrix.set(n5, n3, i % 2 == 0);
                ++n5;
            }
            ++n3;
            if (i % symbolInfo.matrixHeight != symbolInfo.matrixHeight - 1) continue;
            n5 = 0;
            for (n4 = 0; n4 < symbolInfo.getSymbolWidth(); ++n4) {
                byteMatrix.set(n5, n3, true);
                ++n5;
            }
            ++n3;
        }
        return DataMatrixWriter.convertByteMatrixToBitMatrix(byteMatrix);
    }

    private static BitMatrix convertByteMatrixToBitMatrix(ByteMatrix byteMatrix) {
        int n = byteMatrix.getWidth();
        int n2 = byteMatrix.getHeight();
        BitMatrix bitMatrix = new BitMatrix(n, n2);
        bitMatrix.clear();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (byteMatrix.get(i, j) != 1) continue;
                bitMatrix.set(i, j);
            }
        }
        return bitMatrix;
    }
}

