/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitSource;
import com.google.zxing.common.DecoderResult;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;

final class DecodedBitStreamParser {
    private static final char[] C40_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] C40_SHIFT2_SET_CHARS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_'};
    private static final char[] TEXT_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] TEXT_SHIFT3_SET_CHARS = new char[]{'`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] byArray) throws FormatException {
        BitSource bitSource = new BitSource(byArray);
        StringBuilder stringBuilder = new StringBuilder(100);
        StringBuilder stringBuilder2 = new StringBuilder(0);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        Mode mode = Mode.ASCII_ENCODE;
        do {
            if (mode == Mode.ASCII_ENCODE) {
                mode = DecodedBitStreamParser.decodeAsciiSegment(bitSource, stringBuilder, stringBuilder2);
                continue;
            }
            switch (mode) {
                case C40_ENCODE: {
                    DecodedBitStreamParser.decodeC40Segment(bitSource, stringBuilder);
                    break;
                }
                case TEXT_ENCODE: {
                    DecodedBitStreamParser.decodeTextSegment(bitSource, stringBuilder);
                    break;
                }
                case ANSIX12_ENCODE: {
                    DecodedBitStreamParser.decodeAnsiX12Segment(bitSource, stringBuilder);
                    break;
                }
                case EDIFACT_ENCODE: {
                    DecodedBitStreamParser.decodeEdifactSegment(bitSource, stringBuilder);
                    break;
                }
                case BASE256_ENCODE: {
                    DecodedBitStreamParser.decodeBase256Segment(bitSource, stringBuilder, arrayList);
                    break;
                }
                default: {
                    throw FormatException.getFormatInstance();
                }
            }
            mode = Mode.ASCII_ENCODE;
        } while (mode != Mode.PAD_ENCODE && bitSource.available() > 0);
        if (stringBuilder2.length() > 0) {
            stringBuilder.append(stringBuilder2.toString());
        }
        return new DecoderResult(byArray, stringBuilder.toString(), arrayList.isEmpty() ? null : arrayList, null);
    }

    private static Mode decodeAsciiSegment(BitSource bitSource, StringBuilder stringBuilder, StringBuilder stringBuilder2) throws FormatException {
        boolean bl = false;
        do {
            int n;
            if ((n = bitSource.readBits(8)) == 0) {
                throw FormatException.getFormatInstance();
            }
            if (n <= 128) {
                if (bl) {
                    n += 128;
                }
                stringBuilder.append((char)(n - 1));
                return Mode.ASCII_ENCODE;
            }
            if (n == 129) {
                return Mode.PAD_ENCODE;
            }
            if (n <= 229) {
                int n2 = n - 130;
                if (n2 < 10) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(n2);
                continue;
            }
            if (n == 230) {
                return Mode.C40_ENCODE;
            }
            if (n == 231) {
                return Mode.BASE256_ENCODE;
            }
            if (n == 232) {
                stringBuilder.append('\u001d');
                continue;
            }
            if (n == 233 || n == 234) continue;
            if (n == 235) {
                bl = true;
                continue;
            }
            if (n == 236) {
                stringBuilder.append("[)>\u001e05\u001d");
                stringBuilder2.insert(0, "\u001e\u0004");
                continue;
            }
            if (n == 237) {
                stringBuilder.append("[)>\u001e06\u001d");
                stringBuilder2.insert(0, "\u001e\u0004");
                continue;
            }
            if (n == 238) {
                return Mode.ANSIX12_ENCODE;
            }
            if (n == 239) {
                return Mode.TEXT_ENCODE;
            }
            if (n == 240) {
                return Mode.EDIFACT_ENCODE;
            }
            if (n == 241 || n < 242 || n == 254 && bitSource.available() == 0) continue;
            throw FormatException.getFormatInstance();
        } while (bitSource.available() > 0);
        return Mode.ASCII_ENCODE;
    }

    private static void decodeC40Segment(BitSource bitSource, StringBuilder stringBuilder) throws FormatException {
        boolean bl = false;
        int[] nArray = new int[3];
        int n = 0;
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n2 = bitSource.readBits(8);
            if (n2 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n2, bitSource.readBits(8), nArray);
            block7: for (int i = 0; i < 3; ++i) {
                int n3 = nArray[i];
                switch (n) {
                    case 0: {
                        char c;
                        if (n3 < 3) {
                            n = n3 + 1;
                            continue block7;
                        }
                        if (n3 < C40_BASIC_SET_CHARS.length) {
                            c = C40_BASIC_SET_CHARS[n3];
                            if (bl) {
                                stringBuilder.append((char)(c + 128));
                                bl = false;
                                continue block7;
                            }
                            stringBuilder.append(c);
                            continue block7;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (bl) {
                            stringBuilder.append((char)(n3 + 128));
                            bl = false;
                        } else {
                            stringBuilder.append((char)n3);
                        }
                        n = 0;
                        continue block7;
                    }
                    case 2: {
                        char c;
                        if (n3 < C40_SHIFT2_SET_CHARS.length) {
                            c = C40_SHIFT2_SET_CHARS[n3];
                            if (bl) {
                                stringBuilder.append((char)(c + 128));
                                bl = false;
                            } else {
                                stringBuilder.append(c);
                            }
                        } else if (n3 == 27) {
                            stringBuilder.append('\u001d');
                        } else if (n3 == 30) {
                            bl = true;
                        } else {
                            throw FormatException.getFormatInstance();
                        }
                        n = 0;
                        continue block7;
                    }
                    case 3: {
                        if (bl) {
                            stringBuilder.append((char)(n3 + 224));
                            bl = false;
                        } else {
                            stringBuilder.append((char)(n3 + 96));
                        }
                        n = 0;
                        continue block7;
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeTextSegment(BitSource bitSource, StringBuilder stringBuilder) throws FormatException {
        boolean bl = false;
        int[] nArray = new int[3];
        int n = 0;
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n2 = bitSource.readBits(8);
            if (n2 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n2, bitSource.readBits(8), nArray);
            block7: for (int i = 0; i < 3; ++i) {
                int n3 = nArray[i];
                switch (n) {
                    case 0: {
                        char c;
                        if (n3 < 3) {
                            n = n3 + 1;
                            continue block7;
                        }
                        if (n3 < TEXT_BASIC_SET_CHARS.length) {
                            c = TEXT_BASIC_SET_CHARS[n3];
                            if (bl) {
                                stringBuilder.append((char)(c + 128));
                                bl = false;
                                continue block7;
                            }
                            stringBuilder.append(c);
                            continue block7;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (bl) {
                            stringBuilder.append((char)(n3 + 128));
                            bl = false;
                        } else {
                            stringBuilder.append((char)n3);
                        }
                        n = 0;
                        continue block7;
                    }
                    case 2: {
                        char c;
                        if (n3 < C40_SHIFT2_SET_CHARS.length) {
                            c = C40_SHIFT2_SET_CHARS[n3];
                            if (bl) {
                                stringBuilder.append((char)(c + 128));
                                bl = false;
                            } else {
                                stringBuilder.append(c);
                            }
                        } else if (n3 == 27) {
                            stringBuilder.append('\u001d');
                        } else if (n3 == 30) {
                            bl = true;
                        } else {
                            throw FormatException.getFormatInstance();
                        }
                        n = 0;
                        continue block7;
                    }
                    case 3: {
                        char c;
                        if (n3 < TEXT_SHIFT3_SET_CHARS.length) {
                            c = TEXT_SHIFT3_SET_CHARS[n3];
                            if (bl) {
                                stringBuilder.append((char)(c + 128));
                                bl = false;
                            } else {
                                stringBuilder.append(c);
                            }
                            n = 0;
                            continue block7;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeAnsiX12Segment(BitSource bitSource, StringBuilder stringBuilder) throws FormatException {
        int[] nArray = new int[3];
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n = bitSource.readBits(8);
            if (n == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n, bitSource.readBits(8), nArray);
            for (int i = 0; i < 3; ++i) {
                int n2 = nArray[i];
                if (n2 == 0) {
                    stringBuilder.append('\r');
                    continue;
                }
                if (n2 == 1) {
                    stringBuilder.append('*');
                    continue;
                }
                if (n2 == 2) {
                    stringBuilder.append('>');
                    continue;
                }
                if (n2 == 3) {
                    stringBuilder.append(' ');
                    continue;
                }
                if (n2 < 14) {
                    stringBuilder.append((char)(n2 + 44));
                    continue;
                }
                if (n2 < 40) {
                    stringBuilder.append((char)(n2 + 51));
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
        } while (bitSource.available() > 0);
    }

    private static void parseTwoBytes(int n, int n2, int[] nArray) {
        int n3;
        int n4 = (n << 8) + n2 - 1;
        nArray[0] = n3 = n4 / 1600;
        n4 -= n3 * 1600;
        nArray[1] = n3 = n4 / 40;
        nArray[2] = n4 - n3 * 40;
    }

    private static void decodeEdifactSegment(BitSource bitSource, StringBuilder stringBuilder) {
        do {
            if (bitSource.available() <= 16) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                int n = bitSource.readBits(6);
                if (n == 31) {
                    int n2 = 8 - bitSource.getBitOffset();
                    if (n2 != 8) {
                        bitSource.readBits(n2);
                    }
                    return;
                }
                if ((n & 0x20) == 0) {
                    n |= 0x40;
                }
                stringBuilder.append((char)n);
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeBase256Segment(BitSource bitSource, StringBuilder stringBuilder, Collection<byte[]> collection) throws FormatException {
        int n = 1 + bitSource.getByteOffset();
        int n2 = DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), n++);
        int n3 = n2 == 0 ? bitSource.available() / 8 : (n2 < 250 ? n2 : 250 * (n2 - 249) + DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), n++));
        if (n3 < 0) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            if (bitSource.available() < 8) {
                throw FormatException.getFormatInstance();
            }
            byArray[i] = (byte)DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), n++);
        }
        collection.add(byArray);
        try {
            stringBuilder.append(new String(byArray, "ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Platform does not support required encoding: " + unsupportedEncodingException);
        }
    }

    private static int unrandomize255State(int n, int n2) {
        int n3 = 149 * n2 % 255 + 1;
        int n4 = n - n3;
        return n4 >= 0 ? n4 : n4 + 256;
    }

    private static enum Mode {
        PAD_ENCODE,
        ASCII_ENCODE,
        C40_ENCODE,
        TEXT_ENCODE,
        ANSIX12_ENCODE,
        EDIFACT_ENCODE,
        BASE256_ENCODE;

    }
}

