/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.common.detector.WhiteRectangleDetector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class Detector {
    private final BitMatrix image;
    private final WhiteRectangleDetector rectangleDetector;

    public Detector(BitMatrix bitMatrix) throws NotFoundException {
        this.image = bitMatrix;
        this.rectangleDetector = new WhiteRectangleDetector(bitMatrix);
    }

    public DetectorResult detect() throws NotFoundException {
        BitMatrix bitMatrix;
        Object object;
        Object object2;
        ResultPoint resultPoint;
        ResultPoint[] resultPointArray = this.rectangleDetector.detect();
        ResultPoint resultPoint2 = resultPointArray[0];
        ResultPoint resultPoint3 = resultPointArray[1];
        ResultPoint resultPoint4 = resultPointArray[2];
        ResultPoint resultPoint5 = resultPointArray[3];
        ArrayList<ResultPointsAndTransitions> arrayList = new ArrayList<ResultPointsAndTransitions>(4);
        arrayList.add(this.transitionsBetween(resultPoint2, resultPoint3));
        arrayList.add(this.transitionsBetween(resultPoint2, resultPoint4));
        arrayList.add(this.transitionsBetween(resultPoint3, resultPoint5));
        arrayList.add(this.transitionsBetween(resultPoint4, resultPoint5));
        Collections.sort(arrayList, new ResultPointsAndTransitionsComparator());
        ResultPointsAndTransitions resultPointsAndTransitions = (ResultPointsAndTransitions)arrayList.get(0);
        ResultPointsAndTransitions resultPointsAndTransitions2 = (ResultPointsAndTransitions)arrayList.get(1);
        HashMap<ResultPoint, Integer> hashMap = new HashMap<ResultPoint, Integer>();
        Detector.increment(hashMap, resultPointsAndTransitions.getFrom());
        Detector.increment(hashMap, resultPointsAndTransitions.getTo());
        Detector.increment(hashMap, resultPointsAndTransitions2.getFrom());
        Detector.increment(hashMap, resultPointsAndTransitions2.getTo());
        ResultPoint resultPoint6 = null;
        ResultPoint resultPoint7 = null;
        ResultPoint resultPoint8 = null;
        for (Map.Entry object32 : hashMap.entrySet()) {
            resultPoint = (ResultPoint)object32.getKey();
            object2 = (Integer)object32.getValue();
            if ((Integer)object2 == 2) {
                resultPoint7 = resultPoint;
                continue;
            }
            if (resultPoint6 == null) {
                resultPoint6 = resultPoint;
                continue;
            }
            resultPoint8 = resultPoint;
        }
        if (resultPoint6 == null || resultPoint7 == null || resultPoint8 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        ResultPoint[] resultPointArray2 = new ResultPoint[]{resultPoint6, resultPoint7, resultPoint8};
        ResultPoint.orderBestPatterns(resultPointArray2);
        ResultPoint resultPoint9 = resultPointArray2[0];
        resultPoint7 = resultPointArray2[1];
        resultPoint = resultPointArray2[2];
        object2 = !hashMap.containsKey(resultPoint2) ? resultPoint2 : (!hashMap.containsKey(resultPoint3) ? resultPoint3 : (!hashMap.containsKey(resultPoint4) ? resultPoint4 : resultPoint5));
        int n = this.transitionsBetween(resultPoint, (ResultPoint)object2).getTransitions();
        int n2 = this.transitionsBetween(resultPoint9, (ResultPoint)object2).getTransitions();
        if ((n & 1) == 1) {
            ++n;
        }
        n += 2;
        if ((n2 & 1) == 1) {
            ++n2;
        }
        if (4 * n >= 7 * (n2 += 2) || 4 * n2 >= 7 * n) {
            object = this.correctTopRightRectangular(resultPoint7, resultPoint9, resultPoint, (ResultPoint)object2, n, n2);
            if (object == null) {
                object = object2;
            }
            n = this.transitionsBetween(resultPoint, (ResultPoint)object).getTransitions();
            n2 = this.transitionsBetween(resultPoint9, (ResultPoint)object).getTransitions();
            if ((n & 1) == 1) {
                ++n;
            }
            if ((n2 & 1) == 1) {
                ++n2;
            }
            bitMatrix = Detector.sampleGrid(this.image, resultPoint, resultPoint7, resultPoint9, (ResultPoint)object, n, n2);
        } else {
            int n3 = Math.min(n2, n);
            object = this.correctTopRight(resultPoint7, resultPoint9, resultPoint, (ResultPoint)object2, n3);
            if (object == null) {
                object = object2;
            }
            int n4 = Math.max(this.transitionsBetween(resultPoint, (ResultPoint)object).getTransitions(), this.transitionsBetween(resultPoint9, (ResultPoint)object).getTransitions());
            if ((++n4 & 1) == 1) {
                ++n4;
            }
            bitMatrix = Detector.sampleGrid(this.image, resultPoint, resultPoint7, resultPoint9, (ResultPoint)object, n4, n4);
        }
        return new DetectorResult(bitMatrix, new ResultPoint[]{resultPoint, resultPoint7, resultPoint9, object});
    }

    private ResultPoint correctTopRightRectangular(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n, int n2) {
        int n3;
        float f = (float)Detector.distance(resultPoint, resultPoint2) / (float)n;
        int n4 = Detector.distance(resultPoint3, resultPoint4);
        float f2 = (resultPoint4.getX() - resultPoint3.getX()) / (float)n4;
        float f3 = (resultPoint4.getY() - resultPoint3.getY()) / (float)n4;
        ResultPoint resultPoint5 = new ResultPoint(resultPoint4.getX() + f * f2, resultPoint4.getY() + f * f3);
        f = (float)Detector.distance(resultPoint, resultPoint3) / (float)n2;
        n4 = Detector.distance(resultPoint2, resultPoint4);
        f2 = (resultPoint4.getX() - resultPoint2.getX()) / (float)n4;
        f3 = (resultPoint4.getY() - resultPoint2.getY()) / (float)n4;
        ResultPoint resultPoint6 = new ResultPoint(resultPoint4.getX() + f * f2, resultPoint4.getY() + f * f3);
        if (!this.isValid(resultPoint5)) {
            if (this.isValid(resultPoint6)) {
                return resultPoint6;
            }
            return null;
        }
        if (!this.isValid(resultPoint6)) {
            return resultPoint5;
        }
        int n5 = Math.abs(n - this.transitionsBetween(resultPoint3, resultPoint5).getTransitions()) + Math.abs(n2 - this.transitionsBetween(resultPoint2, resultPoint5).getTransitions());
        if (n5 <= (n3 = Math.abs(n - this.transitionsBetween(resultPoint3, resultPoint6).getTransitions()) + Math.abs(n2 - this.transitionsBetween(resultPoint2, resultPoint6).getTransitions()))) {
            return resultPoint5;
        }
        return resultPoint6;
    }

    private ResultPoint correctTopRight(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n) {
        int n2;
        float f = (float)Detector.distance(resultPoint, resultPoint2) / (float)n;
        int n3 = Detector.distance(resultPoint3, resultPoint4);
        float f2 = (resultPoint4.getX() - resultPoint3.getX()) / (float)n3;
        float f3 = (resultPoint4.getY() - resultPoint3.getY()) / (float)n3;
        ResultPoint resultPoint5 = new ResultPoint(resultPoint4.getX() + f * f2, resultPoint4.getY() + f * f3);
        f = (float)Detector.distance(resultPoint, resultPoint3) / (float)n;
        n3 = Detector.distance(resultPoint2, resultPoint4);
        f2 = (resultPoint4.getX() - resultPoint2.getX()) / (float)n3;
        f3 = (resultPoint4.getY() - resultPoint2.getY()) / (float)n3;
        ResultPoint resultPoint6 = new ResultPoint(resultPoint4.getX() + f * f2, resultPoint4.getY() + f * f3);
        if (!this.isValid(resultPoint5)) {
            if (this.isValid(resultPoint6)) {
                return resultPoint6;
            }
            return null;
        }
        if (!this.isValid(resultPoint6)) {
            return resultPoint5;
        }
        int n4 = Math.abs(this.transitionsBetween(resultPoint3, resultPoint5).getTransitions() - this.transitionsBetween(resultPoint2, resultPoint5).getTransitions());
        return n4 <= (n2 = Math.abs(this.transitionsBetween(resultPoint3, resultPoint6).getTransitions() - this.transitionsBetween(resultPoint2, resultPoint6).getTransitions())) ? resultPoint5 : resultPoint6;
    }

    private boolean isValid(ResultPoint resultPoint) {
        return resultPoint.getX() >= 0.0f && resultPoint.getX() < (float)this.image.getWidth() && resultPoint.getY() > 0.0f && resultPoint.getY() < (float)this.image.getHeight();
    }

    private static int distance(ResultPoint resultPoint, ResultPoint resultPoint2) {
        return MathUtils.round(ResultPoint.distance(resultPoint, resultPoint2));
    }

    private static void increment(Map<ResultPoint, Integer> map, ResultPoint resultPoint) {
        Integer n = map.get(resultPoint);
        map.put(resultPoint, n == null ? 1 : n + 1);
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n, int n2) throws NotFoundException {
        GridSampler gridSampler = GridSampler.getInstance();
        return gridSampler.sampleGrid(bitMatrix, n, n2, 0.5f, 0.5f, (float)n - 0.5f, 0.5f, (float)n - 0.5f, (float)n2 - 0.5f, 0.5f, (float)n2 - 0.5f, resultPoint.getX(), resultPoint.getY(), resultPoint4.getX(), resultPoint4.getY(), resultPoint3.getX(), resultPoint3.getY(), resultPoint2.getX(), resultPoint2.getY());
    }

    private ResultPointsAndTransitions transitionsBetween(ResultPoint resultPoint, ResultPoint resultPoint2) {
        int n;
        boolean bl;
        int n2 = (int)resultPoint.getX();
        int n3 = (int)resultPoint.getY();
        int n4 = (int)resultPoint2.getX();
        int n5 = (int)resultPoint2.getY();
        boolean bl2 = bl = Math.abs(n5 - n3) > Math.abs(n4 - n2);
        if (bl) {
            n = n2;
            n2 = n3;
            n3 = n;
            n = n4;
            n4 = n5;
            n5 = n;
        }
        n = Math.abs(n4 - n2);
        int n6 = Math.abs(n5 - n3);
        int n7 = -n >> 1;
        int n8 = n3 < n5 ? 1 : -1;
        int n9 = n2 < n4 ? 1 : -1;
        int n10 = 0;
        boolean bl3 = this.image.get(bl ? n3 : n2, bl ? n2 : n3);
        int n11 = n3;
        for (int i = n2; i != n4; i += n9) {
            boolean bl4 = this.image.get(bl ? n11 : i, bl ? i : n11);
            if (bl4 != bl3) {
                ++n10;
                bl3 = bl4;
            }
            if ((n7 += n6) <= 0) continue;
            if (n11 == n5) break;
            n11 += n8;
            n7 -= n;
        }
        return new ResultPointsAndTransitions(resultPoint, resultPoint2, n10);
    }

    private static final class ResultPointsAndTransitionsComparator
    implements Comparator<ResultPointsAndTransitions>,
    Serializable {
        private static final long serialVersionUID = -2873124846607568824L;

        private ResultPointsAndTransitionsComparator() {
        }

        @Override
        public int compare(ResultPointsAndTransitions resultPointsAndTransitions, ResultPointsAndTransitions resultPointsAndTransitions2) {
            return resultPointsAndTransitions.getTransitions() - resultPointsAndTransitions2.getTransitions();
        }
    }

    private static final class ResultPointsAndTransitions {
        private final ResultPoint from;
        private final ResultPoint to;
        private final int transitions;

        private ResultPointsAndTransitions(ResultPoint resultPoint, ResultPoint resultPoint2, int n) {
            this.from = resultPoint;
            this.to = resultPoint2;
            this.transitions = n;
        }

        ResultPoint getFrom() {
            return this.from;
        }

        ResultPoint getTo() {
            return this.to;
        }

        public int getTransitions() {
            return this.transitions;
        }

        public String toString() {
            return this.from + "/" + this.to + "/" + this.transitions;
        }
    }
}

