/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import com.google.zxing.datamatrix.encoder.Encoder;
import com.google.zxing.datamatrix.encoder.EncoderContext;
import com.google.zxing.datamatrix.encoder.HighLevelEncoder;

final class Base256Encoder
implements Encoder {
    Base256Encoder() {
    }

    @Override
    public int getEncodingMode() {
        return 5;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        boolean bl;
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\u0000');
        while (encoderContext.hasMoreCharacters()) {
            n2 = encoderContext.getCurrentChar();
            stringBuilder.append((char)n2);
            ++encoderContext.pos;
            n = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode());
            if (n == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(n);
            break;
        }
        n2 = stringBuilder.length() - 1;
        n = 1;
        int n3 = encoderContext.getCodewordCount() + n2 + n;
        encoderContext.updateSymbolInfo(n3);
        boolean bl2 = bl = encoderContext.getSymbolInfo().getDataCapacity() - n3 > 0;
        if (encoderContext.hasMoreCharacters() || bl) {
            if (n2 <= 249) {
                stringBuilder.setCharAt(0, (char)n2);
            } else if (n2 > 249 && n2 <= 1555) {
                stringBuilder.setCharAt(0, (char)(n2 / 250 + 249));
                stringBuilder.insert(1, (char)(n2 % 250));
            } else {
                throw new IllegalStateException("Message length not in valid ranges: " + n2);
            }
        }
        int n4 = stringBuilder.length();
        for (int i = 0; i < n4; ++i) {
            encoderContext.writeCodeword(Base256Encoder.randomize255State(stringBuilder.charAt(i), encoderContext.getCodewordCount() + 1));
        }
    }

    private static char randomize255State(char c, int n) {
        int n2 = 149 * n % 255 + 1;
        int n3 = c + n2;
        if (n3 <= 255) {
            return (char)n3;
        }
        return (char)(n3 - 256);
    }
}

