/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import com.google.zxing.datamatrix.encoder.Encoder;
import com.google.zxing.datamatrix.encoder.EncoderContext;
import com.google.zxing.datamatrix.encoder.HighLevelEncoder;

final class EdifactEncoder
implements Encoder {
    EdifactEncoder() {
    }

    @Override
    public int getEncodingMode() {
        return 4;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        StringBuilder stringBuilder = new StringBuilder();
        while (encoderContext.hasMoreCharacters()) {
            char c = encoderContext.getCurrentChar();
            EdifactEncoder.encodeChar(c, stringBuilder);
            ++encoderContext.pos;
            int n = stringBuilder.length();
            if (n < 4) continue;
            encoderContext.writeCodewords(EdifactEncoder.encodeToCodewords(stringBuilder, 0));
            stringBuilder.delete(0, 4);
            int n2 = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode());
            if (n2 == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(0);
            break;
        }
        stringBuilder.append('\u001f');
        EdifactEncoder.handleEOD(encoderContext, stringBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleEOD(EncoderContext encoderContext, CharSequence charSequence) {
        try {
            boolean bl;
            int n;
            int n2 = charSequence.length();
            if (n2 == 0) {
                return;
            }
            if (n2 == 1) {
                encoderContext.updateSymbolInfo();
                n = encoderContext.getSymbolInfo().getDataCapacity() - encoderContext.getCodewordCount();
                int n3 = encoderContext.getRemainingCharacters();
                if (n3 == 0 && n <= 2) {
                    return;
                }
            }
            if (n2 > 4) {
                throw new IllegalStateException("Count must not exceed 4");
            }
            n = n2 - 1;
            String string = EdifactEncoder.encodeToCodewords(charSequence, 0);
            boolean bl2 = !encoderContext.hasMoreCharacters();
            boolean bl3 = bl = bl2 && n <= 2;
            if (n <= 2) {
                encoderContext.updateSymbolInfo(encoderContext.getCodewordCount() + n);
                int n4 = encoderContext.getSymbolInfo().getDataCapacity() - encoderContext.getCodewordCount();
                if (n4 >= 3) {
                    bl = false;
                    encoderContext.updateSymbolInfo(encoderContext.getCodewordCount() + string.length());
                }
            }
            if (bl) {
                encoderContext.resetSymbolInfo();
                encoderContext.pos -= n;
            } else {
                encoderContext.writeCodewords(string);
            }
        }
        finally {
            encoderContext.signalEncoderChange(0);
        }
    }

    private static void encodeChar(char c, StringBuilder stringBuilder) {
        if (c >= ' ' && c <= '?') {
            stringBuilder.append(c);
        } else if (c >= '@' && c <= '^') {
            stringBuilder.append((char)(c - 64));
        } else {
            HighLevelEncoder.illegalCharacter(c);
        }
    }

    private static String encodeToCodewords(CharSequence charSequence, int n) {
        int n2 = charSequence.length() - n;
        if (n2 == 0) {
            throw new IllegalStateException("StringBuilder must not be empty");
        }
        char c = charSequence.charAt(n);
        char c2 = n2 >= 2 ? charSequence.charAt(n + 1) : (char)'\u0000';
        char c3 = n2 >= 3 ? charSequence.charAt(n + 2) : (char)'\u0000';
        char c4 = n2 >= 4 ? charSequence.charAt(n + 3) : (char)'\u0000';
        int n3 = (c << 18) + (c2 << 12) + (c3 << 6) + c4;
        char c5 = (char)(n3 >> 16 & 0xFF);
        char c6 = (char)(n3 >> 8 & 0xFF);
        char c7 = (char)(n3 & 0xFF);
        StringBuilder stringBuilder = new StringBuilder(3);
        stringBuilder.append(c5);
        if (n2 >= 2) {
            stringBuilder.append(c6);
        }
        if (n2 >= 3) {
            stringBuilder.append(c7);
        }
        return stringBuilder.toString();
    }
}

