/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import com.google.zxing.Dimension;
import com.google.zxing.datamatrix.encoder.SymbolInfo;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import java.nio.charset.Charset;

final class EncoderContext {
    private final String msg;
    private SymbolShapeHint shape;
    private Dimension minSize;
    private Dimension maxSize;
    private final StringBuilder codewords;
    int pos;
    private int newEncoding;
    private SymbolInfo symbolInfo;
    private int skipAtEnd;

    EncoderContext(String string) {
        byte[] byArray = string.getBytes(Charset.forName("ISO-8859-1"));
        StringBuilder stringBuilder = new StringBuilder(byArray.length);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            if (c == '?' && string.charAt(i) != '?') {
                throw new IllegalArgumentException("Message contains characters outside ISO-8859-1 encoding.");
            }
            stringBuilder.append(c);
        }
        this.msg = stringBuilder.toString();
        this.shape = SymbolShapeHint.FORCE_NONE;
        this.codewords = new StringBuilder(string.length());
        this.newEncoding = -1;
    }

    public void setSymbolShape(SymbolShapeHint symbolShapeHint) {
        this.shape = symbolShapeHint;
    }

    public void setSizeConstraints(Dimension dimension, Dimension dimension2) {
        this.minSize = dimension;
        this.maxSize = dimension2;
    }

    public String getMessage() {
        return this.msg;
    }

    public void setSkipAtEnd(int n) {
        this.skipAtEnd = n;
    }

    public char getCurrentChar() {
        return this.msg.charAt(this.pos);
    }

    public char getCurrent() {
        return this.msg.charAt(this.pos);
    }

    public StringBuilder getCodewords() {
        return this.codewords;
    }

    public void writeCodewords(String string) {
        this.codewords.append(string);
    }

    public void writeCodeword(char c) {
        this.codewords.append(c);
    }

    public int getCodewordCount() {
        return this.codewords.length();
    }

    public int getNewEncoding() {
        return this.newEncoding;
    }

    public void signalEncoderChange(int n) {
        this.newEncoding = n;
    }

    public void resetEncoderSignal() {
        this.newEncoding = -1;
    }

    public boolean hasMoreCharacters() {
        return this.pos < this.getTotalMessageCharCount();
    }

    private int getTotalMessageCharCount() {
        return this.msg.length() - this.skipAtEnd;
    }

    public int getRemainingCharacters() {
        return this.getTotalMessageCharCount() - this.pos;
    }

    public SymbolInfo getSymbolInfo() {
        return this.symbolInfo;
    }

    public void updateSymbolInfo() {
        this.updateSymbolInfo(this.getCodewordCount());
    }

    public void updateSymbolInfo(int n) {
        if (this.symbolInfo == null || n > this.symbolInfo.getDataCapacity()) {
            this.symbolInfo = SymbolInfo.lookup(n, this.shape, this.minSize, this.maxSize, true);
        }
    }

    public void resetSymbolInfo() {
        this.symbolInfo = null;
    }
}

