/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import com.google.zxing.datamatrix.encoder.C40Encoder;
import com.google.zxing.datamatrix.encoder.EncoderContext;
import com.google.zxing.datamatrix.encoder.HighLevelEncoder;

final class X12Encoder
extends C40Encoder {
    X12Encoder() {
    }

    @Override
    public int getEncodingMode() {
        return 3;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        StringBuilder stringBuilder = new StringBuilder();
        while (encoderContext.hasMoreCharacters()) {
            char c = encoderContext.getCurrentChar();
            ++encoderContext.pos;
            this.encodeChar(c, stringBuilder);
            int n = stringBuilder.length();
            if (n % 3 != 0) continue;
            X12Encoder.writeNextTriplet(encoderContext, stringBuilder);
            int n2 = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode());
            if (n2 == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(n2);
            break;
        }
        this.handleEOD(encoderContext, stringBuilder);
    }

    @Override
    int encodeChar(char c, StringBuilder stringBuilder) {
        if (c == '\r') {
            stringBuilder.append('\u0000');
        } else if (c == '*') {
            stringBuilder.append('\u0001');
        } else if (c == '>') {
            stringBuilder.append('\u0002');
        } else if (c == ' ') {
            stringBuilder.append('\u0003');
        } else if (c >= '0' && c <= '9') {
            stringBuilder.append((char)(c - 48 + 4));
        } else if (c >= 'A' && c <= 'Z') {
            stringBuilder.append((char)(c - 65 + 14));
        } else {
            HighLevelEncoder.illegalCharacter(c);
        }
        return 1;
    }

    @Override
    void handleEOD(EncoderContext encoderContext, StringBuilder stringBuilder) {
        encoderContext.updateSymbolInfo();
        int n = encoderContext.getSymbolInfo().getDataCapacity() - encoderContext.getCodewordCount();
        int n2 = stringBuilder.length();
        if (n2 == 2) {
            encoderContext.writeCodeword('\u00fe');
            encoderContext.pos -= 2;
            encoderContext.signalEncoderChange(0);
        } else if (n2 == 1) {
            --encoderContext.pos;
            if (n > 1) {
                encoderContext.writeCodeword('\u00fe');
            }
            encoderContext.signalEncoderChange(0);
        }
    }
}

