/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.maxicode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.maxicode.decoder.Decoder;
import java.util.Map;

public final class MaxiCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private static final int MATRIX_WIDTH = 30;
    private static final int MATRIX_HEIGHT = 33;
    private final Decoder decoder = new Decoder();

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        if (map == null || !map.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            throw NotFoundException.getNotFoundInstance();
        }
        ResultPoint[] resultPointArray = MaxiCodeReader.extractPureBits(binaryBitmap.getBlackMatrix());
        DecoderResult decoderResult = this.decoder.decode((BitMatrix)resultPointArray, map);
        resultPointArray = NO_POINTS;
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.MAXICODE);
        String string = decoderResult.getECLevel();
        if (string != null) {
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string);
        }
        return result;
    }

    @Override
    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int[] nArray = bitMatrix.getEnclosingRectangle();
        if (nArray == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        BitMatrix bitMatrix2 = new BitMatrix(30, 33);
        for (int i = 0; i < 33; ++i) {
            int n5 = n2 + (i * n4 + n4 / 2) / 33;
            for (int j = 0; j < 30; ++j) {
                int n6 = n + (j * n3 + n3 / 2 + (i & 1) * n3 / 2) / 30;
                if (!bitMatrix.get(n6, n5)) continue;
                bitMatrix2.set(j, i);
            }
        }
        return bitMatrix2;
    }
}

