/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import java.util.Map;

public final class ByQuadrantReader
implements Reader {
    private final Reader delegate;

    public ByQuadrantReader(Reader reader) {
        this.delegate = reader;
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        int n = binaryBitmap.getWidth();
        int n2 = binaryBitmap.getHeight();
        int n3 = n / 2;
        int n4 = n2 / 2;
        BinaryBitmap binaryBitmap2 = binaryBitmap.crop(0, 0, n3, n4);
        try {
            return this.delegate.decode(binaryBitmap2, map);
        }
        catch (NotFoundException notFoundException) {
            BinaryBitmap binaryBitmap3 = binaryBitmap.crop(n3, 0, n3, n4);
            try {
                return this.delegate.decode(binaryBitmap3, map);
            }
            catch (NotFoundException notFoundException2) {
                BinaryBitmap binaryBitmap4 = binaryBitmap.crop(0, n4, n3, n4);
                try {
                    return this.delegate.decode(binaryBitmap4, map);
                }
                catch (NotFoundException notFoundException3) {
                    BinaryBitmap binaryBitmap5 = binaryBitmap.crop(n3, n4, n3, n4);
                    try {
                        return this.delegate.decode(binaryBitmap5, map);
                    }
                    catch (NotFoundException notFoundException4) {
                        int n5 = n3 / 2;
                        int n6 = n4 / 2;
                        BinaryBitmap binaryBitmap6 = binaryBitmap.crop(n5, n6, n3, n4);
                        return this.delegate.decode(binaryBitmap6, map);
                    }
                }
            }
        }
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }
}

