/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.multi.qrcode.detector.MultiFinderPatternFinder;
import com.google.zxing.qrcode.detector.Detector;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.ArrayList;
import java.util.Map;

public final class MultiDetector
extends Detector {
    private static final DetectorResult[] EMPTY_DETECTOR_RESULTS = new DetectorResult[0];

    public MultiDetector(BitMatrix bitMatrix) {
        super(bitMatrix);
    }

    public DetectorResult[] detectMulti(Map<DecodeHintType, ?> map) throws NotFoundException {
        ResultPointCallback resultPointCallback;
        BitMatrix bitMatrix = this.getImage();
        MultiFinderPatternFinder multiFinderPatternFinder = new MultiFinderPatternFinder(bitMatrix, resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK));
        FinderPatternInfo[] finderPatternInfoArray = multiFinderPatternFinder.findMulti(map);
        if (finderPatternInfoArray.length == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        ArrayList<DetectorResult> arrayList = new ArrayList<DetectorResult>();
        for (FinderPatternInfo finderPatternInfo : finderPatternInfoArray) {
            try {
                arrayList.add(this.processFinderPatternInfo(finderPatternInfo));
            }
            catch (ReaderException readerException) {
                // empty catch block
            }
        }
        if (arrayList.isEmpty()) {
            return EMPTY_DETECTOR_RESULTS;
        }
        return arrayList.toArray(new DetectorResult[arrayList.size()]);
    }
}

