/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class CodaBarReader
extends OneDReader {
    private static final int MAX_ACCEPTABLE = 512;
    private static final int PADDING = 384;
    private static final String ALPHABET_STRING = "0123456789-$:/.+ABCD";
    static final char[] ALPHABET = "0123456789-$:/.+ABCD".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{3, 6, 9, 96, 18, 66, 33, 36, 48, 72, 12, 24, 69, 81, 84, 21, 26, 41, 11, 14};
    private static final int MIN_CHARACTER_LENGTH = 3;
    private static final char[] STARTEND_ENCODING = new char[]{'A', 'B', 'C', 'D'};
    private final StringBuilder decodeRowResult = new StringBuilder(20);
    private int[] counters = new int[80];
    private int counterLength = 0;

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException {
        int n2;
        int n3;
        int n4;
        Arrays.fill(this.counters, 0);
        this.setCounters(bitArray);
        int n5 = n4 = this.findStartPattern();
        this.decodeRowResult.setLength(0);
        do {
            if ((n3 = this.toNarrowWidePattern(n5)) == -1) {
                throw NotFoundException.getNotFoundInstance();
            }
            this.decodeRowResult.append((char)n3);
        } while ((this.decodeRowResult.length() <= 1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[n3])) && (n5 += 8) < this.counterLength);
        n3 = this.counters[n5 - 1];
        int n6 = 0;
        for (n2 = -8; n2 < -1; ++n2) {
            n6 += this.counters[n5 + n2];
        }
        if (n5 < this.counterLength && n3 < n6 / 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.validatePattern(n4);
        for (n2 = 0; n2 < this.decodeRowResult.length(); ++n2) {
            this.decodeRowResult.setCharAt(n2, ALPHABET[this.decodeRowResult.charAt(n2)]);
        }
        n2 = this.decodeRowResult.charAt(0);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, (char)n2)) {
            throw NotFoundException.getNotFoundInstance();
        }
        char c = this.decodeRowResult.charAt(this.decodeRowResult.length() - 1);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, c)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (this.decodeRowResult.length() <= 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (map == null || !map.containsKey((Object)DecodeHintType.RETURN_CODABAR_START_END)) {
            this.decodeRowResult.deleteCharAt(this.decodeRowResult.length() - 1);
            this.decodeRowResult.deleteCharAt(0);
        }
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            n7 += this.counters[i];
        }
        float f = n7;
        for (int i = n4; i < n5 - 1; ++i) {
            n7 += this.counters[i];
        }
        float f2 = n7;
        return new Result(this.decodeRowResult.toString(), null, new ResultPoint[]{new ResultPoint(f, n), new ResultPoint(f2, n)}, BarcodeFormat.CODABAR);
    }

    void validatePattern(int n) throws NotFoundException {
        int n2;
        int n3;
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        int n4 = this.decodeRowResult.length() - 1;
        int n5 = n;
        int n6 = 0;
        while (true) {
            int n7 = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(n6)];
            for (n3 = 6; n3 >= 0; --n3) {
                int n8 = n2 = (n3 & 1) + (n7 & 1) * 2;
                nArray[n8] = nArray[n8] + this.counters[n5 + n3];
                int n9 = n2;
                nArray2[n9] = nArray2[n9] + 1;
                n7 >>= 1;
            }
            if (n6 >= n4) break;
            n5 += 8;
            ++n6;
        }
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        for (n3 = 0; n3 < 2; ++n3) {
            nArray4[n3] = 0;
            nArray4[n3 + 2] = (nArray[n3] << 8) / nArray2[n3] + (nArray[n3 + 2] << 8) / nArray2[n3 + 2] >> 1;
            nArray3[n3] = nArray4[n3 + 2];
            nArray3[n3 + 2] = (nArray[n3 + 2] * 512 + 384) / nArray2[n3 + 2];
        }
        n5 = n;
        n3 = 0;
        while (true) {
            n2 = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(n3)];
            for (int i = 6; i >= 0; --i) {
                int n10 = this.counters[n5 + i] << 8;
                int n11 = (i & 1) + (n2 & 1) * 2;
                if (n10 < nArray4[n11] || n10 > nArray3[n11]) {
                    throw NotFoundException.getNotFoundInstance();
                }
                n2 >>= 1;
            }
            if (n3 >= n4) break;
            n5 += 8;
            ++n3;
        }
    }

    private void setCounters(BitArray bitArray) throws NotFoundException {
        int n;
        this.counterLength = 0;
        int n2 = bitArray.getNextUnset(0);
        if (n2 >= (n = bitArray.getSize())) {
            throw NotFoundException.getNotFoundInstance();
        }
        boolean bl = true;
        int n3 = 0;
        while (n2 < n) {
            if (bitArray.get(n2) ^ bl) {
                ++n3;
            } else {
                this.counterAppend(n3);
                n3 = 1;
                bl = !bl;
            }
            ++n2;
        }
        this.counterAppend(n3);
    }

    private void counterAppend(int n) {
        this.counters[this.counterLength] = n;
        ++this.counterLength;
        if (this.counterLength >= this.counters.length) {
            int[] nArray = new int[this.counterLength * 2];
            System.arraycopy(this.counters, 0, nArray, 0, this.counterLength);
            this.counters = nArray;
        }
    }

    private int findStartPattern() throws NotFoundException {
        for (int i = 1; i < this.counterLength; i += 2) {
            int n = this.toNarrowWidePattern(i);
            if (n == -1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[n])) continue;
            int n2 = 0;
            for (int j = i; j < i + 7; ++j) {
                n2 += this.counters[j];
            }
            if (i != 1 && this.counters[i - 1] < n2 / 2) continue;
            return i;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static boolean arrayContains(char[] cArray, char c) {
        if (cArray != null) {
            for (char c2 : cArray) {
                if (c2 != c) continue;
                return true;
            }
        }
        return false;
    }

    private int toNarrowWidePattern(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n + 7;
        if (n7 >= this.counterLength) {
            return -1;
        }
        int[] nArray = this.counters;
        int n8 = 0;
        int n9 = Integer.MAX_VALUE;
        for (n6 = n; n6 < n7; n6 += 2) {
            n5 = nArray[n6];
            if (n5 < n9) {
                n9 = n5;
            }
            if (n5 <= n8) continue;
            n8 = n5;
        }
        n6 = (n9 + n8) / 2;
        n5 = 0;
        int n10 = Integer.MAX_VALUE;
        for (n4 = n + 1; n4 < n7; n4 += 2) {
            n3 = nArray[n4];
            if (n3 < n10) {
                n10 = n3;
            }
            if (n3 <= n5) continue;
            n5 = n3;
        }
        n4 = (n10 + n5) / 2;
        n3 = 128;
        int n11 = 0;
        for (n2 = 0; n2 < 7; ++n2) {
            int n12 = (n2 & 1) == 0 ? n6 : n4;
            n3 >>= 1;
            if (nArray[n + n2] <= n12) continue;
            n11 |= n3;
        }
        for (n2 = 0; n2 < CHARACTER_ENCODINGS.length; ++n2) {
            if (CHARACTER_ENCODINGS[n2] != n11) continue;
            return n2;
        }
        return -1;
    }
}

