/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.ArrayList;
import java.util.Map;

public final class Code128Reader
extends OneDReader {
    static final int[][] CODE_PATTERNS = new int[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}, {2, 3, 3, 1, 1, 1, 2}};
    private static final int MAX_AVG_VARIANCE = 64;
    private static final int MAX_INDIVIDUAL_VARIANCE = 179;
    private static final int CODE_SHIFT = 98;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_A = 101;
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_A = 101;
    private static final int CODE_FNC_4_B = 100;
    private static final int CODE_START_A = 103;
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_STOP = 106;

    private static int[] findStartPattern(BitArray bitArray) throws NotFoundException {
        int n = bitArray.getSize();
        int n2 = bitArray.getNextSet(0);
        int n3 = 0;
        int[] nArray = new int[6];
        int n4 = n2;
        boolean bl = false;
        int n5 = nArray.length;
        for (int i = n2; i < n; ++i) {
            if (bitArray.get(i) ^ bl) {
                int n6 = n3;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            if (n3 == n5 - 1) {
                int n7 = 64;
                int n8 = -1;
                for (int j = 103; j <= 105; ++j) {
                    int n9 = Code128Reader.patternMatchVariance(nArray, CODE_PATTERNS[j], 179);
                    if (n9 >= n7) continue;
                    n7 = n9;
                    n8 = j;
                }
                if (n8 >= 0 && bitArray.isRange(Math.max(0, n4 - (i - n4) / 2), n4, false)) {
                    return new int[]{n4, i, n8};
                }
                n4 += nArray[0] + nArray[1];
                System.arraycopy(nArray, 2, nArray, 0, n5 - 2);
                nArray[n5 - 2] = 0;
                nArray[n5 - 1] = 0;
                --n3;
            } else {
                ++n3;
            }
            nArray[n3] = 1;
            bl = !bl;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int decodeCode(BitArray bitArray, int[] nArray, int n) throws NotFoundException {
        Code128Reader.recordPattern(bitArray, n, nArray);
        int n2 = 64;
        int n3 = -1;
        for (int i = 0; i < CODE_PATTERNS.length; ++i) {
            int[] nArray2 = CODE_PATTERNS[i];
            int n4 = Code128Reader.patternMatchVariance(nArray, nArray2, 179);
            if (n4 >= n2) continue;
            n2 = n4;
            n3 = i;
        }
        if (n3 >= 0) {
            return n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, FormatException, ChecksumException {
        int n22;
        int n3;
        int n4;
        boolean bl = map != null && map.containsKey((Object)DecodeHintType.ASSUME_GS1);
        int[] nArray = Code128Reader.findStartPattern(bitArray);
        int n5 = nArray[2];
        ArrayList<Byte> arrayList = new ArrayList<Byte>(20);
        arrayList.add((byte)n5);
        switch (n5) {
            case 103: {
                n4 = 101;
                break;
            }
            case 104: {
                n4 = 100;
                break;
            }
            case 105: {
                n4 = 99;
                break;
            }
            default: {
                throw FormatException.getFormatInstance();
            }
        }
        boolean bl2 = false;
        int n6 = 0;
        StringBuilder stringBuilder = new StringBuilder(20);
        int n7 = nArray[0];
        int n8 = nArray[1];
        int[] nArray2 = new int[6];
        int n9 = 0;
        int n10 = 0;
        int n11 = n5;
        int n12 = 0;
        boolean bl3 = true;
        while (!bl2) {
            block58: {
                n3 = n6;
                n6 = 0;
                n9 = n10;
                n10 = Code128Reader.decodeCode(bitArray, nArray2, n8);
                arrayList.add((byte)n10);
                if (n10 != 106) {
                    bl3 = true;
                }
                if (n10 != 106) {
                    n11 += ++n12 * n10;
                }
                n7 = n8;
                for (int n22 : nArray2) {
                    n8 += n22;
                }
                switch (n10) {
                    case 103: 
                    case 104: 
                    case 105: {
                        throw FormatException.getFormatInstance();
                    }
                }
                block8 : switch (n4) {
                    case 101: {
                        if (n10 < 64) {
                            stringBuilder.append((char)(32 + n10));
                            break;
                        }
                        if (n10 < 96) {
                            stringBuilder.append((char)(n10 - 64));
                            break;
                        }
                        if (n10 != 106) {
                            bl3 = false;
                        }
                        switch (n10) {
                            case 102: {
                                if (!bl) break;
                                if (stringBuilder.length() == 0) {
                                    stringBuilder.append("]C1");
                                    break;
                                }
                                stringBuilder.append('\u001d');
                                break;
                            }
                            case 96: 
                            case 97: 
                            case 101: {
                                break;
                            }
                            case 98: {
                                n6 = 1;
                                n4 = 100;
                                break;
                            }
                            case 100: {
                                n4 = 100;
                                break;
                            }
                            case 99: {
                                n4 = 99;
                                break;
                            }
                            case 106: {
                                bl2 = true;
                            }
                        }
                        break;
                    }
                    case 100: {
                        if (n10 < 96) {
                            stringBuilder.append((char)(32 + n10));
                            break;
                        }
                        if (n10 != 106) {
                            bl3 = false;
                        }
                        switch (n10) {
                            case 102: {
                                if (!bl) break;
                                if (stringBuilder.length() == 0) {
                                    stringBuilder.append("]C1");
                                    break;
                                }
                                stringBuilder.append('\u001d');
                                break;
                            }
                            case 96: 
                            case 97: 
                            case 100: {
                                break;
                            }
                            case 98: {
                                n6 = 1;
                                n4 = 101;
                                break;
                            }
                            case 101: {
                                n4 = 101;
                                break;
                            }
                            case 99: {
                                n4 = 99;
                                break;
                            }
                            case 106: {
                                bl2 = true;
                            }
                        }
                        break;
                    }
                    case 99: {
                        if (n10 < 100) {
                            if (n10 < 10) {
                                stringBuilder.append('0');
                            }
                            stringBuilder.append(n10);
                            break;
                        }
                        if (n10 != 106) {
                            bl3 = false;
                        }
                        switch (n10) {
                            case 102: {
                                if (bl) {
                                    if (stringBuilder.length() == 0) {
                                        stringBuilder.append("]C1");
                                        break block8;
                                    }
                                    stringBuilder.append('\u001d');
                                    break block8;
                                }
                                break block58;
                            }
                            case 101: {
                                n4 = 101;
                                break block8;
                            }
                            case 100: {
                                n4 = 100;
                                break block8;
                            }
                            case 106: {
                                bl2 = true;
                            }
                        }
                    }
                }
            }
            if (n3 == 0) continue;
            n4 = n4 == 101 ? 100 : 101;
        }
        n3 = n8 - n7;
        if (!bitArray.isRange(n8 = bitArray.getNextUnset(n8), Math.min(bitArray.getSize(), n8 + (n8 - n7) / 2), false)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if ((n11 -= n12 * n9) % 103 != n9) {
            throw ChecksumException.getChecksumInstance();
        }
        int n13 = stringBuilder.length();
        if (n13 == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n13 > 0 && bl3) {
            if (n4 == 99) {
                stringBuilder.delete(n13 - 2, n13);
            } else {
                stringBuilder.delete(n13 - 1, n13);
            }
        }
        float f = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f2 = (float)n7 + (float)n3 / 2.0f;
        n22 = arrayList.size();
        byte[] byArray = new byte[n22];
        for (int i = 0; i < n22; ++i) {
            byArray[i] = (Byte)arrayList.get(i);
        }
        return new Result(stringBuilder.toString(), byArray, new ResultPoint[]{new ResultPoint(f, n), new ResultPoint(f2, n)}, BarcodeFormat.CODE_128);
    }
}

