/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class Code39Reader
extends OneDReader {
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%";
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{52, 289, 97, 352, 49, 304, 112, 37, 292, 100, 265, 73, 328, 25, 280, 88, 13, 268, 76, 28, 259, 67, 322, 19, 274, 82, 7, 262, 70, 22, 385, 193, 448, 145, 400, 208, 133, 388, 196, 148, 168, 162, 138, 42};
    private static final int ASTERISK_ENCODING = CHARACTER_ENCODINGS[39];
    private final boolean usingCheckDigit;
    private final boolean extendedMode;
    private final StringBuilder decodeRowResult;
    private final int[] counters;

    public Code39Reader() {
        this(false);
    }

    public Code39Reader(boolean bl) {
        this(bl, false);
    }

    public Code39Reader(boolean bl, boolean bl2) {
        this.usingCheckDigit = bl;
        this.extendedMode = bl2;
        this.decodeRowResult = new StringBuilder(20);
        this.counters = new int[9];
    }

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        int n2;
        int n3;
        char c;
        int[] nArray = this.counters;
        Arrays.fill(nArray, 0);
        StringBuilder stringBuilder = this.decodeRowResult;
        stringBuilder.setLength(0);
        int[] nArray2 = Code39Reader.findAsteriskPattern(bitArray, nArray);
        int n4 = bitArray.getNextSet(nArray2[1]);
        int n5 = bitArray.getSize();
        do {
            Code39Reader.recordPattern(bitArray, n4, nArray);
            n3 = Code39Reader.toNarrowWidePattern(nArray);
            if (n3 < 0) {
                throw NotFoundException.getNotFoundInstance();
            }
            c = Code39Reader.patternToChar(n3);
            stringBuilder.append(c);
            n2 = n4;
            for (int n6 : nArray) {
                n4 += n6;
            }
            n4 = bitArray.getNextSet(n4);
        } while (c != '*');
        stringBuilder.setLength(stringBuilder.length() - 1);
        n3 = 0;
        for (int n6 : nArray) {
            n3 += n6;
        }
        int n7 = n4 - n2 - n3;
        if (n4 != n5 && n7 >> 1 < n3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (this.usingCheckDigit) {
            int n8 = stringBuilder.length() - 1;
            int n9 = 0;
            for (int n6 = 0; n6 < n8; ++n6) {
                n9 += ALPHABET_STRING.indexOf(this.decodeRowResult.charAt(n6));
            }
            if (stringBuilder.charAt(n8) != ALPHABET[n9 % 43]) {
                throw ChecksumException.getChecksumInstance();
            }
            stringBuilder.setLength(n8);
        }
        if (stringBuilder.length() == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string = this.extendedMode ? Code39Reader.decodeExtended(stringBuilder) : stringBuilder.toString();
        float f = (float)(nArray2[1] + nArray2[0]) / 2.0f;
        float f2 = (float)n2 + (float)n3 / 2.0f;
        return new Result(string, null, new ResultPoint[]{new ResultPoint(f, n), new ResultPoint(f2, n)}, BarcodeFormat.CODE_39);
    }

    private static int[] findAsteriskPattern(BitArray bitArray, int[] nArray) throws NotFoundException {
        int n = bitArray.getSize();
        int n2 = bitArray.getNextSet(0);
        int n3 = 0;
        int n4 = n2;
        boolean bl = false;
        int n5 = nArray.length;
        for (int i = n2; i < n; ++i) {
            if (bitArray.get(i) ^ bl) {
                int n6 = n3;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            if (n3 == n5 - 1) {
                if (Code39Reader.toNarrowWidePattern(nArray) == ASTERISK_ENCODING && bitArray.isRange(Math.max(0, n4 - (i - n4 >> 1)), n4, false)) {
                    return new int[]{n4, i};
                }
                n4 += nArray[0] + nArray[1];
                System.arraycopy(nArray, 2, nArray, 0, n5 - 2);
                nArray[n5 - 2] = 0;
                nArray[n5 - 1] = 0;
                --n3;
            } else {
                ++n3;
            }
            nArray[n3] = 1;
            bl = !bl;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toNarrowWidePattern(int[] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = 0;
        do {
            int n4;
            int n52;
            int n6 = Integer.MAX_VALUE;
            for (int n52 : nArray) {
                if (n52 >= n6 || n52 <= n3) continue;
                n6 = n52;
            }
            n3 = n6;
            n = 0;
            int n7 = 0;
            int n8 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                n52 = nArray[n4];
                if (n52 <= n3) continue;
                n8 |= 1 << n2 - 1 - n4;
                ++n;
                n7 += n52;
            }
            if (n != 3) continue;
            for (n4 = 0; n4 < n2 && n > 0; ++n4) {
                n52 = nArray[n4];
                if (n52 <= n3) continue;
                --n;
                if (n52 << 1 < n7) continue;
                return -1;
            }
            return n8;
        } while (n > 3);
        return -1;
    }

    private static char patternToChar(int n) throws NotFoundException {
        for (int i = 0; i < CHARACTER_ENCODINGS.length; ++i) {
            if (CHARACTER_ENCODINGS[i] != n) continue;
            return ALPHABET[i];
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(CharSequence charSequence) throws FormatException {
        int n = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c == '+' || c == '$' || c == '%' || c == '/') {
                char c2 = charSequence.charAt(i + 1);
                int n2 = 0;
                switch (c) {
                    case '+': {
                        if (c2 >= 'A' && c2 <= 'Z') {
                            n2 = (char)(c2 + 32);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '$': {
                        if (c2 >= 'A' && c2 <= 'Z') {
                            n2 = (char)(c2 - 64);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '%': {
                        if (c2 >= 'A' && c2 <= 'E') {
                            n2 = (char)(c2 - 38);
                            break;
                        }
                        if (c2 >= 'F' && c2 <= 'W') {
                            n2 = (char)(c2 - 11);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '/': {
                        if (c2 >= 'A' && c2 <= 'O') {
                            n2 = (char)(c2 - 32);
                            break;
                        }
                        if (c2 == 'Z') {
                            n2 = 58;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
                stringBuilder.append((char)n2);
                ++i;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

