/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Map;

public final class EAN13Writer
extends UPCEANWriter {
    private static final int CODE_WIDTH = 95;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat != BarcodeFormat.EAN_13) {
            throw new IllegalArgumentException("Can only encode EAN_13, but got " + barcodeFormat);
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        int n2;
        if (string.length() != 13) {
            throw new IllegalArgumentException("Requested contents should be 13 digits long, but got " + string.length());
        }
        try {
            if (!UPCEANReader.checkStandardUPCEANChecksum(string)) {
                throw new IllegalArgumentException("Contents do not pass checksum");
            }
        }
        catch (FormatException formatException) {
            throw new IllegalArgumentException("Illegal contents");
        }
        int n3 = Integer.parseInt(string.substring(0, 1));
        int n4 = EAN13Reader.FIRST_DIGIT_ENCODINGS[n3];
        boolean[] blArray = new boolean[95];
        int n5 = 0;
        n5 += EAN13Writer.appendPattern(blArray, n5, UPCEANReader.START_END_PATTERN, true);
        for (n2 = 1; n2 <= 6; ++n2) {
            n = Integer.parseInt(string.substring(n2, n2 + 1));
            if ((n4 >> 6 - n2 & 1) == 1) {
                n += 10;
            }
            n5 += EAN13Writer.appendPattern(blArray, n5, UPCEANReader.L_AND_G_PATTERNS[n], false);
        }
        n5 += EAN13Writer.appendPattern(blArray, n5, UPCEANReader.MIDDLE_PATTERN, false);
        for (n2 = 7; n2 <= 12; ++n2) {
            n = Integer.parseInt(string.substring(n2, n2 + 1));
            n5 += EAN13Writer.appendPattern(blArray, n5, UPCEANReader.L_PATTERNS[n], true);
        }
        n5 += EAN13Writer.appendPattern(blArray, n5, UPCEANReader.START_END_PATTERN, true);
        return blArray;
    }
}

