/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.ITFReader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Map;

public final class ITFWriter
extends OneDimensionalCodeWriter {
    private static final int[] START_PATTERN = new int[]{1, 1, 1, 1};
    private static final int[] END_PATTERN = new int[]{3, 1, 1};

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat != BarcodeFormat.ITF) {
            throw new IllegalArgumentException("Can only encode ITF, but got " + barcodeFormat);
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            throw new IllegalArgumentException("The lenght of the input should be even");
        }
        if (n > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n);
        }
        boolean[] blArray = new boolean[9 + 9 * n];
        int n2 = ITFWriter.appendPattern(blArray, 0, START_PATTERN, true);
        for (int i = 0; i < n; i += 2) {
            int n3 = Character.digit(string.charAt(i), 10);
            int n4 = Character.digit(string.charAt(i + 1), 10);
            int[] nArray = new int[18];
            for (int j = 0; j < 5; ++j) {
                nArray[j << 1] = ITFReader.PATTERNS[n3][j];
                nArray[(j << 1) + 1] = ITFReader.PATTERNS[n4][j];
            }
            n2 += ITFWriter.appendPattern(blArray, n2, nArray, true);
        }
        ITFWriter.appendPattern(blArray, n2, END_PATTERN, true);
        return blArray;
    }
}

