/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.EAN13Writer;
import java.util.Map;

public final class UPCAWriter
implements Writer {
    private final EAN13Writer subWriter = new EAN13Writer();

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) throws WriterException {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat != BarcodeFormat.UPC_A) {
            throw new IllegalArgumentException("Can only encode UPC-A, but got " + barcodeFormat);
        }
        return this.subWriter.encode(UPCAWriter.preencode(string), BarcodeFormat.EAN_13, n, n2, map);
    }

    private static String preencode(String object) {
        int n = ((String)object).length();
        if (n == 11) {
            int n2 = 0;
            for (int i = 0; i < 11; ++i) {
                n2 += (((String)object).charAt(i) - 48) * (i % 2 == 0 ? 3 : 1);
            }
            object = (String)object + (1000 - n2) % 10;
        } else if (n != 12) {
            throw new IllegalArgumentException("Requested contents should be 11 or 12 digits long, but got " + ((String)object).length());
        }
        return "0" + (String)object;
    }
}

