/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;
import java.util.EnumMap;
import java.util.Map;

final class UPCEANExtension2Support {
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension2Support() {
    }

    Result decodeRow(int n, BitArray bitArray, int[] nArray) throws NotFoundException {
        StringBuilder stringBuilder = this.decodeRowStringBuffer;
        stringBuilder.setLength(0);
        int n2 = this.decodeMiddle(bitArray, nArray, stringBuilder);
        String string = stringBuilder.toString();
        Map<ResultMetadataType, Object> map = UPCEANExtension2Support.parseExtensionString(string);
        Result result = new Result(string, null, new ResultPoint[]{new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n), new ResultPoint(n2, n)}, BarcodeFormat.UPC_EAN_EXTENSION);
        if (map != null) {
            result.putAllMetadata(map);
        }
        return result;
    }

    int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n = bitArray.getSize();
        int n2 = nArray[1];
        int n3 = 0;
        for (int i = 0; i < 2 && n2 < n; ++i) {
            int n4 = UPCEANReader.decodeDigit(bitArray, nArray2, n2, UPCEANReader.L_AND_G_PATTERNS);
            stringBuilder.append((char)(48 + n4 % 10));
            for (int n5 : nArray2) {
                n2 += n5;
            }
            if (n4 >= 10) {
                n3 |= 1 << 1 - i;
            }
            if (i == 1) continue;
            n2 = bitArray.getNextSet(n2);
            n2 = bitArray.getNextUnset(n2);
        }
        if (stringBuilder.length() != 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (Integer.parseInt(stringBuilder.toString()) % 4 != n3) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n2;
    }

    private static Map<ResultMetadataType, Object> parseExtensionString(String string) {
        if (string.length() != 2) {
            return null;
        }
        EnumMap<ResultMetadataType, Object> enumMap = new EnumMap<ResultMetadataType, Object>(ResultMetadataType.class);
        enumMap.put(ResultMetadataType.ISSUE_NUMBER, Integer.valueOf(string));
        return enumMap;
    }
}

