/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.AbstractRSSReader;
import com.google.zxing.oned.rss.DataCharacter;
import com.google.zxing.oned.rss.FinderPattern;
import com.google.zxing.oned.rss.RSSUtils;
import com.google.zxing.oned.rss.expanded.BitArrayBuilder;
import com.google.zxing.oned.rss.expanded.ExpandedPair;
import com.google.zxing.oned.rss.expanded.ExpandedRow;
import com.google.zxing.oned.rss.expanded.decoders.AbstractExpandedDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RSSExpandedReader
extends AbstractRSSReader {
    private static final int[] SYMBOL_WIDEST = new int[]{7, 5, 4, 3, 1};
    private static final int[] EVEN_TOTAL_SUBSET = new int[]{4, 20, 52, 104, 204};
    private static final int[] GSUM = new int[]{0, 348, 1388, 2948, 3988};
    private static final int[][] FINDER_PATTERNS = new int[][]{{1, 8, 4, 1}, {3, 6, 4, 1}, {3, 4, 6, 1}, {3, 2, 8, 1}, {2, 6, 5, 1}, {2, 2, 9, 1}};
    private static final int[][] WEIGHTS = new int[][]{{1, 3, 9, 27, 81, 32, 96, 77}, {20, 60, 180, 118, 143, 7, 21, 63}, {189, 145, 13, 39, 117, 140, 209, 205}, {193, 157, 49, 147, 19, 57, 171, 91}, {62, 186, 136, 197, 169, 85, 44, 132}, {185, 133, 188, 142, 4, 12, 36, 108}, {113, 128, 173, 97, 80, 29, 87, 50}, {150, 28, 84, 41, 123, 158, 52, 156}, {46, 138, 203, 187, 139, 206, 196, 166}, {76, 17, 51, 153, 37, 111, 122, 155}, {43, 129, 176, 106, 107, 110, 119, 146}, {16, 48, 144, 10, 30, 90, 59, 177}, {109, 116, 137, 200, 178, 112, 125, 164}, {70, 210, 208, 202, 184, 130, 179, 115}, {134, 191, 151, 31, 93, 68, 204, 190}, {148, 22, 66, 198, 172, 94, 71, 2}, {6, 18, 54, 162, 64, 192, 154, 40}, {120, 149, 25, 75, 14, 42, 126, 167}, {79, 26, 78, 23, 69, 207, 199, 175}, {103, 98, 83, 38, 114, 131, 182, 124}, {161, 61, 183, 127, 170, 88, 53, 159}, {55, 165, 73, 8, 24, 72, 5, 15}, {45, 135, 194, 160, 58, 174, 100, 89}};
    private static final int FINDER_PAT_A = 0;
    private static final int FINDER_PAT_B = 1;
    private static final int FINDER_PAT_C = 2;
    private static final int FINDER_PAT_D = 3;
    private static final int FINDER_PAT_E = 4;
    private static final int FINDER_PAT_F = 5;
    private static final int[][] FINDER_PATTERN_SEQUENCES = new int[][]{{0, 0}, {0, 1, 1}, {0, 2, 1, 3}, {0, 4, 1, 3, 2}, {0, 4, 1, 3, 3, 5}, {0, 4, 1, 3, 4, 5, 5}, {0, 0, 1, 1, 2, 2, 3, 3}, {0, 0, 1, 1, 2, 2, 3, 4, 4}, {0, 0, 1, 1, 2, 2, 3, 4, 5, 5}, {0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5}};
    private static final int MAX_PAIRS = 11;
    private final List<ExpandedPair> pairs = new ArrayList<ExpandedPair>(11);
    private final List<ExpandedRow> rows = new ArrayList<ExpandedRow>();
    private final int[] startEnd = new int[2];
    private boolean startFromEven = false;

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, FormatException {
        this.pairs.clear();
        this.startFromEven = false;
        try {
            List<ExpandedPair> list = this.decodeRow2pairs(n, bitArray);
            return RSSExpandedReader.constructResult(list);
        }
        catch (NotFoundException notFoundException) {
            this.pairs.clear();
            this.startFromEven = true;
            List<ExpandedPair> list = this.decodeRow2pairs(n, bitArray);
            return RSSExpandedReader.constructResult(list);
        }
    }

    @Override
    public void reset() {
        this.pairs.clear();
        this.rows.clear();
    }

    List<ExpandedPair> decodeRow2pairs(int n, BitArray bitArray) throws NotFoundException {
        try {
            while (true) {
                ExpandedPair expandedPair = this.retrieveNextPair(bitArray, this.pairs, n);
                this.pairs.add(expandedPair);
            }
        }
        catch (NotFoundException notFoundException) {
            if (this.pairs.isEmpty()) {
                throw notFoundException;
            }
            if (this.checkChecksum()) {
                return this.pairs;
            }
            boolean bl = !this.rows.isEmpty();
            boolean bl2 = false;
            this.storeRow(n, bl2);
            if (bl) {
                List<ExpandedPair> list = this.checkRows(false);
                if (list != null) {
                    return list;
                }
                list = this.checkRows(true);
                if (list != null) {
                    return list;
                }
            }
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private List<ExpandedPair> checkRows(boolean bl) {
        if (this.rows.size() > 25) {
            this.rows.clear();
            return null;
        }
        this.pairs.clear();
        if (bl) {
            Collections.reverse(this.rows);
        }
        List<ExpandedPair> list = null;
        try {
            list = this.checkRows(new ArrayList<ExpandedRow>(), 0);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (bl) {
            Collections.reverse(this.rows);
        }
        return list;
    }

    private List<ExpandedPair> checkRows(List<ExpandedRow> list, int n) throws NotFoundException {
        for (int i = n; i < this.rows.size(); ++i) {
            ExpandedRow expandedRow = this.rows.get(i);
            this.pairs.clear();
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                this.pairs.addAll(list.get(j).getPairs());
            }
            this.pairs.addAll(expandedRow.getPairs());
            if (!RSSExpandedReader.isValidSequence(this.pairs)) continue;
            if (this.checkChecksum()) {
                return this.pairs;
            }
            ArrayList<ExpandedRow> arrayList = new ArrayList<ExpandedRow>();
            arrayList.addAll(list);
            arrayList.add(expandedRow);
            try {
                return this.checkRows(arrayList, i + 1);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static boolean isValidSequence(List<ExpandedPair> list) {
        for (int[] nArray : FINDER_PATTERN_SEQUENCES) {
            if (list.size() > nArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getFinderPattern().getValue() == nArray[i]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private void storeRow(int n, boolean bl) {
        int n2;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n2 = 0; n2 < this.rows.size(); ++n2) {
            ExpandedRow expandedRow = this.rows.get(n2);
            if (expandedRow.getRowNumber() > n) {
                bl3 = expandedRow.isEquivalent(this.pairs);
                break;
            }
            bl2 = expandedRow.isEquivalent(this.pairs);
        }
        if (bl3 || bl2) {
            return;
        }
        if (RSSExpandedReader.isPartialRow(this.pairs, this.rows)) {
            return;
        }
        this.rows.add(n2, new ExpandedRow(this.pairs, n, bl));
        RSSExpandedReader.removePartialRows(this.pairs, this.rows);
    }

    private static void removePartialRows(List<ExpandedPair> list, List<ExpandedRow> list2) {
        Iterator<ExpandedRow> iterator = list2.iterator();
        while (iterator.hasNext()) {
            ExpandedRow expandedRow = iterator.next();
            if (expandedRow.getPairs().size() == list.size()) continue;
            boolean bl = true;
            for (ExpandedPair expandedPair : expandedRow.getPairs()) {
                boolean bl2 = false;
                for (ExpandedPair expandedPair2 : list) {
                    if (!expandedPair.equals(expandedPair2)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            iterator.remove();
        }
    }

    private static boolean isPartialRow(Iterable<ExpandedPair> iterable, Iterable<ExpandedRow> iterable2) {
        for (ExpandedRow expandedRow : iterable2) {
            boolean bl = true;
            for (ExpandedPair expandedPair : iterable) {
                boolean bl2 = false;
                for (ExpandedPair expandedPair2 : expandedRow.getPairs()) {
                    if (!expandedPair.equals(expandedPair2)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    List<ExpandedRow> getRows() {
        return this.rows;
    }

    static Result constructResult(List<ExpandedPair> list) throws NotFoundException, FormatException {
        BitArray bitArray = BitArrayBuilder.buildBitArray(list);
        AbstractExpandedDecoder abstractExpandedDecoder = AbstractExpandedDecoder.createDecoder(bitArray);
        String string = abstractExpandedDecoder.parseInformation();
        ResultPoint[] resultPointArray = list.get(0).getFinderPattern().getResultPoints();
        ResultPoint[] resultPointArray2 = list.get(list.size() - 1).getFinderPattern().getResultPoints();
        return new Result(string, null, new ResultPoint[]{resultPointArray[0], resultPointArray[1], resultPointArray2[0], resultPointArray2[1]}, BarcodeFormat.RSS_EXPANDED);
    }

    private boolean checkChecksum() {
        int n;
        ExpandedPair expandedPair = this.pairs.get(0);
        DataCharacter dataCharacter = expandedPair.getLeftChar();
        DataCharacter dataCharacter2 = expandedPair.getRightChar();
        if (dataCharacter2 == null) {
            return false;
        }
        int n2 = dataCharacter2.getChecksumPortion();
        int n3 = 2;
        for (n = 1; n < this.pairs.size(); ++n) {
            ExpandedPair expandedPair2 = this.pairs.get(n);
            n2 += expandedPair2.getLeftChar().getChecksumPortion();
            ++n3;
            DataCharacter dataCharacter3 = expandedPair2.getRightChar();
            if (dataCharacter3 == null) continue;
            n2 += dataCharacter3.getChecksumPortion();
            ++n3;
        }
        n = 211 * (n3 - 4) + (n2 %= 211);
        return n == dataCharacter.getValue();
    }

    private static int getNextSecondBar(BitArray bitArray, int n) {
        int n2;
        if (bitArray.get(n)) {
            n2 = bitArray.getNextUnset(n);
            n2 = bitArray.getNextSet(n2);
        } else {
            n2 = bitArray.getNextSet(n);
            n2 = bitArray.getNextUnset(n2);
        }
        return n2;
    }

    ExpandedPair retrieveNextPair(BitArray bitArray, List<ExpandedPair> list, int n) throws NotFoundException {
        DataCharacter dataCharacter;
        FinderPattern finderPattern;
        boolean bl;
        boolean bl2 = bl = list.size() % 2 == 0;
        if (this.startFromEven) {
            bl = !bl;
        }
        boolean bl3 = true;
        int n2 = -1;
        do {
            this.findNextPair(bitArray, list, n2);
            finderPattern = this.parseFoundFinderPattern(bitArray, n, bl);
            if (finderPattern == null) {
                n2 = RSSExpandedReader.getNextSecondBar(bitArray, this.startEnd[0]);
                continue;
            }
            bl3 = false;
        } while (bl3);
        DataCharacter dataCharacter2 = this.decodeDataCharacter(bitArray, finderPattern, bl, true);
        if (!list.isEmpty() && list.get(list.size() - 1).mustBeLast()) {
            throw NotFoundException.getNotFoundInstance();
        }
        try {
            dataCharacter = this.decodeDataCharacter(bitArray, finderPattern, bl, false);
        }
        catch (NotFoundException notFoundException) {
            dataCharacter = null;
        }
        boolean bl4 = true;
        return new ExpandedPair(dataCharacter2, dataCharacter, finderPattern, bl4);
    }

    private void findNextPair(BitArray bitArray, List<ExpandedPair> list, int n) throws NotFoundException {
        boolean bl;
        int n2;
        int[] nArray = this.getDecodeFinderCounters();
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        int n3 = bitArray.getSize();
        if (n >= 0) {
            n2 = n;
        } else if (list.isEmpty()) {
            n2 = 0;
        } else {
            ExpandedPair expandedPair = list.get(list.size() - 1);
            n2 = expandedPair.getFinderPattern().getStartEnd()[1];
        }
        boolean bl2 = bl = list.size() % 2 != 0;
        if (this.startFromEven) {
            bl = !bl;
        }
        boolean bl3 = false;
        while (n2 < n3) {
            boolean bl4 = bl3 = !bitArray.get(n2);
            if (!bl3) break;
            ++n2;
        }
        int n4 = 0;
        int n5 = n2;
        for (int i = n2; i < n3; ++i) {
            if (bitArray.get(i) ^ bl3) {
                int n6 = n4;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            if (n4 == 3) {
                if (bl) {
                    RSSExpandedReader.reverseCounters(nArray);
                }
                if (RSSExpandedReader.isFinderPattern(nArray)) {
                    this.startEnd[0] = n5;
                    this.startEnd[1] = i;
                    return;
                }
                if (bl) {
                    RSSExpandedReader.reverseCounters(nArray);
                }
                n5 += nArray[0] + nArray[1];
                nArray[0] = nArray[2];
                nArray[1] = nArray[3];
                nArray[2] = 0;
                nArray[3] = 0;
                --n4;
            } else {
                ++n4;
            }
            nArray[n4] = 1;
            bl3 = !bl3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static void reverseCounters(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n / 2; ++i) {
            int n2 = nArray[i];
            nArray[i] = nArray[n - i - 1];
            nArray[n - i - 1] = n2;
        }
    }

    private FinderPattern parseFoundFinderPattern(BitArray bitArray, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (bl) {
            int n6;
            for (n6 = this.startEnd[0] - 1; n6 >= 0 && !bitArray.get(n6); --n6) {
            }
            n5 = this.startEnd[0] - ++n6;
            n4 = n6;
            n3 = this.startEnd[1];
        } else {
            n4 = this.startEnd[0];
            n3 = bitArray.getNextUnset(this.startEnd[1] + 1);
            n5 = n3 - this.startEnd[1];
        }
        int[] nArray = this.getDecodeFinderCounters();
        System.arraycopy(nArray, 0, nArray, 1, nArray.length - 1);
        nArray[0] = n5;
        try {
            n2 = RSSExpandedReader.parseFinderValue(nArray, FINDER_PATTERNS);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
        return new FinderPattern(n2, new int[]{n4, n3}, n4, n3, n);
    }

    DataCharacter decodeDataCharacter(BitArray bitArray, FinderPattern finderPattern, boolean bl, boolean bl2) throws NotFoundException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray = this.getDataCharacterCounters();
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        if (bl2) {
            RSSExpandedReader.recordPatternInReverse(bitArray, finderPattern.getStartEnd()[0], nArray);
        } else {
            RSSExpandedReader.recordPattern(bitArray, finderPattern.getStartEnd()[1], nArray);
            n6 = 0;
            for (int i = nArray.length - 1; n6 < i; ++n6, --i) {
                int n7 = nArray[n6];
                nArray[n6] = nArray[i];
                nArray[i] = n7;
            }
        }
        n6 = 17;
        float f = (float)RSSExpandedReader.count(nArray) / (float)n6;
        float f2 = (float)(finderPattern.getStartEnd()[1] - finderPattern.getStartEnd()[0]) / 15.0f;
        if (Math.abs(f - f2) / f2 > 0.3f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int[] nArray2 = this.getOddCounts();
        int[] nArray3 = this.getEvenCounts();
        float[] fArray = this.getOddRoundingErrors();
        float[] fArray2 = this.getEvenRoundingErrors();
        for (n5 = 0; n5 < nArray.length; ++n5) {
            float f3 = 1.0f * (float)nArray[n5] / f;
            n4 = (int)(f3 + 0.5f);
            if (n4 < 1) {
                if (f3 < 0.3f) {
                    throw NotFoundException.getNotFoundInstance();
                }
                n4 = 1;
            } else if (n4 > 8) {
                if (f3 > 8.7f) {
                    throw NotFoundException.getNotFoundInstance();
                }
                n4 = 8;
            }
            n3 = n5 >> 1;
            if ((n5 & 1) == 0) {
                nArray2[n3] = n4;
                fArray[n3] = f3 - (float)n4;
                continue;
            }
            nArray3[n3] = n4;
            fArray2[n3] = f3 - (float)n4;
        }
        this.adjustOddEvenCounts(n6);
        n5 = 4 * finderPattern.getValue() + (bl ? 0 : 2) + (bl2 ? 0 : 1) - 1;
        int n8 = 0;
        n4 = 0;
        for (n3 = nArray2.length - 1; n3 >= 0; --n3) {
            if (RSSExpandedReader.isNotA1left(finderPattern, bl, bl2)) {
                n2 = WEIGHTS[n5][2 * n3];
                n4 += nArray2[n3] * n2;
            }
            n8 += nArray2[n3];
        }
        n3 = 0;
        for (n2 = nArray3.length - 1; n2 >= 0; --n2) {
            if (!RSSExpandedReader.isNotA1left(finderPattern, bl, bl2)) continue;
            n = WEIGHTS[n5][2 * n2 + 1];
            n3 += nArray3[n2] * n;
        }
        n2 = n4 + n3;
        if ((n8 & 1) != 0 || n8 > 13 || n8 < 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        n = (13 - n8) / 2;
        int n9 = SYMBOL_WIDEST[n];
        int n10 = 9 - n9;
        int n11 = RSSUtils.getRSSvalue(nArray2, n9, true);
        int n12 = RSSUtils.getRSSvalue(nArray3, n10, false);
        int n13 = EVEN_TOTAL_SUBSET[n];
        int n14 = GSUM[n];
        int n15 = n11 * n13 + n12 + n14;
        return new DataCharacter(n15, n2);
    }

    private static boolean isNotA1left(FinderPattern finderPattern, boolean bl, boolean bl2) {
        return finderPattern.getValue() != 0 || !bl || !bl2;
    }

    private void adjustOddEvenCounts(int n) throws NotFoundException {
        int n2 = RSSExpandedReader.count(this.getOddCounts());
        int n3 = RSSExpandedReader.count(this.getEvenCounts());
        int n4 = n2 + n3 - n;
        boolean bl = (n2 & 1) == 1;
        boolean bl2 = (n3 & 1) == 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n2 > 13) {
            bl4 = true;
        } else if (n2 < 4) {
            bl3 = true;
        }
        boolean bl5 = false;
        boolean bl6 = false;
        if (n3 > 13) {
            bl6 = true;
        } else if (n3 < 4) {
            bl5 = true;
        }
        if (n4 == 1) {
            if (bl) {
                if (bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl4 = true;
            } else {
                if (!bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl6 = true;
            }
        } else if (n4 == -1) {
            if (bl) {
                if (bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl3 = true;
            } else {
                if (!bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl5 = true;
            }
        } else if (n4 == 0) {
            if (bl) {
                if (!bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (n2 < n3) {
                    bl3 = true;
                    bl6 = true;
                } else {
                    bl4 = true;
                    bl5 = true;
                }
            } else if (bl2) {
                throw NotFoundException.getNotFoundInstance();
            }
        } else {
            throw NotFoundException.getNotFoundInstance();
        }
        if (bl3) {
            if (bl4) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSSExpandedReader.increment(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (bl4) {
            RSSExpandedReader.decrement(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (bl5) {
            if (bl6) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSSExpandedReader.increment(this.getEvenCounts(), this.getOddRoundingErrors());
        }
        if (bl6) {
            RSSExpandedReader.decrement(this.getEvenCounts(), this.getEvenRoundingErrors());
        }
    }
}

