/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded.decoders;

import com.google.zxing.FormatException;
import com.google.zxing.oned.rss.expanded.decoders.DecodedObject;

final class DecodedNumeric
extends DecodedObject {
    private final int firstDigit;
    private final int secondDigit;
    static final int FNC1 = 10;

    DecodedNumeric(int n, int n2, int n3) throws FormatException {
        super(n);
        if (n2 < 0 || n2 > 10 || n3 < 0 || n3 > 10) {
            throw FormatException.getFormatInstance();
        }
        this.firstDigit = n2;
        this.secondDigit = n3;
    }

    int getFirstDigit() {
        return this.firstDigit;
    }

    int getSecondDigit() {
        return this.secondDigit;
    }

    int getValue() {
        return this.firstDigit * 10 + this.secondDigit;
    }

    boolean isFirstDigitFNC1() {
        return this.firstDigit == 10;
    }

    boolean isSecondDigitFNC1() {
        return this.secondDigit == 10;
    }

    boolean isAnyFNC1() {
        return this.firstDigit == 10 || this.secondDigit == 10;
    }
}

