/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded.decoders;

import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.expanded.decoders.BlockParsedResult;
import com.google.zxing.oned.rss.expanded.decoders.CurrentParsingState;
import com.google.zxing.oned.rss.expanded.decoders.DecodedChar;
import com.google.zxing.oned.rss.expanded.decoders.DecodedInformation;
import com.google.zxing.oned.rss.expanded.decoders.DecodedNumeric;
import com.google.zxing.oned.rss.expanded.decoders.FieldParser;

final class GeneralAppIdDecoder {
    private final BitArray information;
    private final CurrentParsingState current = new CurrentParsingState();
    private final StringBuilder buffer = new StringBuilder();

    GeneralAppIdDecoder(BitArray bitArray) {
        this.information = bitArray;
    }

    String decodeAllCodes(StringBuilder stringBuilder, int n) throws NotFoundException, FormatException {
        int n2 = n;
        String string = null;
        while (true) {
            DecodedInformation decodedInformation;
            String string2;
            if ((string2 = FieldParser.parseFieldsInGeneralPurpose((decodedInformation = this.decodeGeneralPurposeField(n2, string)).getNewString())) != null) {
                stringBuilder.append(string2);
            }
            string = decodedInformation.isRemaining() ? String.valueOf(decodedInformation.getRemainingValue()) : null;
            if (n2 == decodedInformation.getNewPosition()) break;
            n2 = decodedInformation.getNewPosition();
        }
        return stringBuilder.toString();
    }

    private boolean isStillNumeric(int n) {
        if (n + 7 > this.information.getSize()) {
            return n + 4 <= this.information.getSize();
        }
        for (int i = n; i < n + 3; ++i) {
            if (!this.information.get(i)) continue;
            return true;
        }
        return this.information.get(n + 3);
    }

    private DecodedNumeric decodeNumeric(int n) throws FormatException {
        if (n + 7 > this.information.getSize()) {
            int n2 = this.extractNumericValueFromBitArray(n, 4);
            if (n2 == 0) {
                return new DecodedNumeric(this.information.getSize(), 10, 10);
            }
            return new DecodedNumeric(this.information.getSize(), n2 - 1, 10);
        }
        int n3 = this.extractNumericValueFromBitArray(n, 7);
        int n4 = (n3 - 8) / 11;
        int n5 = (n3 - 8) % 11;
        return new DecodedNumeric(n + 7, n4, n5);
    }

    int extractNumericValueFromBitArray(int n, int n2) {
        return GeneralAppIdDecoder.extractNumericValueFromBitArray(this.information, n, n2);
    }

    static int extractNumericValueFromBitArray(BitArray bitArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!bitArray.get(n + i)) continue;
            n3 |= 1 << n2 - i - 1;
        }
        return n3;
    }

    DecodedInformation decodeGeneralPurposeField(int n, String string) throws FormatException {
        this.buffer.setLength(0);
        if (string != null) {
            this.buffer.append(string);
        }
        this.current.setPosition(n);
        DecodedInformation decodedInformation = this.parseBlocks();
        if (decodedInformation != null && decodedInformation.isRemaining()) {
            return new DecodedInformation(this.current.getPosition(), this.buffer.toString(), decodedInformation.getRemainingValue());
        }
        return new DecodedInformation(this.current.getPosition(), this.buffer.toString());
    }

    private DecodedInformation parseBlocks() throws FormatException {
        BlockParsedResult blockParsedResult;
        boolean bl;
        boolean bl2;
        do {
            int n = this.current.getPosition();
            if (this.current.isAlpha()) {
                blockParsedResult = this.parseAlphaBlock();
                bl = blockParsedResult.isFinished();
            } else if (this.current.isIsoIec646()) {
                blockParsedResult = this.parseIsoIec646Block();
                bl = blockParsedResult.isFinished();
            } else {
                blockParsedResult = this.parseNumericBlock();
                bl = blockParsedResult.isFinished();
            }
            boolean bl3 = bl2 = n != this.current.getPosition();
        } while ((bl2 || bl) && !bl);
        return blockParsedResult.getDecodedInformation();
    }

    private BlockParsedResult parseNumericBlock() throws FormatException {
        while (this.isStillNumeric(this.current.getPosition())) {
            DecodedNumeric decodedNumeric = this.decodeNumeric(this.current.getPosition());
            this.current.setPosition(decodedNumeric.getNewPosition());
            if (decodedNumeric.isFirstDigitFNC1()) {
                DecodedInformation decodedInformation = decodedNumeric.isSecondDigitFNC1() ? new DecodedInformation(this.current.getPosition(), this.buffer.toString()) : new DecodedInformation(this.current.getPosition(), this.buffer.toString(), decodedNumeric.getSecondDigit());
                return new BlockParsedResult(decodedInformation, true);
            }
            this.buffer.append(decodedNumeric.getFirstDigit());
            if (decodedNumeric.isSecondDigitFNC1()) {
                DecodedInformation decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult(decodedInformation, true);
            }
            this.buffer.append(decodedNumeric.getSecondDigit());
        }
        if (this.isNumericToAlphaNumericLatch(this.current.getPosition())) {
            this.current.setAlpha();
            this.current.incrementPosition(4);
        }
        return new BlockParsedResult(false);
    }

    private BlockParsedResult parseIsoIec646Block() throws FormatException {
        while (this.isStillIsoIec646(this.current.getPosition())) {
            DecodedChar decodedChar = this.decodeIsoIec646(this.current.getPosition());
            this.current.setPosition(decodedChar.getNewPosition());
            if (decodedChar.isFNC1()) {
                DecodedInformation decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult(decodedInformation, true);
            }
            this.buffer.append(decodedChar.getValue());
        }
        if (this.isAlphaOr646ToNumericLatch(this.current.getPosition())) {
            this.current.incrementPosition(3);
            this.current.setNumeric();
        } else if (this.isAlphaTo646ToAlphaLatch(this.current.getPosition())) {
            if (this.current.getPosition() + 5 < this.information.getSize()) {
                this.current.incrementPosition(5);
            } else {
                this.current.setPosition(this.information.getSize());
            }
            this.current.setAlpha();
        }
        return new BlockParsedResult(false);
    }

    private BlockParsedResult parseAlphaBlock() {
        while (this.isStillAlpha(this.current.getPosition())) {
            DecodedChar decodedChar = this.decodeAlphanumeric(this.current.getPosition());
            this.current.setPosition(decodedChar.getNewPosition());
            if (decodedChar.isFNC1()) {
                DecodedInformation decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult(decodedInformation, true);
            }
            this.buffer.append(decodedChar.getValue());
        }
        if (this.isAlphaOr646ToNumericLatch(this.current.getPosition())) {
            this.current.incrementPosition(3);
            this.current.setNumeric();
        } else if (this.isAlphaTo646ToAlphaLatch(this.current.getPosition())) {
            if (this.current.getPosition() + 5 < this.information.getSize()) {
                this.current.incrementPosition(5);
            } else {
                this.current.setPosition(this.information.getSize());
            }
            this.current.setIsoIec646();
        }
        return new BlockParsedResult(false);
    }

    private boolean isStillIsoIec646(int n) {
        if (n + 5 > this.information.getSize()) {
            return false;
        }
        int n2 = this.extractNumericValueFromBitArray(n, 5);
        if (n2 >= 5 && n2 < 16) {
            return true;
        }
        if (n + 7 > this.information.getSize()) {
            return false;
        }
        int n3 = this.extractNumericValueFromBitArray(n, 7);
        if (n3 >= 64 && n3 < 116) {
            return true;
        }
        if (n + 8 > this.information.getSize()) {
            return false;
        }
        int n4 = this.extractNumericValueFromBitArray(n, 8);
        return n4 >= 232 && n4 < 253;
    }

    private DecodedChar decodeIsoIec646(int n) throws FormatException {
        char c;
        int n2 = this.extractNumericValueFromBitArray(n, 5);
        if (n2 == 15) {
            return new DecodedChar(n + 5, '$');
        }
        if (n2 >= 5 && n2 < 15) {
            return new DecodedChar(n + 5, (char)(48 + n2 - 5));
        }
        int n3 = this.extractNumericValueFromBitArray(n, 7);
        if (n3 >= 64 && n3 < 90) {
            return new DecodedChar(n + 7, (char)(n3 + 1));
        }
        if (n3 >= 90 && n3 < 116) {
            return new DecodedChar(n + 7, (char)(n3 + 7));
        }
        int n4 = this.extractNumericValueFromBitArray(n, 8);
        switch (n4) {
            case 232: {
                c = '!';
                break;
            }
            case 233: {
                c = '\"';
                break;
            }
            case 234: {
                c = '%';
                break;
            }
            case 235: {
                c = '&';
                break;
            }
            case 236: {
                c = '\'';
                break;
            }
            case 237: {
                c = '(';
                break;
            }
            case 238: {
                c = ')';
                break;
            }
            case 239: {
                c = '*';
                break;
            }
            case 240: {
                c = '+';
                break;
            }
            case 241: {
                c = ',';
                break;
            }
            case 242: {
                c = '-';
                break;
            }
            case 243: {
                c = '.';
                break;
            }
            case 244: {
                c = '/';
                break;
            }
            case 245: {
                c = ':';
                break;
            }
            case 246: {
                c = ';';
                break;
            }
            case 247: {
                c = '<';
                break;
            }
            case 248: {
                c = '=';
                break;
            }
            case 249: {
                c = '>';
                break;
            }
            case 250: {
                c = '?';
                break;
            }
            case 251: {
                c = '_';
                break;
            }
            case 252: {
                c = ' ';
                break;
            }
            default: {
                throw FormatException.getFormatInstance();
            }
        }
        return new DecodedChar(n + 8, c);
    }

    private boolean isStillAlpha(int n) {
        if (n + 5 > this.information.getSize()) {
            return false;
        }
        int n2 = this.extractNumericValueFromBitArray(n, 5);
        if (n2 >= 5 && n2 < 16) {
            return true;
        }
        if (n + 6 > this.information.getSize()) {
            return false;
        }
        int n3 = this.extractNumericValueFromBitArray(n, 6);
        return n3 >= 16 && n3 < 63;
    }

    private DecodedChar decodeAlphanumeric(int n) {
        char c;
        int n2 = this.extractNumericValueFromBitArray(n, 5);
        if (n2 == 15) {
            return new DecodedChar(n + 5, '$');
        }
        if (n2 >= 5 && n2 < 15) {
            return new DecodedChar(n + 5, (char)(48 + n2 - 5));
        }
        int n3 = this.extractNumericValueFromBitArray(n, 6);
        if (n3 >= 32 && n3 < 58) {
            return new DecodedChar(n + 6, (char)(n3 + 33));
        }
        switch (n3) {
            case 58: {
                c = '*';
                break;
            }
            case 59: {
                c = ',';
                break;
            }
            case 60: {
                c = '-';
                break;
            }
            case 61: {
                c = '.';
                break;
            }
            case 62: {
                c = '/';
                break;
            }
            default: {
                throw new IllegalStateException("Decoding invalid alphanumeric value: " + n3);
            }
        }
        return new DecodedChar(n + 6, c);
    }

    private boolean isAlphaTo646ToAlphaLatch(int n) {
        if (n + 1 > this.information.getSize()) {
            return false;
        }
        for (int i = 0; i < 5 && i + n < this.information.getSize(); ++i) {
            if (!(i == 2 ? !this.information.get(n + 2) : this.information.get(n + i))) continue;
            return false;
        }
        return true;
    }

    private boolean isAlphaOr646ToNumericLatch(int n) {
        if (n + 3 > this.information.getSize()) {
            return false;
        }
        for (int i = n; i < n + 3; ++i) {
            if (!this.information.get(i)) continue;
            return false;
        }
        return true;
    }

    private boolean isNumericToAlphaNumericLatch(int n) {
        if (n + 1 > this.information.getSize()) {
            return false;
        }
        for (int i = 0; i < 4 && i + n < this.information.getSize(); ++i) {
            if (!this.information.get(n + i)) continue;
            return false;
        }
        return true;
    }
}

