/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.encoder.Compaction;
import com.google.zxing.pdf417.encoder.Dimensions;
import com.google.zxing.pdf417.encoder.PDF417;
import java.util.Map;

public final class PDF417Writer
implements Writer {
    static final int WHITE_SPACE = 30;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat != BarcodeFormat.PDF_417) {
            throw new IllegalArgumentException("Can only encode PDF_417, but got " + barcodeFormat);
        }
        PDF417 pDF417 = new PDF417();
        int n3 = 30;
        if (map != null) {
            if (map.containsKey((Object)EncodeHintType.PDF417_COMPACT)) {
                pDF417.setCompact((Boolean)map.get((Object)EncodeHintType.PDF417_COMPACT));
            }
            if (map.containsKey((Object)EncodeHintType.PDF417_COMPACTION)) {
                pDF417.setCompaction((Compaction)((Object)map.get((Object)EncodeHintType.PDF417_COMPACTION)));
            }
            if (map.containsKey((Object)EncodeHintType.PDF417_DIMENSIONS)) {
                Dimensions dimensions = (Dimensions)map.get((Object)EncodeHintType.PDF417_DIMENSIONS);
                pDF417.setDimensions(dimensions.getMaxCols(), dimensions.getMinCols(), dimensions.getMaxRows(), dimensions.getMinRows());
            }
            if (map.containsKey((Object)EncodeHintType.MARGIN)) {
                n3 = ((Number)map.get((Object)EncodeHintType.MARGIN)).intValue();
            }
        }
        return PDF417Writer.bitMatrixFromEncoder(pDF417, string, n, n2, n3);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) throws WriterException {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    private static BitMatrix bitMatrixFromEncoder(PDF417 pDF417, String string, int n, int n2, int n3) throws WriterException {
        int n4;
        int n5;
        int n6;
        int n7 = 2;
        pDF417.generateBarcodeLogic(string, n7);
        int n8 = 2;
        int n9 = 4;
        byte[][] byArray = pDF417.getBarcodeMatrix().getScaledMatrix(n8, n9 * n8);
        boolean bl = false;
        if (n2 > n ^ byArray[0].length < byArray.length) {
            byArray = PDF417Writer.rotateArray(byArray);
            bl = true;
        }
        if ((n6 = (n5 = n / byArray[0].length) < (n4 = n2 / byArray.length) ? n5 : n4) > 1) {
            byte[][] byArray2 = pDF417.getBarcodeMatrix().getScaledMatrix(n6 * n8, n6 * n9 * n8);
            if (bl) {
                byArray2 = PDF417Writer.rotateArray(byArray2);
            }
            return PDF417Writer.bitMatrixFrombitArray(byArray2, n3);
        }
        return PDF417Writer.bitMatrixFrombitArray(byArray, n3);
    }

    private static BitMatrix bitMatrixFrombitArray(byte[][] byArray, int n) {
        BitMatrix bitMatrix = new BitMatrix(byArray[0].length + 2 * n, byArray.length + 2 * n);
        bitMatrix.clear();
        int n2 = 0;
        int n3 = bitMatrix.getHeight() - n - 1;
        while (n2 < byArray.length) {
            for (int i = 0; i < byArray[0].length; ++i) {
                if (byArray[n2][i] != 1) continue;
                bitMatrix.set(i + n, n3);
            }
            ++n2;
            --n3;
        }
        return bitMatrix;
    }

    private static byte[][] rotateArray(byte[][] byArray) {
        byte[][] byArray2 = new byte[byArray[0].length][byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray.length - i - 1;
            for (int j = 0; j < byArray[0].length; ++j) {
                byArray2[j][n] = byArray[i][j];
            }
        }
        return byArray2;
    }
}

