/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.pdf417.PDF417Common;

final class PDF417CodewordDecoder {
    private static final float[][] RATIOS_TABLE = new float[PDF417Common.SYMBOL_TABLE.length][8];

    private PDF417CodewordDecoder() {
    }

    static int getDecodedValue(int[] nArray) {
        int n = PDF417CodewordDecoder.getDecodedCodewordValue(PDF417CodewordDecoder.sampleBitCounts(nArray));
        if (n != -1) {
            return n;
        }
        return PDF417CodewordDecoder.getClosestDecodedValue(nArray);
    }

    private static int[] sampleBitCounts(int[] nArray) {
        float f = PDF417Common.getBitCountSum(nArray);
        int[] nArray2 = new int[8];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 17; ++i) {
            float f2 = f / 34.0f + (float)i * f / 17.0f;
            if ((float)(n2 + nArray[n]) <= f2) {
                n2 += nArray[n];
            }
            int n3 = ++n;
            nArray2[n3] = nArray2[n3] + 1;
        }
        return nArray2;
    }

    private static int getDecodedCodewordValue(int[] nArray) {
        int n = PDF417CodewordDecoder.getBitValue(nArray);
        return PDF417Common.getCodeword(n) == -1 ? -1 : n;
    }

    private static int getBitValue(int[] nArray) {
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i]; ++j) {
                l = l << 1 | (long)(i % 2 == 0 ? 1 : 0);
            }
        }
        return (int)l;
    }

    private static int getClosestDecodedValue(int[] nArray) {
        int n = PDF417Common.getBitCountSum(nArray);
        float[] fArray = new float[8];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)nArray[i] / (float)n;
        }
        float f = Float.MAX_VALUE;
        int n2 = -1;
        for (int i = 0; i < RATIOS_TABLE.length; ++i) {
            float f2;
            float f3 = 0.0f;
            float[] fArray2 = RATIOS_TABLE[i];
            for (int j = 0; j < 8 && !((f3 += (f2 = fArray2[j] - fArray[j]) * f2) >= f); ++j) {
            }
            if (!(f3 < f)) continue;
            f = f3;
            n2 = PDF417Common.SYMBOL_TABLE[i];
        }
        return n2;
    }

    static {
        for (int i = 0; i < PDF417Common.SYMBOL_TABLE.length; ++i) {
            int n = PDF417Common.SYMBOL_TABLE[i];
            int n2 = n & 1;
            for (int j = 0; j < 8; ++j) {
                float f = 0.0f;
                while ((n & 1) == n2) {
                    f += 1.0f;
                    n >>= 1;
                }
                n2 = n & 1;
                PDF417CodewordDecoder.RATIOS_TABLE[i][8 - j - 1] = f / 17.0f;
            }
        }
    }
}

