/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder.ec;

import com.google.zxing.ChecksumException;
import com.google.zxing.pdf417.decoder.ec.ModulusGF;
import com.google.zxing.pdf417.decoder.ec.ModulusPoly;

public final class ErrorCorrection {
    private final ModulusGF field = ModulusGF.PDF417_GF;

    public int decode(int[] nArray, int n, int[] nArray2) throws ChecksumException {
        Object object;
        ModulusPoly modulusPoly = new ModulusPoly(this.field, nArray);
        int[] nArray3 = new int[n];
        boolean bl = false;
        for (int i = n; i > 0; --i) {
            int n2;
            nArray3[n - i] = n2 = modulusPoly.evaluateAt(this.field.exp(i));
            if (n2 == 0) continue;
            bl = true;
        }
        if (!bl) {
            return 0;
        }
        ModulusPoly modulusPoly2 = this.field.getOne();
        for (int modulusPoly4 : nArray2) {
            int nArray4 = this.field.exp(nArray.length - 1 - modulusPoly4);
            object = new ModulusPoly(this.field, new int[]{this.field.subtract(0, nArray4), 1});
            modulusPoly2 = modulusPoly2.multiply((ModulusPoly)object);
        }
        ModulusPoly modulusPoly3 = new ModulusPoly(this.field, nArray3);
        ModulusPoly[] modulusPolyArray = this.runEuclideanAlgorithm(this.field.buildMonomial(n, 1), modulusPoly3, n);
        ModulusPoly modulusPoly4 = modulusPolyArray[0];
        ModulusPoly modulusPoly5 = modulusPolyArray[1];
        int[] nArray4 = this.findErrorLocations(modulusPoly4);
        object = this.findErrorMagnitudes(modulusPoly5, modulusPoly4, nArray4);
        for (int i = 0; i < nArray4.length; ++i) {
            int n2 = nArray.length - 1 - this.field.log(nArray4[i]);
            if (n2 < 0) {
                throw ChecksumException.getChecksumInstance();
            }
            nArray[n2] = this.field.subtract(nArray[n2], (int)object[i]);
        }
        return nArray4.length;
    }

    private ModulusPoly[] runEuclideanAlgorithm(ModulusPoly modulusPoly, ModulusPoly modulusPoly2, int n) throws ChecksumException {
        ModulusPoly modulusPoly3;
        ModulusPoly modulusPoly4;
        if (modulusPoly.getDegree() < modulusPoly2.getDegree()) {
            modulusPoly4 = modulusPoly;
            modulusPoly = modulusPoly2;
            modulusPoly2 = modulusPoly4;
        }
        modulusPoly4 = modulusPoly;
        ModulusPoly modulusPoly5 = modulusPoly2;
        ModulusPoly modulusPoly6 = this.field.getZero();
        ModulusPoly modulusPoly7 = this.field.getOne();
        while (modulusPoly5.getDegree() >= n / 2) {
            ModulusPoly modulusPoly8 = modulusPoly4;
            ModulusPoly modulusPoly9 = modulusPoly6;
            modulusPoly4 = modulusPoly5;
            modulusPoly6 = modulusPoly7;
            if (modulusPoly4.isZero()) {
                throw ChecksumException.getChecksumInstance();
            }
            modulusPoly5 = modulusPoly8;
            modulusPoly3 = this.field.getZero();
            int n2 = modulusPoly4.getCoefficient(modulusPoly4.getDegree());
            int n3 = this.field.inverse(n2);
            while (modulusPoly5.getDegree() >= modulusPoly4.getDegree() && !modulusPoly5.isZero()) {
                int n4 = modulusPoly5.getDegree() - modulusPoly4.getDegree();
                int n5 = this.field.multiply(modulusPoly5.getCoefficient(modulusPoly5.getDegree()), n3);
                modulusPoly3 = modulusPoly3.add(this.field.buildMonomial(n4, n5));
                modulusPoly5 = modulusPoly5.subtract(modulusPoly4.multiplyByMonomial(n4, n5));
            }
            modulusPoly7 = modulusPoly3.multiply(modulusPoly6).subtract(modulusPoly9).negative();
        }
        int n6 = modulusPoly7.getCoefficient(0);
        if (n6 == 0) {
            throw ChecksumException.getChecksumInstance();
        }
        int n7 = this.field.inverse(n6);
        modulusPoly3 = modulusPoly7.multiply(n7);
        ModulusPoly modulusPoly10 = modulusPoly5.multiply(n7);
        return new ModulusPoly[]{modulusPoly3, modulusPoly10};
    }

    private int[] findErrorLocations(ModulusPoly modulusPoly) throws ChecksumException {
        int n = modulusPoly.getDegree();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 1; i < this.field.getSize() && n2 < n; ++i) {
            if (modulusPoly.evaluateAt(i) != 0) continue;
            nArray[n2] = this.field.inverse(i);
            ++n2;
        }
        if (n2 != n) {
            throw ChecksumException.getChecksumInstance();
        }
        return nArray;
    }

    private int[] findErrorMagnitudes(ModulusPoly modulusPoly, ModulusPoly modulusPoly2, int[] nArray) {
        int n = modulusPoly2.getDegree();
        int[] nArray2 = new int[n];
        for (int i = 1; i <= n; ++i) {
            nArray2[n - i] = this.field.multiply(i, modulusPoly2.getCoefficient(i));
        }
        ModulusPoly modulusPoly3 = new ModulusPoly(this.field, nArray2);
        int n2 = nArray.length;
        int[] nArray3 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = this.field.inverse(nArray[i]);
            int n4 = this.field.subtract(0, modulusPoly.evaluateAt(n3));
            int n5 = this.field.inverse(modulusPoly3.evaluateAt(n3));
            nArray3[i] = this.field.multiply(n4, n5);
        }
        return nArray3;
    }
}

