/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.detector;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Detector {
    private static final int[] INDEXES_START_PATTERN = new int[]{0, 4, 1, 5};
    private static final int[] INDEXES_STOP_PATTERN = new int[]{6, 2, 7, 3};
    private static final int INTEGER_MATH_SHIFT = 8;
    private static final int PATTERN_MATCH_RESULT_SCALE_FACTOR = 256;
    private static final int MAX_AVG_VARIANCE = 107;
    private static final int MAX_INDIVIDUAL_VARIANCE = 204;
    private static final int[] START_PATTERN = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
    private static final int[] STOP_PATTERN = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private static final int MAX_PIXEL_DRIFT = 3;
    private static final int MAX_PATTERN_DRIFT = 5;
    private static final int SKIPPED_ROW_COUNT_MAX = 25;
    private static final int ROW_STEP = 5;
    private static final int BARCODE_MIN_HEIGHT = 10;

    private Detector() {
    }

    public static PDF417DetectorResult detect(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map, boolean bl) throws NotFoundException {
        BitMatrix bitMatrix = binaryBitmap.getBlackMatrix();
        List<ResultPoint[]> list = Detector.detect(bl, bitMatrix);
        if (list.isEmpty()) {
            Detector.rotate180(bitMatrix);
            list = Detector.detect(bl, bitMatrix);
        }
        return new PDF417DetectorResult(bitMatrix, list);
    }

    private static List<ResultPoint[]> detect(boolean bl, BitMatrix bitMatrix) {
        ArrayList<ResultPoint[]> arrayList = new ArrayList<ResultPoint[]>();
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        while (n < bitMatrix.getHeight()) {
            ResultPoint[] resultPointArray = Detector.findVertices(bitMatrix, n, n2);
            if (resultPointArray[0] == null && resultPointArray[3] == null) {
                if (!bl2) break;
                bl2 = false;
                n2 = 0;
                for (ResultPoint[] resultPointArray2 : arrayList) {
                    if (resultPointArray2[1] != null) {
                        n = (int)Math.max((float)n, resultPointArray2[1].getY());
                    }
                    if (resultPointArray2[3] == null) continue;
                    n = Math.max(n, (int)resultPointArray2[3].getY());
                }
                n += 5;
                continue;
            }
            bl2 = true;
            arrayList.add(resultPointArray);
            if (!bl) break;
            if (resultPointArray[2] != null) {
                n2 = (int)resultPointArray[2].getX();
                n = (int)resultPointArray[2].getY();
                continue;
            }
            n2 = (int)resultPointArray[4].getX();
            n = (int)resultPointArray[4].getY();
        }
        return arrayList;
    }

    static void rotate180(BitMatrix bitMatrix) {
        int n = bitMatrix.getWidth();
        int n2 = bitMatrix.getHeight();
        BitArray bitArray = new BitArray(n);
        BitArray bitArray2 = new BitArray(n);
        BitArray bitArray3 = new BitArray(n);
        for (int i = 0; i < n2 + 1 >> 1; ++i) {
            bitArray = bitMatrix.getRow(i, bitArray);
            bitMatrix.setRow(i, Detector.mirror(bitMatrix.getRow(n2 - 1 - i, bitArray2), bitArray3));
            bitMatrix.setRow(n2 - 1 - i, Detector.mirror(bitArray, bitArray3));
        }
    }

    static BitArray mirror(BitArray bitArray, BitArray bitArray2) {
        bitArray2.clear();
        int n = bitArray.getSize();
        for (int i = 0; i < n; ++i) {
            if (!bitArray.get(i)) continue;
            bitArray2.set(n - 1 - i);
        }
        return bitArray2;
    }

    private static ResultPoint[] findVertices(BitMatrix bitMatrix, int n, int n2) {
        int n3 = bitMatrix.getHeight();
        int n4 = bitMatrix.getWidth();
        ResultPoint[] resultPointArray = new ResultPoint[8];
        Detector.copyToResult(resultPointArray, Detector.findRowsWithPattern(bitMatrix, n3, n4, n, n2, START_PATTERN), INDEXES_START_PATTERN);
        if (resultPointArray[4] != null) {
            n2 = (int)resultPointArray[4].getX();
            n = (int)resultPointArray[4].getY();
        }
        Detector.copyToResult(resultPointArray, Detector.findRowsWithPattern(bitMatrix, n3, n4, n, n2, STOP_PATTERN), INDEXES_STOP_PATTERN);
        return resultPointArray;
    }

    private static void copyToResult(ResultPoint[] resultPointArray, ResultPoint[] resultPointArray2, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            resultPointArray[nArray[i]] = resultPointArray2[i];
        }
    }

    private static ResultPoint[] findRowsWithPattern(BitMatrix bitMatrix, int n, int n2, int n3, int n4, int[] nArray) {
        int n5;
        ResultPoint[] resultPointArray = new ResultPoint[4];
        boolean bl = false;
        int[] nArray2 = new int[nArray.length];
        while (n3 < n) {
            int[] nArray3 = Detector.findGuardPattern(bitMatrix, n4, n3, n2, false, nArray, nArray2);
            if (nArray3 != null) {
                while (n3 > 0) {
                    int[] nArray4;
                    if ((nArray4 = Detector.findGuardPattern(bitMatrix, n4, --n3, n2, false, nArray, nArray2)) != null) {
                        nArray3 = nArray4;
                        continue;
                    }
                    ++n3;
                    break;
                }
                resultPointArray[0] = new ResultPoint(nArray3[0], n3);
                resultPointArray[1] = new ResultPoint(nArray3[1], n3);
                bl = true;
                break;
            }
            n3 += 5;
        }
        if (bl) {
            int n6 = 0;
            int[] nArray5 = new int[]{(int)resultPointArray[0].getX(), (int)resultPointArray[1].getX()};
            for (n5 = n3 + 1; n5 < n; ++n5) {
                int[] nArray6 = Detector.findGuardPattern(bitMatrix, nArray5[0], n5, n2, false, nArray, nArray2);
                if (nArray6 != null && Math.abs(nArray5[0] - nArray6[0]) < 5 && Math.abs(nArray5[1] - nArray6[1]) < 5) {
                    nArray5 = nArray6;
                    n6 = 0;
                    continue;
                }
                if (n6 > 25) break;
                ++n6;
            }
            resultPointArray[2] = new ResultPoint(nArray5[0], n5 -= n6 + 1);
            resultPointArray[3] = new ResultPoint(nArray5[1], n5);
        }
        if (n5 - n3 < 10) {
            for (int i = 0; i < resultPointArray.length; ++i) {
                resultPointArray[i] = null;
            }
        }
        return resultPointArray;
    }

    private static int[] findGuardPattern(BitMatrix bitMatrix, int n, int n2, int n3, boolean bl, int[] nArray, int[] nArray2) {
        int n4;
        int n5;
        Arrays.fill(nArray2, 0, nArray2.length, 0);
        int n6 = nArray.length;
        boolean bl2 = bl;
        int n7 = 0;
        for (n5 = n; bitMatrix.get(n5, n2) && n5 > 0 && n7++ < 3; --n5) {
        }
        int n8 = 0;
        for (n4 = n5; n4 < n3; ++n4) {
            boolean bl3 = bitMatrix.get(n4, n2);
            if (bl3 ^ bl2) {
                int n9 = n8;
                nArray2[n9] = nArray2[n9] + 1;
                continue;
            }
            if (n8 == n6 - 1) {
                if (Detector.patternMatchVariance(nArray2, nArray, 204) < 107) {
                    return new int[]{n5, n4};
                }
                n5 += nArray2[0] + nArray2[1];
                System.arraycopy(nArray2, 2, nArray2, 0, n6 - 2);
                nArray2[n6 - 2] = 0;
                nArray2[n6 - 1] = 0;
                --n8;
            } else {
                ++n8;
            }
            nArray2[n8] = 1;
            bl2 = !bl2;
        }
        if (n8 == n6 - 1 && Detector.patternMatchVariance(nArray2, nArray, 204) < 107) {
            return new int[]{n5, n4 - 1};
        }
        return null;
    }

    private static int patternMatchVariance(int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += nArray[n2];
            n5 += nArray2[n2];
        }
        if (n4 < n5) {
            return Integer.MAX_VALUE;
        }
        n2 = (n4 << 8) / n5;
        n = n * n2 >> 8;
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7;
            int n8 = nArray[i] << 8;
            int n9 = nArray2[i] * n2;
            int n10 = n7 = n8 > n9 ? n8 - n9 : n9 - n8;
            if (n7 > n) {
                return Integer.MAX_VALUE;
            }
            n6 += n7;
        }
        return n6 / n4;
    }
}

