/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.encoder;

import com.google.zxing.WriterException;
import com.google.zxing.pdf417.encoder.Compaction;
import java.math.BigInteger;
import java.util.Arrays;

final class PDF417HighLevelEncoder {
    private static final int TEXT_COMPACTION = 0;
    private static final int BYTE_COMPACTION = 1;
    private static final int NUMERIC_COMPACTION = 2;
    private static final int SUBMODE_ALPHA = 0;
    private static final int SUBMODE_LOWER = 1;
    private static final int SUBMODE_MIXED = 2;
    private static final int SUBMODE_PUNCTUATION = 3;
    private static final int LATCH_TO_TEXT = 900;
    private static final int LATCH_TO_BYTE_PADDED = 901;
    private static final int LATCH_TO_NUMERIC = 902;
    private static final int SHIFT_TO_BYTE = 913;
    private static final int LATCH_TO_BYTE = 924;
    private static final byte[] TEXT_MIXED_RAW;
    private static final byte[] TEXT_PUNCTUATION_RAW;
    private static final byte[] MIXED;
    private static final byte[] PUNCTUATION;

    private PDF417HighLevelEncoder() {
    }

    private static byte[] getBytesForMessage(String string) {
        return string.getBytes();
    }

    static String encodeHighLevel(String string, Compaction compaction) throws WriterException {
        byte[] byArray = null;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        if (compaction == Compaction.TEXT) {
            PDF417HighLevelEncoder.encodeText(string, n2, n, stringBuilder, n3);
        } else if (compaction == Compaction.BYTE) {
            byArray = PDF417HighLevelEncoder.getBytesForMessage(string);
            PDF417HighLevelEncoder.encodeBinary(byArray, n2, byArray.length, 1, stringBuilder);
        } else if (compaction == Compaction.NUMERIC) {
            stringBuilder.append('\u0386');
            PDF417HighLevelEncoder.encodeNumeric(string, n2, n, stringBuilder);
        } else {
            int n4 = 0;
            while (n2 < n) {
                int n5;
                int n6 = PDF417HighLevelEncoder.determineConsecutiveDigitCount(string, n2);
                if (n6 >= 13) {
                    stringBuilder.append('\u0386');
                    n4 = 2;
                    n3 = 0;
                    PDF417HighLevelEncoder.encodeNumeric(string, n2, n6, stringBuilder);
                    n2 += n6;
                    continue;
                }
                int n7 = PDF417HighLevelEncoder.determineConsecutiveTextCount(string, n2);
                if (n7 >= 5 || n6 == n) {
                    if (n4 != 0) {
                        stringBuilder.append('\u0384');
                        n4 = 0;
                        n3 = 0;
                    }
                    n3 = PDF417HighLevelEncoder.encodeText(string, n2, n7, stringBuilder, n3);
                    n2 += n7;
                    continue;
                }
                if (byArray == null) {
                    byArray = PDF417HighLevelEncoder.getBytesForMessage(string);
                }
                if ((n5 = PDF417HighLevelEncoder.determineConsecutiveBinaryCount(string, byArray, n2)) == 0) {
                    n5 = 1;
                }
                if (n5 == 1 && n4 == 0) {
                    PDF417HighLevelEncoder.encodeBinary(byArray, n2, 1, 0, stringBuilder);
                } else {
                    PDF417HighLevelEncoder.encodeBinary(byArray, n2, n5, n4, stringBuilder);
                    n4 = 1;
                    n3 = 0;
                }
                n2 += n5;
            }
        }
        return stringBuilder.toString();
    }

    private static int encodeText(CharSequence charSequence, int n, int n2, StringBuilder stringBuilder, int n3) {
        int n4;
        char c;
        StringBuilder stringBuilder2 = new StringBuilder(n2);
        int n5 = n3;
        int n6 = 0;
        block5: while (true) {
            c = charSequence.charAt(n + n6);
            switch (n5) {
                case 0: {
                    if (PDF417HighLevelEncoder.isAlphaUpper(c)) {
                        if (c == ' ') {
                            stringBuilder2.append('\u001a');
                            break;
                        }
                        stringBuilder2.append((char)(c - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(c)) {
                        n5 = 1;
                        stringBuilder2.append('\u001b');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isMixed(c)) {
                        n5 = 2;
                        stringBuilder2.append('\u001c');
                        continue block5;
                    }
                    stringBuilder2.append('\u001d');
                    stringBuilder2.append((char)PUNCTUATION[c]);
                    break;
                }
                case 1: {
                    if (PDF417HighLevelEncoder.isAlphaLower(c)) {
                        if (c == ' ') {
                            stringBuilder2.append('\u001a');
                            break;
                        }
                        stringBuilder2.append((char)(c - 97));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(c)) {
                        stringBuilder2.append('\u001b');
                        stringBuilder2.append((char)(c - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isMixed(c)) {
                        n5 = 2;
                        stringBuilder2.append('\u001c');
                        continue block5;
                    }
                    stringBuilder2.append('\u001d');
                    stringBuilder2.append((char)PUNCTUATION[c]);
                    break;
                }
                case 2: {
                    if (PDF417HighLevelEncoder.isMixed(c)) {
                        stringBuilder2.append((char)MIXED[c]);
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(c)) {
                        n5 = 0;
                        stringBuilder2.append('\u001c');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(c)) {
                        n5 = 1;
                        stringBuilder2.append('\u001b');
                        continue block5;
                    }
                    if (n + n6 + 1 < n2 && PDF417HighLevelEncoder.isPunctuation((char)(n4 = (int)charSequence.charAt(n + n6 + 1)))) {
                        n5 = 3;
                        stringBuilder2.append('\u0019');
                        continue block5;
                    }
                    stringBuilder2.append('\u001d');
                    stringBuilder2.append((char)PUNCTUATION[c]);
                    break;
                }
                default: {
                    if (PDF417HighLevelEncoder.isPunctuation(c)) {
                        stringBuilder2.append((char)PUNCTUATION[c]);
                        break;
                    }
                    n5 = 0;
                    stringBuilder2.append('\u001d');
                    continue block5;
                }
            }
            if (++n6 >= n2) break;
        }
        c = '\u0000';
        n4 = stringBuilder2.length();
        for (int i = 0; i < n4; ++i) {
            boolean bl;
            boolean bl2 = bl = i % 2 != 0;
            if (bl) {
                c = (char)(c * 30 + stringBuilder2.charAt(i));
                stringBuilder.append(c);
                continue;
            }
            c = stringBuilder2.charAt(i);
        }
        if (n4 % 2 != 0) {
            stringBuilder.append((char)(c * 30 + 29));
        }
        return n5;
    }

    private static void encodeBinary(byte[] byArray, int n, int n2, int n3, StringBuilder stringBuilder) {
        int n4;
        if (n2 == 1 && n3 == 0) {
            stringBuilder.append('\u0391');
        } else {
            int n5 = n4 = n2 % 6 == 0 ? 1 : 0;
            if (n4 != 0) {
                stringBuilder.append('\u039c');
            } else {
                stringBuilder.append('\u0385');
            }
        }
        n4 = n;
        if (n2 >= 6) {
            char[] cArray = new char[5];
            while (n + n2 - n4 >= 6) {
                int n6;
                long l = 0L;
                for (n6 = 0; n6 < 6; ++n6) {
                    l <<= 8;
                    l += (long)(byArray[n4 + n6] & 0xFF);
                }
                for (n6 = 0; n6 < 5; ++n6) {
                    cArray[n6] = (char)(l % 900L);
                    l /= 900L;
                }
                for (n6 = cArray.length - 1; n6 >= 0; --n6) {
                    stringBuilder.append(cArray[n6]);
                }
                n4 += 6;
            }
        }
        for (int i = n4; i < n + n2; ++i) {
            int n7 = byArray[i] & 0xFF;
            stringBuilder.append((char)n7);
        }
    }

    private static void encodeNumeric(String string, int n, int n2, StringBuilder stringBuilder) {
        int n3;
        StringBuilder stringBuilder2 = new StringBuilder(n2 / 3 + 1);
        BigInteger bigInteger = BigInteger.valueOf(900L);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        for (int i = 0; i < n2 - 1; i += n3) {
            stringBuilder2.setLength(0);
            n3 = Math.min(44, n2 - i);
            String string2 = "1" + string.substring(n + i, n + i + n3);
            BigInteger bigInteger3 = new BigInteger(string2);
            do {
                stringBuilder2.append((char)bigInteger3.mod(bigInteger).intValue());
            } while (!(bigInteger3 = bigInteger3.divide(bigInteger)).equals(bigInteger2));
            for (int j = stringBuilder2.length() - 1; j >= 0; --j) {
                stringBuilder.append(stringBuilder2.charAt(j));
            }
        }
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlphaUpper(char c) {
        return c == ' ' || c >= 'A' && c <= 'Z';
    }

    private static boolean isAlphaLower(char c) {
        return c == ' ' || c >= 'a' && c <= 'z';
    }

    private static boolean isMixed(char c) {
        return MIXED[c] != -1;
    }

    private static boolean isPunctuation(char c) {
        return PUNCTUATION[c] != -1;
    }

    private static boolean isText(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '~';
    }

    private static int determineConsecutiveDigitCount(CharSequence charSequence, int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = charSequence.length();
        if (n3 < n4) {
            char c = charSequence.charAt(n3);
            while (PDF417HighLevelEncoder.isDigit(c) && n3 < n4) {
                ++n2;
                if (++n3 >= n4) continue;
                c = charSequence.charAt(n3);
            }
        }
        return n2;
    }

    private static int determineConsecutiveTextCount(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = n;
        while (n3 < n2) {
            int n4;
            char c = charSequence.charAt(n3);
            for (n4 = 0; n4 < 13 && PDF417HighLevelEncoder.isDigit(c) && n3 < n2; ++n4) {
                if (++n3 >= n2) continue;
                c = charSequence.charAt(n3);
            }
            if (n4 >= 13) {
                return n3 - n - n4;
            }
            if (n4 > 0) continue;
            c = charSequence.charAt(n3);
            if (!PDF417HighLevelEncoder.isText(c)) break;
            ++n3;
        }
        return n3 - n;
    }

    private static int determineConsecutiveBinaryCount(CharSequence charSequence, byte[] byArray, int n) throws WriterException {
        int n2;
        int n3 = charSequence.length();
        for (n2 = n; n2 < n3; ++n2) {
            int n4;
            int n5;
            char c = charSequence.charAt(n2);
            int n6 = 0;
            while (n6 < 13 && PDF417HighLevelEncoder.isDigit(c) && (n5 = n2 + ++n6) < n3) {
                c = charSequence.charAt(n5);
            }
            if (n6 >= 13) {
                return n2 - n;
            }
            n5 = 0;
            while (n5 < 5 && PDF417HighLevelEncoder.isText(c) && (n4 = n2 + ++n5) < n3) {
                c = charSequence.charAt(n4);
            }
            if (n5 >= 5) {
                return n2 - n;
            }
            c = charSequence.charAt(n2);
            if (byArray[n2] != 63 || c == '?') continue;
            throw new WriterException("Non-encodable character detected: " + c + " (Unicode: " + c + ")");
        }
        return n2 - n;
    }

    static {
        byte by;
        int n;
        TEXT_MIXED_RAW = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 38, 13, 9, 44, 58, 35, 45, 46, 36, 47, 43, 37, 42, 61, 94, 0, 32, 0, 0, 0};
        TEXT_PUNCTUATION_RAW = new byte[]{59, 60, 62, 64, 91, 92, 93, 95, 96, 126, 33, 13, 9, 44, 58, 10, 45, 46, 36, 47, 34, 124, 42, 40, 41, 63, 123, 125, 39, 0};
        MIXED = new byte[128];
        PUNCTUATION = new byte[128];
        Arrays.fill(MIXED, (byte)-1);
        for (n = 0; n < TEXT_MIXED_RAW.length; n = (int)((byte)(n + 1))) {
            by = TEXT_MIXED_RAW[n];
            if (by <= 0) continue;
            PDF417HighLevelEncoder.MIXED[by] = n;
        }
        Arrays.fill(PUNCTUATION, (byte)-1);
        for (n = 0; n < TEXT_PUNCTUATION_RAW.length; n = (int)((byte)(n + 1))) {
            by = TEXT_PUNCTUATION_RAW[n];
            if (by <= 0) continue;
            PDF417HighLevelEncoder.PUNCTUATION[by] = n;
        }
    }
}

