/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.common.BitMatrix;

abstract class DataMask {
    private static final DataMask[] DATA_MASKS = new DataMask[]{new DataMask000(), new DataMask001(), new DataMask010(), new DataMask011(), new DataMask100(), new DataMask101(), new DataMask110(), new DataMask111()};

    private DataMask() {
    }

    final void unmaskBitMatrix(BitMatrix bitMatrix, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!this.isMasked(i, j)) continue;
                bitMatrix.flip(j, i);
            }
        }
    }

    abstract boolean isMasked(int var1, int var2);

    static DataMask forReference(int n) {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException();
        }
        return DATA_MASKS[n];
    }

    private static final class DataMask111
    extends DataMask {
        private DataMask111() {
        }

        @Override
        boolean isMasked(int n, int n2) {
            return ((n + n2 & 1) + n * n2 % 3 & 1) == 0;
        }
    }

    private static final class DataMask110
    extends DataMask {
        private DataMask110() {
        }

        @Override
        boolean isMasked(int n, int n2) {
            int n3 = n * n2;
            return ((n3 & 1) + n3 % 3 & 1) == 0;
        }
    }

    private static final class DataMask101
    extends DataMask {
        private DataMask101() {
        }

        @Override
        boolean isMasked(int n, int n2) {
            int n3 = n * n2;
            return (n3 & 1) + n3 % 3 == 0;
        }
    }

    private static final class DataMask100
    extends DataMask {
        private DataMask100() {
        }

        @Override
        boolean isMasked(int n, int n2) {
            return ((n >>> 1) + n2 / 3 & 1) == 0;
        }
    }

    private static final class DataMask011
    extends DataMask {
        private DataMask011() {
        }

        @Override
        boolean isMasked(int n, int n2) {
            return (n + n2) % 3 == 0;
        }
    }

    private static final class DataMask010
    extends DataMask {
        private DataMask010() {
        }

        @Override
        boolean isMasked(int n, int n2) {
            return n2 % 3 == 0;
        }
    }

    private static final class DataMask001
    extends DataMask {
        private DataMask001() {
        }

        @Override
        boolean isMasked(int n, int n2) {
            return (n & 1) == 0;
        }
    }

    private static final class DataMask000
    extends DataMask {
        private DataMask000() {
        }

        @Override
        boolean isMasked(int n, int n2) {
            return (n + n2 & 1) == 0;
        }
    }
}

