/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import com.google.zxing.qrcode.decoder.BitMatrixParser;
import com.google.zxing.qrcode.decoder.DataBlock;
import com.google.zxing.qrcode.decoder.DecodedBitStreamParser;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.QRCodeDecoderMetaData;
import com.google.zxing.qrcode.decoder.Version;
import java.util.Map;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.QR_CODE_FIELD_256);

    public DecoderResult decode(boolean[][] blArray) throws ChecksumException, FormatException {
        return this.decode(blArray, null);
    }

    public DecoderResult decode(boolean[][] blArray, Map<DecodeHintType, ?> map) throws ChecksumException, FormatException {
        int n = blArray.length;
        BitMatrix bitMatrix = new BitMatrix(n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!blArray[i][j]) continue;
                bitMatrix.set(j, i);
            }
        }
        return this.decode(bitMatrix, map);
    }

    public DecoderResult decode(BitMatrix bitMatrix) throws ChecksumException, FormatException {
        return this.decode(bitMatrix, null);
    }

    public DecoderResult decode(BitMatrix bitMatrix, Map<DecodeHintType, ?> map) throws FormatException, ChecksumException {
        BitMatrixParser bitMatrixParser = new BitMatrixParser(bitMatrix);
        FormatException formatException = null;
        ChecksumException checksumException = null;
        try {
            return this.decode(bitMatrixParser, map);
        }
        catch (FormatException formatException2) {
            formatException = formatException2;
        }
        catch (ChecksumException checksumException2) {
            checksumException = checksumException2;
        }
        try {
            bitMatrixParser.remask();
            bitMatrixParser.setMirror(true);
            bitMatrixParser.readVersion();
            bitMatrixParser.readFormatInformation();
            bitMatrixParser.mirror();
            DecoderResult decoderResult = this.decode(bitMatrixParser, map);
            decoderResult.setOther(new QRCodeDecoderMetaData(true));
            return decoderResult;
        }
        catch (FormatException formatException3) {
            if (formatException != null) {
                throw formatException;
            }
            if (checksumException != null) {
                throw checksumException;
            }
            throw formatException3;
        }
        catch (ChecksumException checksumException3) {
            if (formatException != null) {
                throw formatException;
            }
            if (checksumException != null) {
                throw checksumException;
            }
            throw checksumException3;
        }
    }

    private DecoderResult decode(BitMatrixParser bitMatrixParser, Map<DecodeHintType, ?> map) throws FormatException, ChecksumException {
        Version version = bitMatrixParser.readVersion();
        ErrorCorrectionLevel errorCorrectionLevel = bitMatrixParser.readFormatInformation().getErrorCorrectionLevel();
        byte[] byArray = bitMatrixParser.readCodewords();
        DataBlock[] dataBlockArray = DataBlock.getDataBlocks(byArray, version, errorCorrectionLevel);
        int n = 0;
        for (DataBlock dataBlock : dataBlockArray) {
            n += dataBlock.getNumDataCodewords();
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (DataBlock dataBlock : dataBlockArray) {
            byte[] byArray3 = dataBlock.getCodewords();
            int n3 = dataBlock.getNumDataCodewords();
            this.correctErrors(byArray3, n3);
            for (int i = 0; i < n3; ++i) {
                byArray2[n2++] = byArray3[i];
            }
        }
        return DecodedBitStreamParser.decode(byArray2, version, errorCorrectionLevel, map);
    }

    private void correctErrors(byte[] byArray, int n) throws ChecksumException {
        int n2;
        int n3 = byArray.length;
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = byArray.length - n;
        try {
            this.rsDecoder.decode(nArray, n2);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)nArray[i];
        }
    }
}

