/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.PerspectiveTransform;
import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.detector.AlignmentPattern;
import com.google.zxing.qrcode.detector.AlignmentPatternFinder;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternFinder;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.Map;

public class Detector {
    private final BitMatrix image;
    private ResultPointCallback resultPointCallback;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final ResultPointCallback getResultPointCallback() {
        return this.resultPointCallback;
    }

    public DetectorResult detect() throws NotFoundException, FormatException {
        return this.detect(null);
    }

    public final DetectorResult detect(Map<DecodeHintType, ?> map) throws NotFoundException, FormatException {
        this.resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        FinderPatternFinder finderPatternFinder = new FinderPatternFinder(this.image, this.resultPointCallback);
        FinderPatternInfo finderPatternInfo = finderPatternFinder.find(map);
        return this.processFinderPatternInfo(finderPatternInfo);
    }

    protected final DetectorResult processFinderPatternInfo(FinderPatternInfo finderPatternInfo) throws NotFoundException, FormatException {
        FinderPattern finderPattern;
        FinderPattern finderPattern2;
        FinderPattern finderPattern3 = finderPatternInfo.getTopLeft();
        float f = this.calculateModuleSize(finderPattern3, finderPattern2 = finderPatternInfo.getTopRight(), finderPattern = finderPatternInfo.getBottomLeft());
        if (f < 1.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n = Detector.computeDimension(finderPattern3, finderPattern2, finderPattern, f);
        Version version = Version.getProvisionalVersionForDimension(n);
        int n2 = version.getDimensionForVersion() - 7;
        AlignmentPattern alignmentPattern = null;
        if (version.getAlignmentPatternCenters().length > 0) {
            float f2 = finderPattern2.getX() - finderPattern3.getX() + finderPattern.getX();
            float f3 = finderPattern2.getY() - finderPattern3.getY() + finderPattern.getY();
            float f4 = 1.0f - 3.0f / (float)n2;
            int n3 = (int)(finderPattern3.getX() + f4 * (f2 - finderPattern3.getX()));
            int n4 = (int)(finderPattern3.getY() + f4 * (f3 - finderPattern3.getY()));
            for (int i = 4; i <= 16; i <<= 1) {
                try {
                    alignmentPattern = this.findAlignmentInRegion(f, n3, n4, i);
                    break;
                }
                catch (NotFoundException notFoundException) {
                    continue;
                }
            }
        }
        PerspectiveTransform perspectiveTransform = Detector.createTransform(finderPattern3, finderPattern2, finderPattern, alignmentPattern, n);
        BitMatrix bitMatrix = Detector.sampleGrid(this.image, perspectiveTransform, n);
        ResultPoint[] resultPointArray = alignmentPattern == null ? new ResultPoint[]{finderPattern, finderPattern3, finderPattern2} : new ResultPoint[]{finderPattern, finderPattern3, finderPattern2, alignmentPattern};
        return new DetectorResult(bitMatrix, resultPointArray);
    }

    private static PerspectiveTransform createTransform(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5 = (float)n - 3.5f;
        if (resultPoint4 != null) {
            f4 = resultPoint4.getX();
            f3 = resultPoint4.getY();
            f = f2 = f5 - 3.0f;
        } else {
            f4 = resultPoint2.getX() - resultPoint.getX() + resultPoint3.getX();
            f3 = resultPoint2.getY() - resultPoint.getY() + resultPoint3.getY();
            f2 = f5;
            f = f5;
        }
        return PerspectiveTransform.quadrilateralToQuadrilateral(3.5f, 3.5f, f5, 3.5f, f2, f, 3.5f, f5, resultPoint.getX(), resultPoint.getY(), resultPoint2.getX(), resultPoint2.getY(), f4, f3, resultPoint3.getX(), resultPoint3.getY());
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, PerspectiveTransform perspectiveTransform, int n) throws NotFoundException {
        GridSampler gridSampler = GridSampler.getInstance();
        return gridSampler.sampleGrid(bitMatrix, n, n, perspectiveTransform);
    }

    private static int computeDimension(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, float f) throws NotFoundException {
        int n = MathUtils.round(ResultPoint.distance(resultPoint, resultPoint2) / f);
        int n2 = MathUtils.round(ResultPoint.distance(resultPoint, resultPoint3) / f);
        int n3 = (n + n2 >> 1) + 7;
        switch (n3 & 3) {
            case 0: {
                ++n3;
                break;
            }
            case 2: {
                --n3;
                break;
            }
            case 3: {
                throw NotFoundException.getNotFoundInstance();
            }
        }
        return n3;
    }

    protected final float calculateModuleSize(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3) {
        return (this.calculateModuleSizeOneWay(resultPoint, resultPoint2) + this.calculateModuleSizeOneWay(resultPoint, resultPoint3)) / 2.0f;
    }

    private float calculateModuleSizeOneWay(ResultPoint resultPoint, ResultPoint resultPoint2) {
        float f = this.sizeOfBlackWhiteBlackRunBothWays((int)resultPoint.getX(), (int)resultPoint.getY(), (int)resultPoint2.getX(), (int)resultPoint2.getY());
        float f2 = this.sizeOfBlackWhiteBlackRunBothWays((int)resultPoint2.getX(), (int)resultPoint2.getY(), (int)resultPoint.getX(), (int)resultPoint.getY());
        if (Float.isNaN(f)) {
            return f2 / 7.0f;
        }
        if (Float.isNaN(f2)) {
            return f / 7.0f;
        }
        return (f + f2) / 14.0f;
    }

    private float sizeOfBlackWhiteBlackRunBothWays(int n, int n2, int n3, int n4) {
        float f = this.sizeOfBlackWhiteBlackRun(n, n2, n3, n4);
        float f2 = 1.0f;
        int n5 = n - (n3 - n);
        if (n5 < 0) {
            f2 = (float)n / (float)(n - n5);
            n5 = 0;
        } else if (n5 >= this.image.getWidth()) {
            f2 = (float)(this.image.getWidth() - 1 - n) / (float)(n5 - n);
            n5 = this.image.getWidth() - 1;
        }
        int n6 = (int)((float)n2 - (float)(n4 - n2) * f2);
        f2 = 1.0f;
        if (n6 < 0) {
            f2 = (float)n2 / (float)(n2 - n6);
            n6 = 0;
        } else if (n6 >= this.image.getHeight()) {
            f2 = (float)(this.image.getHeight() - 1 - n2) / (float)(n6 - n2);
            n6 = this.image.getHeight() - 1;
        }
        n5 = (int)((float)n + (float)(n5 - n) * f2);
        return (f += this.sizeOfBlackWhiteBlackRun(n, n2, n5, n6)) - 1.0f;
    }

    private float sizeOfBlackWhiteBlackRun(int n, int n2, int n3, int n4) {
        int n5;
        boolean bl;
        boolean bl2 = bl = Math.abs(n4 - n2) > Math.abs(n3 - n);
        if (bl) {
            n5 = n;
            n = n2;
            n2 = n5;
            n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        n5 = Math.abs(n3 - n);
        int n6 = Math.abs(n4 - n2);
        int n7 = -n5 >> 1;
        int n8 = n < n3 ? 1 : -1;
        int n9 = n2 < n4 ? 1 : -1;
        int n10 = 0;
        int n11 = n3 + n8;
        int n12 = n2;
        for (int i = n; i != n11; i += n8) {
            int n13;
            int n14;
            if (n10 == 1 == this.image.get(n14 = bl ? n12 : i, n13 = bl ? i : n12)) {
                if (n10 == 2) {
                    return MathUtils.distance(i, n12, n, n2);
                }
                ++n10;
            }
            if ((n7 += n6) <= 0) continue;
            if (n12 == n4) break;
            n12 += n9;
            n7 -= n5;
        }
        if (n10 == 2) {
            return MathUtils.distance(n3 + n8, n4, n, n2);
        }
        return Float.NaN;
    }

    protected final AlignmentPattern findAlignmentInRegion(float f, int n, int n2, float f2) throws NotFoundException {
        int n3 = (int)(f2 * f);
        int n4 = Math.max(0, n - n3);
        int n5 = Math.min(this.image.getWidth() - 1, n + n3);
        if ((float)(n5 - n4) < f * 3.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n6 = Math.max(0, n2 - n3);
        int n7 = Math.min(this.image.getHeight() - 1, n2 + n3);
        if ((float)(n7 - n6) < f * 3.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        AlignmentPatternFinder alignmentPatternFinder = new AlignmentPatternFinder(this.image, n4, n6, n5 - n4, n7 - n6, f, this.resultPointCallback);
        return alignmentPatternFinder.find();
    }
}

