/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class FinderPatternFinder {
    private static final int CENTER_QUORUM = 2;
    protected static final int MIN_SKIP = 3;
    protected static final int MAX_MODULES = 57;
    private static final int INTEGER_MATH_SHIFT = 8;
    private final BitMatrix image;
    private final List<FinderPattern> possibleCenters;
    private boolean hasSkipped;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    public FinderPatternFinder(BitMatrix bitMatrix) {
        this(bitMatrix, null);
    }

    public FinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        this.image = bitMatrix;
        this.possibleCenters = new ArrayList<FinderPattern>();
        this.crossCheckStateCount = new int[5];
        this.resultPointCallback = resultPointCallback;
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final List<FinderPattern> getPossibleCenters() {
        return this.possibleCenters;
    }

    final FinderPatternInfo find(Map<DecodeHintType, ?> map) throws NotFoundException {
        boolean bl = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        int n = this.image.getHeight();
        int n2 = this.image.getWidth();
        int n3 = 3 * n / 228;
        if (n3 < 3 || bl) {
            n3 = 3;
        }
        boolean bl2 = false;
        int[] nArray = new int[5];
        for (int i = n3 - 1; i < n && !bl2; i += n3) {
            int n4;
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 0;
            nArray[4] = 0;
            int n5 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                block5: {
                    block6: {
                        block7: {
                            block10: {
                                block8: {
                                    block9: {
                                        if (this.image.get(n4, i)) {
                                            if (n5 & true) {
                                                // empty if block
                                            }
                                            int n6 = ++n5;
                                            nArray[n6] = nArray[n6] + 1;
                                            continue;
                                        }
                                        if (n5 & true) break block5;
                                        if (n5 != 4) break block6;
                                        if (!FinderPatternFinder.foundPatternCross(nArray)) break block7;
                                        boolean bl3 = this.handlePossibleCenter(nArray, i, n4);
                                        if (!bl3) break block8;
                                        n3 = 2;
                                        if (!this.hasSkipped) break block9;
                                        bl2 = this.haveMultiplyConfirmedCenters();
                                        break block10;
                                    }
                                    int n7 = this.findRowSkip();
                                    if (n7 <= nArray[2]) break block10;
                                    i += n7 - nArray[2] - n3;
                                    n4 = n2 - 1;
                                    break block10;
                                }
                                nArray[0] = nArray[2];
                                nArray[1] = nArray[3];
                                nArray[2] = nArray[4];
                                nArray[3] = 1;
                                nArray[4] = 0;
                                n5 = 3;
                                continue;
                            }
                            n5 = 0;
                            nArray[0] = 0;
                            nArray[1] = 0;
                            nArray[2] = 0;
                            nArray[3] = 0;
                            nArray[4] = 0;
                            continue;
                        }
                        nArray[0] = nArray[2];
                        nArray[1] = nArray[3];
                        nArray[2] = nArray[4];
                        nArray[3] = 1;
                        nArray[4] = 0;
                        n5 = 3;
                        continue;
                    }
                    int n8 = ++n5;
                    nArray[n8] = nArray[n8] + 1;
                    continue;
                }
                int n9 = n5;
                nArray[n9] = nArray[n9] + 1;
            }
            if (!FinderPatternFinder.foundPatternCross(nArray) || (n4 = (int)(this.handlePossibleCenter(nArray, i, n2) ? 1 : 0)) == 0) continue;
            n3 = nArray[0];
            if (!this.hasSkipped) continue;
            bl2 = this.haveMultiplyConfirmedCenters();
        }
        ResultPoint[] resultPointArray = this.selectBestPatterns();
        ResultPoint.orderBestPatterns(resultPointArray);
        return new FinderPatternInfo((FinderPattern[])resultPointArray);
    }

    private static float centerFromEnd(int[] nArray, int n) {
        return (float)(n - nArray[4] - nArray[3]) - (float)nArray[2] / 2.0f;
    }

    protected static boolean foundPatternCross(int[] nArray) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            n = nArray[n2];
            if (n == 0) {
                return false;
            }
            n3 += n;
        }
        if (n3 < 7) {
            return false;
        }
        n2 = (n3 << 8) / 7;
        n = n2 / 2;
        return Math.abs(n2 - (nArray[0] << 8)) < n && Math.abs(n2 - (nArray[1] << 8)) < n && Math.abs(3 * n2 - (nArray[2] << 8)) < 3 * n && Math.abs(n2 - (nArray[3] << 8)) < n && Math.abs(n2 - (nArray[4] << 8)) < n;
    }

    private int[] getCrossCheckStateCount() {
        this.crossCheckStateCount[0] = 0;
        this.crossCheckStateCount[1] = 0;
        this.crossCheckStateCount[2] = 0;
        this.crossCheckStateCount[3] = 0;
        this.crossCheckStateCount[4] = 0;
        return this.crossCheckStateCount;
    }

    private float crossCheckVertical(int n, int n2, int n3, int n4) {
        int n5;
        BitMatrix bitMatrix = this.image;
        int n6 = bitMatrix.getHeight();
        int[] nArray = this.getCrossCheckStateCount();
        for (n5 = n; n5 >= 0 && bitMatrix.get(n2, n5); --n5) {
            nArray[2] = nArray[2] + 1;
        }
        if (n5 < 0) {
            return Float.NaN;
        }
        while (n5 >= 0 && !bitMatrix.get(n2, n5) && nArray[1] <= n3) {
            nArray[1] = nArray[1] + 1;
            --n5;
        }
        if (n5 < 0 || nArray[1] > n3) {
            return Float.NaN;
        }
        while (n5 >= 0 && bitMatrix.get(n2, n5) && nArray[0] <= n3) {
            nArray[0] = nArray[0] + 1;
            --n5;
        }
        if (nArray[0] > n3) {
            return Float.NaN;
        }
        for (n5 = n + 1; n5 < n6 && bitMatrix.get(n2, n5); ++n5) {
            nArray[2] = nArray[2] + 1;
        }
        if (n5 == n6) {
            return Float.NaN;
        }
        while (n5 < n6 && !bitMatrix.get(n2, n5) && nArray[3] < n3) {
            nArray[3] = nArray[3] + 1;
            ++n5;
        }
        if (n5 == n6 || nArray[3] >= n3) {
            return Float.NaN;
        }
        while (n5 < n6 && bitMatrix.get(n2, n5) && nArray[4] < n3) {
            nArray[4] = nArray[4] + 1;
            ++n5;
        }
        if (nArray[4] >= n3) {
            return Float.NaN;
        }
        int n7 = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4];
        if (5 * Math.abs(n7 - n4) >= 2 * n4) {
            return Float.NaN;
        }
        return FinderPatternFinder.foundPatternCross(nArray) ? FinderPatternFinder.centerFromEnd(nArray, n5) : Float.NaN;
    }

    private float crossCheckHorizontal(int n, int n2, int n3, int n4) {
        int n5;
        BitMatrix bitMatrix = this.image;
        int n6 = bitMatrix.getWidth();
        int[] nArray = this.getCrossCheckStateCount();
        for (n5 = n; n5 >= 0 && bitMatrix.get(n5, n2); --n5) {
            nArray[2] = nArray[2] + 1;
        }
        if (n5 < 0) {
            return Float.NaN;
        }
        while (n5 >= 0 && !bitMatrix.get(n5, n2) && nArray[1] <= n3) {
            nArray[1] = nArray[1] + 1;
            --n5;
        }
        if (n5 < 0 || nArray[1] > n3) {
            return Float.NaN;
        }
        while (n5 >= 0 && bitMatrix.get(n5, n2) && nArray[0] <= n3) {
            nArray[0] = nArray[0] + 1;
            --n5;
        }
        if (nArray[0] > n3) {
            return Float.NaN;
        }
        for (n5 = n + 1; n5 < n6 && bitMatrix.get(n5, n2); ++n5) {
            nArray[2] = nArray[2] + 1;
        }
        if (n5 == n6) {
            return Float.NaN;
        }
        while (n5 < n6 && !bitMatrix.get(n5, n2) && nArray[3] < n3) {
            nArray[3] = nArray[3] + 1;
            ++n5;
        }
        if (n5 == n6 || nArray[3] >= n3) {
            return Float.NaN;
        }
        while (n5 < n6 && bitMatrix.get(n5, n2) && nArray[4] < n3) {
            nArray[4] = nArray[4] + 1;
            ++n5;
        }
        if (nArray[4] >= n3) {
            return Float.NaN;
        }
        int n7 = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4];
        if (5 * Math.abs(n7 - n4) >= n4) {
            return Float.NaN;
        }
        return FinderPatternFinder.foundPatternCross(nArray) ? FinderPatternFinder.centerFromEnd(nArray, n5) : Float.NaN;
    }

    protected final boolean handlePossibleCenter(int[] nArray, int n, int n2) {
        int n3 = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4];
        float f = FinderPatternFinder.centerFromEnd(nArray, n2);
        float f2 = this.crossCheckVertical(n, (int)f, nArray[2], n3);
        if (!Float.isNaN(f2) && !Float.isNaN(f = this.crossCheckHorizontal((int)f, (int)f2, nArray[2], n3))) {
            float f3 = (float)n3 / 7.0f;
            boolean bl = false;
            for (int i = 0; i < this.possibleCenters.size(); ++i) {
                FinderPattern finderPattern = this.possibleCenters.get(i);
                if (!finderPattern.aboutEquals(f3, f2, f)) continue;
                this.possibleCenters.set(i, finderPattern.combineEstimate(f2, f, f3));
                bl = true;
                break;
            }
            if (!bl) {
                FinderPattern finderPattern = new FinderPattern(f, f2, f3);
                this.possibleCenters.add(finderPattern);
                if (this.resultPointCallback != null) {
                    this.resultPointCallback.foundPossibleResultPoint(finderPattern);
                }
            }
            return true;
        }
        return false;
    }

    private int findRowSkip() {
        int n = this.possibleCenters.size();
        if (n <= 1) {
            return 0;
        }
        FinderPattern finderPattern = null;
        for (FinderPattern finderPattern2 : this.possibleCenters) {
            if (finderPattern2.getCount() < 2) continue;
            if (finderPattern == null) {
                finderPattern = finderPattern2;
                continue;
            }
            this.hasSkipped = true;
            return (int)(Math.abs(finderPattern.getX() - finderPattern2.getX()) - Math.abs(finderPattern.getY() - finderPattern2.getY())) / 2;
        }
        return 0;
    }

    private boolean haveMultiplyConfirmedCenters() {
        int n = 0;
        float f = 0.0f;
        int n2 = this.possibleCenters.size();
        for (FinderPattern finderPattern : this.possibleCenters) {
            if (finderPattern.getCount() < 2) continue;
            ++n;
            f += finderPattern.getEstimatedModuleSize();
        }
        if (n < 3) {
            return false;
        }
        float f2 = f / (float)n2;
        float f3 = 0.0f;
        for (FinderPattern finderPattern : this.possibleCenters) {
            f3 += Math.abs(finderPattern.getEstimatedModuleSize() - f2);
        }
        return f3 <= 0.05f * f;
    }

    private FinderPattern[] selectBestPatterns() throws NotFoundException {
        float f;
        int n = this.possibleCenters.size();
        if (n < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n > 3) {
            float f2;
            f = 0.0f;
            float f3 = 0.0f;
            for (FinderPattern finderPattern : this.possibleCenters) {
                f2 = finderPattern.getEstimatedModuleSize();
                f += f2;
                f3 += f2 * f2;
            }
            float f4 = f / (float)n;
            float f5 = (float)Math.sqrt(f3 / (float)n - f4 * f4);
            Collections.sort(this.possibleCenters, new FurthestFromAverageComparator(f4));
            f2 = Math.max(0.2f * f4, f5);
            for (int i = 0; i < this.possibleCenters.size() && this.possibleCenters.size() > 3; ++i) {
                FinderPattern finderPattern = this.possibleCenters.get(i);
                if (!(Math.abs(finderPattern.getEstimatedModuleSize() - f4) > f2)) continue;
                this.possibleCenters.remove(i);
                --i;
            }
        }
        if (this.possibleCenters.size() > 3) {
            f = 0.0f;
            for (FinderPattern finderPattern : this.possibleCenters) {
                f += finderPattern.getEstimatedModuleSize();
            }
            float f6 = f / (float)this.possibleCenters.size();
            Collections.sort(this.possibleCenters, new CenterComparator(f6));
            this.possibleCenters.subList(3, this.possibleCenters.size()).clear();
        }
        return new FinderPattern[]{this.possibleCenters.get(0), this.possibleCenters.get(1), this.possibleCenters.get(2)};
    }

    private static final class CenterComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private static final long serialVersionUID = 413384336666511204L;
        private final float average;

        private CenterComparator(float f) {
            this.average = f;
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            if (finderPattern2.getCount() == finderPattern.getCount()) {
                float f;
                float f2 = Math.abs(finderPattern2.getEstimatedModuleSize() - this.average);
                return f2 < (f = Math.abs(finderPattern.getEstimatedModuleSize() - this.average)) ? 1 : (f2 == f ? 0 : -1);
            }
            return finderPattern2.getCount() - finderPattern.getCount();
        }
    }

    private static final class FurthestFromAverageComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private static final long serialVersionUID = -2391284320750242249L;
        private final float average;

        private FurthestFromAverageComparator(float f) {
            this.average = f;
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            float f;
            float f2 = Math.abs(finderPattern2.getEstimatedModuleSize() - this.average);
            return f2 < (f = Math.abs(finderPattern.getEstimatedModuleSize() - this.average)) ? -1 : (f2 == f ? 0 : 1);
        }
    }
}

