/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.qrcode.encoder.ByteMatrix;

final class MaskUtil {
    private static final int N1 = 3;
    private static final int N2 = 3;
    private static final int N3 = 40;
    private static final int N4 = 10;

    private MaskUtil() {
    }

    static int applyMaskPenaltyRule1(ByteMatrix byteMatrix) {
        return MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, true) + MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, false);
    }

    static int applyMaskPenaltyRule2(ByteMatrix byteMatrix) {
        int n = 0;
        byte[][] byArray = byteMatrix.getArray();
        int n2 = byteMatrix.getWidth();
        int n3 = byteMatrix.getHeight();
        for (int i = 0; i < n3 - 1; ++i) {
            for (int j = 0; j < n2 - 1; ++j) {
                byte by = byArray[i][j];
                if (by != byArray[i][j + 1] || by != byArray[i + 1][j] || by != byArray[i + 1][j + 1]) continue;
                ++n;
            }
        }
        return 3 * n;
    }

    static int applyMaskPenaltyRule3(ByteMatrix byteMatrix) {
        int n = 0;
        byte[][] byArray = byteMatrix.getArray();
        int n2 = byteMatrix.getWidth();
        int n3 = byteMatrix.getHeight();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                byte[] byArray2 = byArray[i];
                if (j + 6 < n2 && byArray2[j] == 1 && byArray2[j + 1] == 0 && byArray2[j + 2] == 1 && byArray2[j + 3] == 1 && byArray2[j + 4] == 1 && byArray2[j + 5] == 0 && byArray2[j + 6] == 1 && (MaskUtil.isWhiteHorizontal(byArray2, j - 4, j) || MaskUtil.isWhiteHorizontal(byArray2, j + 7, j + 11))) {
                    ++n;
                }
                if (i + 6 >= n3 || byArray[i][j] != 1 || byArray[i + 1][j] != 0 || byArray[i + 2][j] != 1 || byArray[i + 3][j] != 1 || byArray[i + 4][j] != 1 || byArray[i + 5][j] != 0 || byArray[i + 6][j] != 1 || !MaskUtil.isWhiteVertical(byArray, j, i - 4, i) && !MaskUtil.isWhiteVertical(byArray, j, i + 7, i + 11)) continue;
                ++n;
            }
        }
        return n * 40;
    }

    private static boolean isWhiteHorizontal(byte[] byArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (i < 0 || i >= byArray.length || byArray[i] != 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteVertical(byte[][] byArray, int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            if (i < 0 || i >= byArray.length || byArray[i][n] != 1) continue;
            return false;
        }
        return true;
    }

    static int applyMaskPenaltyRule4(ByteMatrix byteMatrix) {
        int n;
        int n2 = 0;
        byte[][] byArray = byteMatrix.getArray();
        int n3 = byteMatrix.getWidth();
        int n4 = byteMatrix.getHeight();
        for (n = 0; n < n4; ++n) {
            byte[] byArray2 = byArray[n];
            for (int i = 0; i < n3; ++i) {
                if (byArray2[i] != 1) continue;
                ++n2;
            }
        }
        n = byteMatrix.getHeight() * byteMatrix.getWidth();
        int n5 = Math.abs(n2 * 2 - n) * 10 / n;
        return n5 * 10;
    }

    static boolean getDataMaskBit(int n, int n2, int n3) {
        int n4;
        switch (n) {
            case 0: {
                n4 = n3 + n2 & 1;
                break;
            }
            case 1: {
                n4 = n3 & 1;
                break;
            }
            case 2: {
                n4 = n2 % 3;
                break;
            }
            case 3: {
                n4 = (n3 + n2) % 3;
                break;
            }
            case 4: {
                n4 = (n3 >>> 1) + n2 / 3 & 1;
                break;
            }
            case 5: {
                int n5 = n3 * n2;
                n4 = (n5 & 1) + n5 % 3;
                break;
            }
            case 6: {
                int n6 = n3 * n2;
                n4 = (n6 & 1) + n6 % 3 & 1;
                break;
            }
            case 7: {
                int n7 = n3 * n2;
                n4 = n7 % 3 + (n3 + n2 & 1) & 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mask pattern: " + n);
            }
        }
        return n4 == 0;
    }

    private static int applyMaskPenaltyRule1Internal(ByteMatrix byteMatrix, boolean bl) {
        int n = 0;
        int n2 = bl ? byteMatrix.getHeight() : byteMatrix.getWidth();
        int n3 = bl ? byteMatrix.getWidth() : byteMatrix.getHeight();
        byte[][] byArray = byteMatrix.getArray();
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            byte by = -1;
            for (int j = 0; j < n3; ++j) {
                byte by2;
                byte by3 = by2 = bl ? byArray[i][j] : byArray[j][i];
                if (by2 == by) {
                    ++n4;
                    continue;
                }
                if (n4 >= 5) {
                    n += 3 + (n4 - 5);
                }
                n4 = 1;
                by = by2;
            }
            if (n4 < 5) continue;
            n += 3 + (n4 - 5);
        }
        return n;
    }
}

