/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.misc;

import de.wilke.misc.treetable.attributes.AbstractAttribute;
import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.templateeditor.MyDialog;
import de.wilke.wizepanel.templateeditor.Txt;
import de.wilke.wizepanel.templateeditor.WPTemplates;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
extends MyDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 0L;
    private int return_value;
    private final JTextField m_font_name;
    private final JTextField m_font_style;
    private final JTextField m_font_size;
    private final JList<String> m_font_names;
    private final JList<String> m_font_styles;
    private final JList<String> m_font_sizes;
    private final JTextField m_preview;
    private AbstractAttribute prop;

    public FontChooser(WPTemplates wPTemplates) {
        super(wPTemplates.frame());
        this.setTitle(WPApp.tr((String)"font_chooser"));
        this.setSize(640, 380);
        this.setMinimumSize(new Dimension(640, 380));
        this.setLocationRelativeTo(wPTemplates.frame());
        this.m_font_name = new JTextField();
        this.m_font_names = new JList<String>(wPTemplates.fonts());
        this.m_font_names.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.m_font_names);
        jScrollPane.setPreferredSize(new Dimension(250, 200));
        this.m_font_size = new JTextField();
        this.m_font_size.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (FontChooser.this.m_font_size.getText() == null || FontChooser.this.m_font_size.getText().isEmpty()) {
                    return;
                }
                try {
                    Integer n = Integer.parseInt(FontChooser.this.m_font_size.getText());
                    FontChooser.this.m_font_sizes.setSelectedValue(String.valueOf(n), true);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        String[] stringArray = new String[400];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = String.valueOf(3 + i);
        }
        this.m_font_sizes = new JList<String>(stringArray);
        this.m_font_sizes.addListSelectionListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.m_font_sizes);
        jScrollPane2.setPreferredSize(new Dimension(150, 200));
        this.m_font_style = new JTextField();
        String[] stringArray2 = new String[]{WPApp.tr((String)"font.plain"), WPApp.tr((String)"font.italic"), WPApp.tr((String)"font.bold"), WPApp.tr((String)"font.bolditalic")};
        this.m_font_styles = new JList<String>(stringArray2);
        this.m_font_styles.addListSelectionListener(this);
        JScrollPane jScrollPane3 = new JScrollPane(this.m_font_styles);
        jScrollPane3.setPreferredSize(new Dimension(150, 200));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.m_font_name, "North");
        jPanel.add((Component)new JScrollPane(this.m_font_names), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.m_font_style, "North");
        jPanel2.add((Component)jScrollPane3, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.m_font_size, "North");
        jPanel3.add((Component)jScrollPane2, "Center");
        JPanel jPanel4 = new JPanel(new GridLayout(1, 3, 5, 5));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        JButton jButton = new JButton(WPApp.tr((String)"button.ok"));
        jButton.setActionCommand("button.ok");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(WPApp.tr((String)"button.cancel"));
        jButton2.setActionCommand("button.cancel");
        jButton2.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jButton);
        jPanel5.add(jButton2);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        this.m_preview = new JTextField(WPApp.tr((String)"font.preview_text"));
        this.m_preview.setPreferredSize(new Dimension(0, 100));
        this.m_preview.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_preview.setHorizontalAlignment(0);
        jPanel6.add((Component)this.m_preview, "Center");
        jPanel6.add((Component)jPanel5, "South");
        JPanel jPanel7 = new JPanel(new BorderLayout(5, 5));
        jPanel7.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel7.add((Component)jPanel4, "Center");
        jPanel7.add((Component)jPanel6, "South");
        this.setContentPane(jPanel7);
    }

    public void setProperty(AbstractAttribute abstractAttribute) {
        this.prop = abstractAttribute;
    }

    public void setFontString(String string) {
        int n;
        String[] stringArray = string.split("-");
        if (stringArray.length < 3) {
            return;
        }
        String string2 = stringArray[stringArray.length - 1];
        String string3 = stringArray[stringArray.length - 2];
        Object object = stringArray[0];
        if (stringArray.length != 3) {
            for (n = 1; n < stringArray.length - 2; ++n) {
                object = (String)object + "-" + stringArray[n];
            }
        }
        this.m_font_name.setText((String)object);
        this.m_font_names.setSelectedValue(object, true);
        this.m_font_style.setText(string3);
        this.m_font_styles.setSelectedIndex(Txt.style2number(string3));
        this.m_font_size.setText(string2);
        this.m_font_sizes.setSelectedValue(string2, true);
        if (this.m_font_sizes.getSelectedIndex() == -1) {
            try {
                n = Integer.parseInt(this.m_font_sizes.getModel().getElementAt(this.m_font_sizes.getModel().getSize() - 1));
                int n2 = Integer.parseInt(string2) + 1;
                if (n2 > n) {
                    n2 = n;
                }
                while (this.m_font_sizes.getSelectedIndex() == -1 && n2 <= n) {
                    this.m_font_sizes.setSelectedValue(String.valueOf(n2), true);
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_preview.setFont(WpTemplateUtils.str2font((String)string));
    }

    public void setSampleText(String string) {
        this.m_preview.setText(string);
    }

    public String fontString() {
        return WpTemplateUtils.font2str((Font)this.m_preview.getFont());
    }

    public int exec() {
        this.return_value = 1;
        this.setVisible(true);
        return this.return_value;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.return_value = actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equals("button.ok") ? 0 : 1;
        this.setVisible(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent != null && listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.m_font_names.getSelectedValue() == null || this.m_font_styles.getSelectedIndex() == -1 || this.m_font_sizes.getSelectedValue() == null) {
            return;
        }
        String string = String.valueOf(this.m_font_names.getSelectedValue()) + "-" + Txt.number2style(this.m_font_styles.getSelectedIndex()) + "-" + String.valueOf(this.m_font_sizes.getSelectedValue());
        this.m_font_name.setText(this.m_font_names.getSelectedValue());
        this.m_font_style.setText(this.m_font_styles.getSelectedValue());
        this.m_font_size.setText(this.m_font_sizes.getSelectedValue());
        this.m_preview.setFont(WpTemplateUtils.str2font((String)string));
        if (this.prop != null) {
            this.prop.setValue(this.fontString());
        }
    }
}

