/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.misc.treetable;

import de.wilke.misc.treetable.PropertyNode;
import de.wilke.misc.treetable.TreeTableModel;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    protected PropertyNode root;
    protected Vector<TreeModelListener> listeners = new Vector();

    public AbstractTreeTableModel(PropertyNode propertyNode) {
        this.root = propertyNode;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        System.out.println("AbstractTreeTableModel.valueForPathChanged()");
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        for (int i = 0; i < this.getChildCount(object); ++i) {
            if (!this.getChild(object, i).equals(object2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    protected void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Object.class;
    }
}

