/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.misc.treetable;

import de.wilke.misc.FontChooser;
import de.wilke.misc.treetable.ColorRenderer;
import de.wilke.misc.treetable.PropertyNode;
import de.wilke.misc.treetable.TreeTableModel;
import de.wilke.misc.treetable.TreeTableModelAdapter;
import de.wilke.misc.treetable.attributes.AbstractAttribute;
import de.wilke.misc.treetable.attributes.DashLineChooser;
import de.wilke.misc.treetable.attributes.IntegerProperty;
import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.templateeditor.WPTemplates;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private final WPTemplates app;
    protected TreeTableCellRenderer tree;
    private final NodeEditorList list_editor;
    private final NodeFontEditor font_editor;
    private final NodeImageEditor image_editor;
    private final NodeBooleanEditor boolean_editor;
    private final SpinnerEditor number_editor;
    private final DashLineEditor dashline_editor;
    private final ColorEditor color_editor;

    public JTreeTable(WPTemplates wPTemplates, TreeTableModel treeTableModel) {
        this.app = wPTemplates;
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultRenderer(AbstractAttribute.class, new AttributeNodeRenderer());
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.list_editor = new NodeEditorList();
        this.font_editor = new NodeFontEditor(new JLabel());
        this.image_editor = new NodeImageEditor(new JLabel());
        this.boolean_editor = new NodeBooleanEditor();
        this.number_editor = new SpinnerEditor();
        this.dashline_editor = new DashLineEditor(new JLabel());
        this.color_editor = new ColorEditor();
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new NodeEditorString());
        this.setShowGrid(true);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setIntercellSpacing(new Dimension(1, 1));
        this.tree.setRowHeight(25);
        this.setRowHeight(this.tree.getRowHeight());
        this.tree.setShowsRootHandles(true);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        if (n2 != 1) {
            return super.getCellEditor(n, n2);
        }
        TreeTableModelAdapter treeTableModelAdapter = (TreeTableModelAdapter)this.getModel();
        AbstractAttribute abstractAttribute = ((PropertyNode)treeTableModelAdapter.nodeForRow(n)).getProperty();
        if (!abstractAttribute.isEnabled()) {
            return null;
        }
        switch (abstractAttribute.getEditorType()) {
            case LIST: {
                this.list_editor.setEditor(abstractAttribute.getStringComboBox());
                return this.list_editor;
            }
            case FONT: {
                return this.font_editor;
            }
            case IMAGE: {
                return this.image_editor;
            }
            case BOOLEAN: {
                return this.boolean_editor;
            }
            case NUMBER: {
                IntegerProperty integerProperty = (IntegerProperty)abstractAttribute;
                this.number_editor.setMinMax(integerProperty.min(), integerProperty.max());
                return this.number_editor;
            }
            case DASHLINE: {
                return this.dashline_editor;
            }
            case COLOR: {
                this.color_editor.setEditor(abstractAttribute.getStringComboBox());
                return this.color_editor;
            }
        }
        return super.getCellEditor(n, n2);
    }

    public void expandAll() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    private class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = 1L;
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        for (int i = n; i <= n2; ++i) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(i) || (treePath = JTreeTable.this.tree.getPathForRow(i)) == null) continue;
                            this.addSelectionPath(treePath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    private class NodeEditorList
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private JComboBox<String> cbox;
        private String value;
        private String initial_value;

        private NodeEditorList() {
        }

        public void setEditor(JComboBox<String> jComboBox) {
            this.cbox = jComboBox;
            this.cbox.setFont(jComboBox.getFont().deriveFont(0));
            if (this.cbox.getActionListeners().length == 0) {
                this.cbox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        NodeEditorList.this.value = NodeEditorList.this.cbox.getSelectedItem().toString();
                        NodeEditorList.this.fireEditingStopped();
                    }
                });
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = ((AbstractAttribute)object).getValue().toString();
            this.cbox.setSelectedItem(string);
            this.initial_value = this.value = this.cbox.getSelectedItem().toString();
            return this.cbox;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                int n = 1;
                return ((MouseEvent)eventObject).getClickCount() >= n;
            }
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public void cancelCellEditing() {
            this.value = this.initial_value;
            super.cancelCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            this.value = this.cbox.getEditor().getItem().toString();
            return super.stopCellEditing();
        }
    }

    private class NodeBooleanEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 1L;
        private JCheckBox _check_box = new JCheckBox();

        public NodeBooleanEditor() {
            this._check_box.addActionListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            AbstractAttribute abstractAttribute = (AbstractAttribute)object;
            this._check_box.setSelected(WpUtils.str2bool((String)abstractAttribute.getValue()));
            return this._check_box;
        }

        @Override
        public Object getCellEditorValue() {
            return this._check_box.isSelected();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.stopCellEditing();
        }
    }

    private class AttributeNodeRenderer
    implements TableCellRenderer {
        private final JLabel _label = new JLabel();
        private final JCheckBox _check_box;
        private final ColorRenderer _color;
        private final Font bold_font;
        private final Font default_font;

        public AttributeNodeRenderer() {
            this._label.setFont(JTreeTable.this.getFont().deriveFont(0));
            this._label.setHorizontalAlignment(2);
            this._label.setOpaque(true);
            this._label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this._check_box = new JCheckBox();
            this._check_box.setFont(JTreeTable.this.getFont().deriveFont(0));
            this._check_box.setHorizontalAlignment(2);
            this._check_box.setOpaque(true);
            this._color = new ColorRenderer();
            this.default_font = this._label.getFont();
            this.bold_font = this.default_font.deriveFont(1);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent;
            AbstractAttribute abstractAttribute = (AbstractAttribute)object;
            if (abstractAttribute == null) {
                this._label.setText("Loading...");
                return this._label;
            }
            switch (abstractAttribute.getRendererType()) {
                case BOOLEAN: {
                    this._check_box.setSelected(WpUtils.str2bool((String)abstractAttribute.getValue()));
                    jComponent = this._check_box;
                    break;
                }
                case COLOR: {
                    this._color.setText(abstractAttribute.getFormattedValue());
                    this._color.setColor(WpTemplateUtils.str2color((String)abstractAttribute.getValue()));
                    jComponent = this._color;
                    break;
                }
                default: {
                    this._label.setText(abstractAttribute.getFormattedValue());
                    jComponent = this._label;
                }
            }
            jComponent.setEnabled(abstractAttribute.isEnabled());
            if (bl) {
                jComponent.setForeground(jTable.getSelectionForeground());
                jComponent.setBackground(jTable.getSelectionBackground());
            } else {
                jComponent.setForeground(jTable.getForeground());
                jComponent.setBackground(jTable.getBackground());
            }
            if (abstractAttribute.getChildren() != null) {
                this._label.setFont(this.bold_font);
            } else {
                this._label.setFont(this.default_font);
            }
            return jComponent;
        }
    }

    private class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private JComboBox<String> cbox;
        private String value;
        private String initial_value;

        private ColorEditor() {
        }

        public void setEditor(JComboBox<String> jComboBox) {
            this.cbox = jComboBox;
            this.cbox.setFont(jComboBox.getFont().deriveFont(0));
            this.cbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColorEditor.this.value = ColorEditor.this.cbox.getSelectedItem().toString();
                    ColorEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = ((AbstractAttribute)object).getValue().toString();
            this.cbox.setSelectedItem(string);
            if (this.cbox.getSelectedItem() != null) {
                this.initial_value = this.value = this.cbox.getSelectedItem().toString();
            }
            return this.cbox;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                int n = 1;
                return ((MouseEvent)eventObject).getClickCount() >= n;
            }
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public void cancelCellEditing() {
            this.value = this.initial_value;
            super.cancelCellEditing();
        }
    }

    private class DashLineEditor
    extends NodeEditorMore {
        private static final long serialVersionUID = 1L;

        public DashLineEditor(JComponent jComponent) {
            super(jComponent);
        }

        @Override
        protected void editCell(AbstractAttribute abstractAttribute) {
            int n = 1;
            try {
                n = Integer.parseInt(JTreeTable.this.app.template.getSelectedElement().getAttribute("attr.line_width"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            n = Math.max(1, n);
            DashLineChooser dashLineChooser = new DashLineChooser(JTreeTable.this.app.frame());
            dashLineChooser.setDashLine(abstractAttribute.getValue(), n);
            if (dashLineChooser.exec() == 0) {
                this.setCellEditorValue(dashLineChooser.dashLineString());
                this.fireEditingStopped();
            } else {
                this.fireEditingCanceled();
            }
        }
    }

    private class NodeImageEditor
    extends NodeEditorMore {
        private static final long serialVersionUID = 1L;

        public NodeImageEditor(JComponent jComponent) {
            super(jComponent);
        }

        @Override
        protected void editCell(AbstractAttribute abstractAttribute) {
            try {
                this.setCellEditorValue(JTreeTable.this.app.chooseImage());
                this.fireEditingStopped();
            }
            catch (Exception exception) {
                this.fireEditingCanceled();
            }
        }
    }

    private class NodeFontEditor
    extends NodeEditorMore {
        private static final long serialVersionUID = 1L;
        final FontChooser dlg;

        public NodeFontEditor(JComponent jComponent) {
            super(jComponent);
            this.dlg = new FontChooser(JTreeTable.this.app);
        }

        @Override
        protected void editCell(AbstractAttribute abstractAttribute) {
            String string = abstractAttribute.getValue();
            this.dlg.setProperty(abstractAttribute);
            this.dlg.setFontString(abstractAttribute.getValue());
            JTreeTable.this.app.setUndoEnabled(false);
            if (this.dlg.exec() == 0) {
                this.setCellEditorValue(this.dlg.fontString());
                this.fireEditingStopped();
                if (string != this.dlg.fontString()) {
                    abstractAttribute.setValue(string);
                    JTreeTable.this.app.setUndoEnabled(true);
                    abstractAttribute.setValue(this.dlg.fontString());
                }
            } else {
                abstractAttribute.setValue(string);
                this.fireEditingCanceled();
            }
            JTreeTable.this.app.setUndoEnabled(true);
            this.dlg.setProperty(null);
        }
    }

    private abstract class NodeEditorMore
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 1L;
        private JPanel panel = new JPanel();
        private JButton more = new JButton(" ... ");
        private AbstractAttribute prop;
        private JComponent _display = null;

        public NodeEditorMore(JComponent jComponent) {
            this.create_gui(jComponent);
        }

        private void create_gui(JComponent jComponent) {
            this._display = jComponent;
            this._display.setFont(this._display.getFont().deriveFont(0));
            this._display.setOpaque(false);
            this.more.addActionListener(this);
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this._display, "Center");
            this.panel.add((Component)this.more, "East");
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.prop = (AbstractAttribute)object;
            this.setCellEditorValue(this.prop.getValue());
            return this.panel;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                int n = 1;
                return ((MouseEvent)eventObject).getClickCount() >= n;
            }
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            if (this._display instanceof JLabel) {
                return ((JLabel)this._display).getText();
            }
            return null;
        }

        public void setCellEditorValue(Object object) {
            if (this._display instanceof JLabel) {
                ((JLabel)this._display).setText(object.toString());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.editCell(this.prop);
        }

        protected abstract void editCell(AbstractAttribute var1);
    }

    private class SpinnerEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        final JSpinner spinner = new JSpinner();
        final SpinnerNumberModel model = new SpinnerNumberModel();

        public SpinnerEditor() {
            this.spinner.setModel(this.model);
            this.spinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                }
            });
            JFormattedTextField jFormattedTextField = ((JSpinner.NumberEditor)this.spinner.getEditor()).getTextField();
            if (jFormattedTextField.getKeyListeners().length == 0) {
                jFormattedTextField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 10) {
                            try {
                                SpinnerEditor.this.spinner.commitEdit();
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        super.keyTyped(keyEvent);
                    }
                });
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            IntegerProperty integerProperty = (IntegerProperty)object;
            this.spinner.setValue(Integer.parseInt(integerProperty.getValue()));
            return this.spinner;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= 1;
            }
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.spinner.getValue();
        }

        public void setMinMax(int n, int n2) {
            this.model.setMinimum(Integer.valueOf(n));
            this.model.setMaximum(Integer.valueOf(n2));
        }
    }

    private class NodeEditorString
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private JTextField field = new JTextField();
        private String value;

        private NodeEditorString() {
        }

        @Override
        public boolean stopCellEditing() {
            this.value = this.field.getText();
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.field.setText(((AbstractAttribute)object).getValue());
            return this.field;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                int n = 1;
                return ((MouseEvent)eventObject).getClickCount() >= n;
            }
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    private class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;

        private TreeTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                for (int i = JTreeTable.this.getColumnCount() - 1; i >= 0; --i) {
                    if (JTreeTable.this.getColumnClass(i) != TreeTableModel.class) continue;
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    MouseEvent mouseEvent2 = new MouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)i, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(mouseEvent2);
                    break;
                }
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    private class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        protected int visibleRow;
        private String attribute_name;
        private final Font plain_font;
        private final Font bold_font;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
            this.plain_font = this.getFont().deriveFont(0);
            this.bold_font = this.plain_font.deriveFont(1);
            this.setRootVisible(false);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
                defaultTreeCellRenderer.setOpenIcon(null);
                defaultTreeCellRenderer.setClosedIcon(null);
                defaultTreeCellRenderer.setLeafIcon(null);
            }
        }

        @Override
        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setFont(this.bold_font);
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setFont(this.plain_font);
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            AbstractAttribute abstractAttribute = (AbstractAttribute)object;
            if (abstractAttribute == null) {
                return this;
            }
            if (abstractAttribute.getChildren() != null) {
                this.setFont(this.bold_font);
            }
            this.setEnabled(abstractAttribute.isEnabled());
            this.attribute_name = abstractAttribute.getName();
            this.visibleRow = n;
            return this;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return WPApp.tr((String)this.attribute_name);
        }
    }
}

