/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.misc.treetable;

import de.wilke.misc.treetable.attributes.AbstractAttribute;
import de.wilke.wizepanel.core.app.WPApp;
import java.util.LinkedList;

class PropertyNode {
    private PropertyNode parent;
    private AbstractAttribute prop;
    private LinkedList<PropertyNode> children;

    public PropertyNode(PropertyNode propertyNode, AbstractAttribute abstractAttribute) {
        this.parent = propertyNode;
        this.prop = abstractAttribute;
        AbstractAttribute[] abstractAttributeArray = abstractAttribute.getChildren();
        if (abstractAttributeArray != null) {
            for (int i = 0; i < abstractAttributeArray.length; ++i) {
                this.addChild(new PropertyNode(this, abstractAttributeArray[i]));
            }
        }
    }

    public String toString() {
        return WPApp.tr((String)this.prop.getName());
    }

    public AbstractAttribute getProperty() {
        return this.prop;
    }

    public PropertyNode getParent() {
        return this.parent;
    }

    protected Object[] getChildren() {
        if (this.children != null) {
            return this.children.toArray();
        }
        return null;
    }

    public int getChildIndex(PropertyNode propertyNode) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getProperty().getName().equals(propertyNode.getProperty().getName())) continue;
            return i;
        }
        return -1;
    }

    public PropertyNode getChild(String string) {
        if (this.prop.getName().equals(string)) {
            return this;
        }
        if (this.children == null) {
            return null;
        }
        for (PropertyNode propertyNode : this.children) {
            if (propertyNode.getChild(string) == null) continue;
            return propertyNode;
        }
        return null;
    }

    public void addChild(PropertyNode propertyNode) {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(propertyNode);
    }

    public void killAllChildren() {
        if (this.children != null) {
            this.children.clear();
            this.children = null;
        }
    }
}

