/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.misc.treetable.attributes;

import de.wilke.misc.treetable.attributes.AbstractAttribute;

public class IntegerProperty
extends AbstractAttribute {
    private int value;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    public IntegerProperty(String string, int n) {
        super(string);
        this.value = n;
    }

    public IntegerProperty(String string, int n, int n2, int n3) {
        super(string);
        this.value = n;
        this.min = n2;
        this.max = n3;
    }

    public IntegerProperty(AbstractAttribute abstractAttribute, String string, int n) {
        super(abstractAttribute, string);
        this.value = n;
    }

    public IntegerProperty(AbstractAttribute abstractAttribute, String string, int n, int n2, int n3) {
        super(abstractAttribute, string);
        this.value = n;
        this.min = n2;
        this.max = n3;
    }

    @Override
    public String getValue() {
        return Integer.toString(this.value);
    }

    @Override
    public void setInternalValue(String string) {
        int n = Integer.parseInt(string);
        if (n >= this.min && n <= this.max) {
            this.value = n;
        }
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public AbstractAttribute.EditorType getEditorType() {
        return AbstractAttribute.EditorType.NUMBER;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }
}

