/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor.canvas;

import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.templateeditor.AppSettings;
import de.wilke.wizepanel.templateeditor.ToolListener;
import de.wilke.wizepanel.templateeditor.Txt;
import de.wilke.wizepanel.templateeditor.WPTemplates;
import de.wilke.wizepanel.templateeditor.canvas.Label;
import de.wilke.wizepanel.templateeditor.undo.MoveResizeCommand;
import de.wilke.wizepanel.templates.MouseHandle;
import de.wilke.wizepanel.templates.Template;
import de.wilke.wizepanel.templates.TemplateListener;
import de.wilke.wizepanel.templates.elements.TemplateElement;
import de.wilke.wizepanel.templates.elements.TemplateElementEllipse;
import de.wilke.wizepanel.templates.elements.TemplateElementGraphics;
import de.wilke.wizepanel.templates.elements.TemplateElementLine;
import de.wilke.wizepanel.templates.elements.TemplateElementQR;
import de.wilke.wizepanel.templates.elements.TemplateElementRect;
import de.wilke.wizepanel.templates.elements.TemplateElementText;
import de.wilke.wizepanel.templates.elements.TemplateElementTimetable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;

public class CanvasPanel
extends JComponent
implements TemplateListener,
ToolListener {
    private static final long serialVersionUID = 1L;
    private final WPTemplates m_app;
    private final Template m_tpl;
    private Hashtable<String, TemplateElement> m_new_elements;
    public TemplateElement m_new_elem = null;
    private final Map<TemplateElement, Label> m_labels = new HashMap<TemplateElement, Label>();
    private TemplateElement m_selection_rect;
    private boolean m_grid = true;
    private int m_grid_size = 20;
    private Color m_grid_color = Color.LIGHT_GRAY;
    private Color m_canvas_color = Color.WHITE;
    private float m_scale = 1.0f;
    private boolean m_show_layers = false;
    private boolean m_show_placeholders = false;
    private boolean m_show_helpers = false;
    private boolean m_crop_outside = false;
    private TemplateElement m_sel_elem;
    private KeyEvent m_last_key = null;
    private MouseHandler mouse_handler;
    private final Font m_sys_font_bold = new Font("Monospaced", 0, 12);
    private Color m_sys_bg = Color.YELLOW;
    private Color m_sys_fg = Color.BLUE;
    private Color m_blending_color = Color.RED;
    private boolean m_control_down = false;
    private final TexturePaint chess_paint;

    public CanvasPanel(WPTemplates wPTemplates, Template template) {
        this.m_app = wPTemplates;
        this.m_tpl = template;
        template.addTemplateListener((TemplateListener)this);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.m_selection_rect = new TemplateElementText(this.m_tpl);
        this.m_selection_rect.setHelpBorder(true);
        BufferedImage bufferedImage = WPApp.getFactoryImage((String)"chessboard.png");
        this.chess_paint = new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        this.m_new_elements = new Hashtable();
        this.m_new_elements.put("tool.rect", (TemplateElement)new TemplateElementRect(this.m_tpl));
        this.m_new_elements.put("tool.qr", (TemplateElement)new TemplateElementQR(this.m_tpl));
        this.m_new_elements.put("tool.line", (TemplateElement)new TemplateElementLine(this.m_tpl));
        this.m_new_elements.put("tool.ellipse", (TemplateElement)new TemplateElementEllipse(this.m_tpl));
        TemplateElementText templateElementText = new TemplateElementText(this.m_tpl);
        templateElementText.setAttribute("attr.font", WpTemplateUtils.font2str((Font)new Font("Serif", 0, 12)));
        templateElementText.setAttribute("attr.text", WPApp.tr((String)"attr.text"));
        templateElementText.setHelpBorder(true);
        this.m_new_elements.put("tool.text", (TemplateElement)templateElementText);
        this.m_new_elements.put("tool.graphics", (TemplateElement)new TemplateElementGraphics(this.m_tpl));
        TemplateElementTimetable templateElementTimetable = new TemplateElementTimetable(this.m_tpl);
        templateElementTimetable.setAttribute("attr.time.font", WpTemplateUtils.font2str((Font)new Font("Arial", 1, 20)));
        templateElementTimetable.setAttribute("attr.event.font", WpTemplateUtils.font2str((Font)new Font("Arial", 0, 18)));
        templateElementTimetable.setAttribute("attr.events_data", WPApp.tr((String)"attr.event_json"));
        templateElementTimetable.setHelpBorder(false);
        this.m_new_elements.put("tool.timetable", (TemplateElement)templateElementTimetable);
        this.mouse_handler = new MouseHandler();
        this.addMouseListener(this.mouse_handler);
        this.addMouseMotionListener(this.mouse_handler);
        this.addKeyListener(new KeyHandler());
    }

    public void showLayers(boolean bl) {
        this.m_show_layers = bl;
        this.repaint();
    }

    public void showPlaceholders(boolean bl) {
        this.m_show_placeholders = bl;
        this.repaint();
    }

    public void showHelpers(boolean bl) {
        this.m_show_helpers = bl;
        this.repaint();
    }

    public void cropOutside(boolean bl) {
        this.m_crop_outside = bl;
        this.repaint();
    }

    public void setScale(float f) {
        this.m_scale = f;
        int n = (int)((float)(this.m_tpl.getWidth() + 200) * this.m_scale);
        int n2 = (int)((float)(this.m_tpl.getHeight() + 200) * this.m_scale);
        this.setPreferredSize(new Dimension(n, n2));
        this.setSize(this.getPreferredSize());
        this.revalidate();
        this.repaint();
    }

    public void setGrid(boolean bl) {
        this.m_grid = bl;
        this.repaint();
    }

    public void setGridSize(int n) {
        this.m_grid_size = n;
        this.repaint();
    }

    public int gridSize() {
        return this.m_grid_size;
    }

    private boolean snapToGrid() {
        return this.m_control_down || this.m_app.snapToGrid();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        Object object;
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(100.0f * this.m_scale, 100.0f * this.m_scale);
        int n3 = (int)((float)this.m_tpl.getWidth() * this.m_scale);
        int n4 = (int)((float)this.m_tpl.getHeight() * this.m_scale);
        if (this.m_tpl.backgroundColor() == null) {
            if (this.chess_paint != null) {
                graphics2D.setPaint(this.chess_paint);
                graphics2D.fillRect(0, 0, n3, n4);
            }
        } else {
            graphics2D.setColor(this.m_tpl.backgroundColor());
            graphics2D.fillRect(0, 0, n3, n4);
        }
        graphics2D.setColor(this.m_canvas_color);
        if (this.m_grid) {
            int n5;
            int n6;
            graphics2D.setColor(this.m_grid_color);
            for (n5 = n6 = (int)((float)this.m_grid_size * this.m_scale); n5 < n3; n5 += n6) {
                graphics2D.drawLine(n5, 0, n5, n4);
            }
            for (n5 = n6; n5 < n4; n5 += n6) {
                graphics2D.drawLine(0, n5, n3, n5);
            }
        }
        BufferedImage bufferedImage = new BufferedImage((int)((float)this.getWidth() / this.m_scale), (int)((float)this.getHeight() / this.m_scale), 2);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.translate(100, 100);
        for (int i = 0; i < this.m_tpl.elements(); ++i) {
            this.m_tpl.getElementAt(i).draw(graphics2D2, true, this.m_show_helpers);
        }
        if (this.m_crop_outside) {
            Composite composite = graphics2D2.getComposite();
            graphics2D2.setComposite(AlphaComposite.getInstance(3, 0.8f));
            graphics2D2.setColor(this.m_blending_color);
            graphics2D2.fill(new Rectangle2D.Float(-100.0f, -100.0f, 100.0f, this.m_tpl.getHeight() + 200));
            graphics2D2.fill(new Rectangle2D.Float(this.m_tpl.getWidth(), -100.0f, 100.0f, this.m_tpl.getHeight() + 200));
            graphics2D2.fill(new Rectangle2D.Float(0.0f, -100.0f, this.m_tpl.getWidth(), 100.0f));
            graphics2D2.fill(new Rectangle2D.Float(0.0f, this.m_tpl.getHeight(), this.m_tpl.getWidth(), 100.0f));
            graphics2D2.setComposite(composite);
        }
        if (this.mouse_handler.isCreating() && this.m_new_elem != null) {
            this.m_new_elem.draw(graphics2D2, true, true);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.scale(this.m_scale, this.m_scale);
        graphics2D.drawImage(bufferedImage, null, -100, -100);
        graphics2D.scale(1.0f / this.m_scale, 1.0f / this.m_scale);
        LinkedList linkedList = this.m_tpl.getSelectedElements();
        graphics2D.setStroke(new BasicStroke());
        for (int i = 0; i < linkedList.size(); ++i) {
            ((TemplateElement)linkedList.get(i)).drawHandles(graphics2D, this.m_scale, linkedList.get(i) == this.m_tpl.getReferenceElement() ? AppSettings.referenceHandleColor() : AppSettings.handleColor());
        }
        graphics2D.setFont(this.m_sys_font_bold);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.m_labels.clear();
        if (this.m_show_layers) {
            for (n2 = 0; n2 < this.m_tpl.elements(); ++n2) {
                TemplateElement object22 = this.m_tpl.getElementAt(n2);
                object = object22.getAnchorHandle();
                int n5 = this.template2canvas(object.getX()) - 10;
                n = this.template2canvas(object.getY()) - 10;
                Label label = new Label(object22, Integer.toString(object22.layer()), this.m_sys_bg, this.m_sys_fg, n5, n, fontMetrics);
                this.m_labels.put(object22, label);
            }
        }
        if (this.m_show_placeholders) {
            for (n2 = 0; n2 < this.m_tpl.elements(); ++n2) {
                TemplateElement templateElement = this.m_tpl.getElementAt(n2);
                object = templateElement.getPlaceholderName();
                if (object == null || ((String)object).length() == 0) continue;
                if (!this.m_labels.containsKey(templateElement)) {
                    MouseHandle mouseHandle = templateElement.getAnchorHandle();
                    n = this.template2canvas(mouseHandle.getX()) - 10;
                    int n6 = this.template2canvas(mouseHandle.getY()) - 10;
                    Label label = new Label(templateElement, (String)object, this.m_sys_bg, this.m_sys_fg, n, n6, fontMetrics);
                    this.m_labels.put(templateElement, label);
                    continue;
                }
                this.m_labels.get(templateElement).addText((String)object, fontMetrics);
            }
        }
        for (Label label : this.m_labels.values()) {
            label.draw(graphics2D, this.m_tpl.isElementSelected(label.getElement()));
        }
        if (this.mouse_handler.isSelecting()) {
            this.m_selection_rect.draw(graphics2D, true, false);
        }
    }

    public int template2canvas(int n) {
        return (int)((float)n * this.m_scale);
    }

    private void set_selected_pos(int n, int n2) {
        if (this.snapToGrid()) {
            n = Math.round(n / this.m_grid_size) * this.m_grid_size;
            n2 = Math.round(n2 / this.m_grid_size) * this.m_grid_size;
        }
        MouseHandle mouseHandle = this.m_tpl.getReferenceElement().getAnchorHandle();
        int n3 = n - mouseHandle.getX();
        int n4 = n2 - mouseHandle.getY();
        if (n3 == 0 && n4 == 0) {
            return;
        }
        for (TemplateElement templateElement : this.m_tpl.getSelectedElements()) {
            MouseHandle mouseHandle2 = templateElement.getAnchorHandle();
            int n5 = mouseHandle2.getX() + n3;
            int n6 = mouseHandle2.getY() + n4;
            templateElement.setHandle(mouseHandle2, n5, n6, true);
        }
    }

    public Point getMouseClickPosition() {
        return this.mouse_handler.getMouseClickPosition();
    }

    private void create_new_element(TemplateElement templateElement) {
        TemplateElement templateElement2 = this.m_tpl.cloneElement(templateElement);
        boolean bl = false;
        if (templateElement instanceof TemplateElementGraphics) {
            bl = true;
            try {
                templateElement2.setAttribute("attr.image_name", this.m_app.chooseImage());
                templateElement2.setAttribute("attr.fit_to_rect", WpUtils.bool2str((boolean)true));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, WPTemplates.tr((String)"err_img_open"), WPTemplates.tr((String)"Error"), 0);
            }
        }
        if (templateElement2.isValidSize()) {
            templateElement2.normalize();
            templateElement2.rebuild();
            this.m_tpl.addElement(templateElement2, true, true, true);
        }
        this.m_app.setSelectTool(bl);
    }

    @Override
    public void toolChanged(String string) {
        this.m_new_elem = this.m_new_elements.containsKey(string) ? this.m_new_elements.get(string) : null;
        if (this.m_app.isSelectTool()) {
            if (this.m_app.isCopyFormatTool()) {
                this.setCursor(Txt.getCursorCopyFormat());
            } else {
                this.setCursor(Txt.cursor_select);
            }
        } else {
            this.setCursor(Txt.cursor_draw);
        }
    }

    public TemplateElement getNewElement() {
        return this.m_new_elem;
    }

    public void templateModified(Template template, TemplateListener.TemplateEvent templateEvent) {
        switch (templateEvent) {
            case NEW_SELECTED: {
                this.m_sel_elem = template.getSelectedElement();
                break;
            }
            case NEW_TEMPLATE: {
                this.m_sel_elem = null;
                int n = template.getWidth() + 200;
                int n2 = template.getHeight() + 200;
                this.setPreferredSize(new Dimension(n, n2));
                this.revalidate();
                break;
            }
        }
        this.repaint();
    }

    public Point convertTemplate2Canvas(Point point) {
        return new Point((int)((float)(point.x + 100) * this.m_scale), (int)((float)(point.y + 100) * this.m_scale));
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private int netS = 6;
        private Rectangle net = new Rectangle(this.netS, this.netS);
        private MouseHandle selectedHandle = null;
        private MouseAction current_action = MouseAction.NONE;
        private Point dragging_from = new Point();
        private Point dragging_offset = new Point();
        private Point m_last_click_pos = new Point();
        private final JPopupMenu m_element_popup = this.create_popup_element();
        private JCheckBoxMenuItem m_popup_lock;
        private JMenu m_alignment_menu;
        private JMenu m_layer_menu;
        private final JPopupMenu m_template_popup = this.create_popup_template();
        private JMenuItem m_edit_paste;

        private JPopupMenu create_popup_element() {
            this.m_alignment_menu = CanvasPanel.this.m_app.createAlignmentMenu();
            this.m_layer_menu = CanvasPanel.this.m_app.createLayerMenu();
            JMenuItem jMenuItem = new JMenuItem(WPApp.tr((String)"edit.cut"));
            jMenuItem.setActionCommand("edit.cut");
            jMenuItem.addActionListener(CanvasPanel.this.m_app);
            jMenuItem.setIcon(WPApp.getFactoryIcon((String)"small/edit-cut.png"));
            JMenuItem jMenuItem2 = new JMenuItem(WPApp.tr((String)"edit.copy"));
            jMenuItem2.setActionCommand("edit.copy");
            jMenuItem2.addActionListener(CanvasPanel.this.m_app);
            jMenuItem2.setIcon(WPApp.getFactoryIcon((String)"small/edit-copy.png"));
            JMenuItem jMenuItem3 = new JMenuItem(WPApp.tr((String)"edit.delete"));
            jMenuItem3.setActionCommand("edit.delete");
            jMenuItem3.addActionListener(CanvasPanel.this.m_app);
            jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            jMenuItem3.setIcon(WPApp.getFactoryIcon((String)"small/edit-delete.png"));
            this.m_popup_lock = new JCheckBoxMenuItem(WPApp.tr((String)"edit.lock-all"));
            this.m_popup_lock.setActionCommand("edit.lock-all");
            this.m_popup_lock.addActionListener(CanvasPanel.this.m_app);
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.m_alignment_menu);
            jPopupMenu.add(this.m_layer_menu);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.add(jMenuItem2);
            jPopupMenu.addSeparator();
            jPopupMenu.add(jMenuItem3);
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.m_popup_lock);
            return jPopupMenu;
        }

        private JPopupMenu create_popup_template() {
            this.m_edit_paste = new JMenuItem(WPApp.tr((String)"edit.paste"));
            this.m_edit_paste.setActionCommand("edit.paste");
            this.m_edit_paste.addActionListener(CanvasPanel.this.m_app);
            this.m_edit_paste.setIcon(WPApp.getFactoryIcon((String)"small/edit-paste.png"));
            JMenuItem jMenuItem = new JMenuItem(WPApp.tr((String)"file.properties"));
            jMenuItem.setActionCommand("file.properties");
            jMenuItem.addActionListener(CanvasPanel.this.m_app);
            jMenuItem.setIcon(WPApp.getFactoryIcon((String)"small/document-properties.png"));
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.m_edit_paste);
            jPopupMenu.addSeparator();
            jPopupMenu.add(jMenuItem);
            return jPopupMenu;
        }

        public boolean isCreating() {
            return this.current_action == MouseAction.DRAWING_NEW;
        }

        public boolean isSelecting() {
            return this.current_action == MouseAction.SELECTING;
        }

        public Point getMouseClickPosition() {
            return this.m_last_click_pos;
        }

        private Point convertCanvas2Template(Point point) {
            return new Point((int)((float)point.x / CanvasPanel.this.m_scale - 100.0f), (int)((float)point.y / CanvasPanel.this.m_scale - 100.0f));
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = this.convertCanvas2Template(mouseEvent.getPoint());
            CanvasPanel.this.m_control_down = mouseEvent.isControlDown();
            CanvasPanel.this.m_app.showMousePos(point.x, point.y);
            if (!CanvasPanel.this.m_app.isSelectTool()) {
                return;
            }
            if (CanvasPanel.this.m_sel_elem != null) {
                this.update_mouse_handle(point);
            }
            if (!CanvasPanel.this.m_app.isCopyFormatTool()) {
                if (this.selectedHandle != null) {
                    CanvasPanel.this.setCursor(this.selectedHandle.cursor());
                    return;
                }
                this.net.setFrameFromCenter(point.getX(), point.getY(), point.getX() + (double)(this.netS / 2), point.getY() + (double)(this.netS / 2));
                for (TemplateElement templateElement : CanvasPanel.this.m_tpl.getSelectedElements()) {
                    if (!templateElement.intersects(this.net)) continue;
                    CanvasPanel.this.setCursor(Txt.cursor_move);
                    return;
                }
                int n = CanvasPanel.this.template2canvas(point.x);
                int n2 = CanvasPanel.this.template2canvas(point.y);
                for (Label label : CanvasPanel.this.m_labels.values()) {
                    if (!label.contains(n, n2)) continue;
                    CanvasPanel.this.setCursor(Txt.cursor_move);
                    return;
                }
            }
            if (CanvasPanel.this.m_app.isCopyFormatTool()) {
                CanvasPanel.this.setCursor(Txt.getCursorCopyFormat());
            } else {
                CanvasPanel.this.setCursor(Txt.cursor_select);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point = this.convertCanvas2Template(mouseEvent.getPoint());
            CanvasPanel.this.m_control_down = mouseEvent.isControlDown();
            CanvasPanel.this.grabFocus();
            if (mouseEvent.getButton() == 2) {
                this.current_action = MouseAction.CANVAS_DRAGGING;
                this.dragging_from.setLocation(mouseEvent.getPoint());
                return;
            }
            if (mouseEvent.getClickCount() > 1 && mouseEvent.getButton() == 1) {
                CanvasPanel.this.m_app.do_edit_props();
                return;
            }
            if (CanvasPanel.this.m_app.isSelectTool()) {
                TemplateElement templateElement;
                if (this.selectedHandle == null) {
                    templateElement = this.find_element_by_label(CanvasPanel.this.template2canvas(point.x), CanvasPanel.this.template2canvas(point.y));
                    if (templateElement == null) {
                        this.net.setFrameFromCenter(point.getX(), point.getY(), point.getX() + (double)(this.netS / 2), point.getY() + (double)(this.netS / 2));
                        templateElement = CanvasPanel.this.m_tpl.getElement(this.net);
                    }
                    if (mouseEvent.isShiftDown()) {
                        if (templateElement != null) {
                            CanvasPanel.this.m_tpl.toggleSelection(templateElement);
                        }
                    } else if (CanvasPanel.this.m_tpl.isElementSelected(templateElement)) {
                        CanvasPanel.this.m_tpl.setReferenceElement(templateElement);
                    } else {
                        CanvasPanel.this.m_tpl.selectElement(templateElement);
                    }
                    if (CanvasPanel.this.m_sel_elem != null) {
                        this.update_mouse_handle(point);
                    }
                    if (CanvasPanel.this.m_app.isCopyFormatTool()) {
                        return;
                    }
                }
                if (mouseEvent.getButton() == 1) {
                    if (this.selectedHandle != null) {
                        this.dragging_offset.x = point.x - this.selectedHandle.getX();
                        this.dragging_offset.y = point.y - this.selectedHandle.getY();
                        this.dragging_from.setLocation(this.selectedHandle.getPosition());
                        this.current_action = MouseAction.MOVE_RESIZE_BY_HANDLE;
                        CanvasPanel.this.setCursor(this.selectedHandle.cursor());
                    } else {
                        if (!CanvasPanel.this.m_tpl.getSelectedElements().isEmpty()) {
                            if (CanvasPanel.this.m_tpl.allSelectedMoveable()) {
                                templateElement = CanvasPanel.this.m_tpl.getReferenceElement().getAnchorHandle();
                                this.dragging_offset.x = point.x - templateElement.getX();
                                this.dragging_offset.y = point.y - templateElement.getY();
                                this.dragging_from.setLocation(point);
                                this.current_action = MouseAction.MOVING_SELECTED;
                                CanvasPanel.this.setCursor(Txt.cursor_move);
                            }
                            return;
                        }
                        CanvasPanel.this.m_selection_rect.setPosition((int)((float)point.x * CanvasPanel.this.m_scale), (int)((float)point.y * CanvasPanel.this.m_scale));
                        this.current_action = MouseAction.SELECTING;
                    }
                }
            } else if (CanvasPanel.this.m_new_elem != null) {
                this.current_action = MouseAction.DRAWING_NEW;
                int n = point.x;
                int n2 = point.y;
                if (CanvasPanel.this.snapToGrid()) {
                    n = Math.round((float)n / (float)CanvasPanel.this.m_grid_size) * CanvasPanel.this.m_grid_size;
                    n2 = Math.round((float)n2 / (float)CanvasPanel.this.m_grid_size) * CanvasPanel.this.m_grid_size;
                }
                CanvasPanel.this.m_new_elem.setPosition(n, n2);
                CanvasPanel.this.m_new_elem.setSize(0, 0);
                return;
            }
            if (mouseEvent.getButton() == 3) {
                int n = CanvasPanel.this.m_tpl.getSelectedElements().size();
                if (n == 0) {
                    this.m_last_click_pos.setLocation(point);
                    this.m_edit_paste.setEnabled(CanvasPanel.this.m_app.canPaste());
                    this.m_template_popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    if (n == 1) {
                        this.m_popup_lock.setSelected(!CanvasPanel.this.m_tpl.getSelectedElement().isMoveable());
                    }
                    this.m_popup_lock.setEnabled(n == 1);
                    this.m_alignment_menu.setEnabled(n != 1);
                    this.m_element_popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                return;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = this.convertCanvas2Template(mouseEvent.getPoint());
            CanvasPanel.this.m_app.showMousePos(point.x, point.y);
            CanvasPanel.this.m_control_down = mouseEvent.isControlDown();
            switch (this.current_action) {
                case MOVE_RESIZE_BY_HANDLE: {
                    int n = point.x - this.dragging_offset.x;
                    int n2 = point.y - this.dragging_offset.y;
                    if (CanvasPanel.this.snapToGrid()) {
                        n = Math.round((float)n / (float)CanvasPanel.this.m_grid_size) * CanvasPanel.this.m_grid_size;
                        n2 = Math.round((float)n2 / (float)CanvasPanel.this.m_grid_size) * CanvasPanel.this.m_grid_size;
                    }
                    CanvasPanel.this.m_sel_elem.setHandle(this.selectedHandle, n, n2, false);
                    CanvasPanel.this.repaint();
                    break;
                }
                case MOVING_SELECTED: {
                    CanvasPanel.this.set_selected_pos(point.x - this.dragging_offset.x, point.y - this.dragging_offset.y);
                    CanvasPanel.this.repaint();
                    break;
                }
                case DRAWING_NEW: {
                    String string;
                    int n = point.x - CanvasPanel.this.m_new_elem.getX();
                    int n3 = point.y - CanvasPanel.this.m_new_elem.getY();
                    if (CanvasPanel.this.snapToGrid()) {
                        n = Math.round((float)n / (float)CanvasPanel.this.m_grid_size) * CanvasPanel.this.m_grid_size;
                        n3 = Math.round((float)n3 / (float)CanvasPanel.this.m_grid_size) * CanvasPanel.this.m_grid_size;
                    }
                    if (CanvasPanel.this.m_new_elem.type().equals("tool.line")) {
                        int n4 = (int)Math.sqrt(n * n + n3 * n3);
                        string = WPApp.tr((String)"new_length", (String[])new String[]{WPApp.tr((String)CanvasPanel.this.m_new_elem.type()), Integer.toString(n4)});
                    } else {
                        string = WPApp.tr((String)"new_size", (String[])new String[]{WPApp.tr((String)CanvasPanel.this.m_new_elem.type()), Integer.toString(Math.abs(n)), Integer.toString(Math.abs(n3))});
                    }
                    CanvasPanel.this.m_app.showStatusMessage(string, -1);
                    CanvasPanel.this.m_new_elem.setSize(n, n3);
                    CanvasPanel.this.m_new_elem.rebuild();
                    CanvasPanel.this.repaint();
                    break;
                }
                case CANVAS_DRAGGING: {
                    int n = -((int)((double)mouseEvent.getX() - this.dragging_from.getX()));
                    int n5 = -((int)((double)mouseEvent.getY() - this.dragging_from.getY()));
                    this.dragging_from = mouseEvent.getPoint();
                    this.dragging_from.x += n;
                    this.dragging_from.y += n5;
                    Rectangle rectangle = CanvasPanel.this.getVisibleRect();
                    rectangle.x += n;
                    rectangle.y += n5;
                    CanvasPanel.this.scrollRectToVisible(rectangle);
                    break;
                }
                case SELECTING: {
                    int n = (int)((float)mouseEvent.getX() - 100.0f * CanvasPanel.this.m_scale) - CanvasPanel.this.m_selection_rect.getX();
                    int n6 = (int)((float)mouseEvent.getY() - 100.0f * CanvasPanel.this.m_scale) - CanvasPanel.this.m_selection_rect.getY();
                    CanvasPanel.this.m_selection_rect.setSize(n, n6);
                    CanvasPanel.this.repaint();
                    break;
                }
            }
            CanvasPanel.this.scrollRectToVisible(new Rectangle(mouseEvent.getX() - 10, mouseEvent.getY() - 10, 20, 20));
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Point point = this.convertCanvas2Template(mouseEvent.getPoint());
            CanvasPanel.this.m_control_down = mouseEvent.isControlDown();
            switch (this.current_action) {
                case MOVE_RESIZE_BY_HANDLE: {
                    if (!(this.dragging_from.distance(this.selectedHandle.getPosition()) >= 1.0)) break;
                    CanvasPanel.this.m_app.elementMovedResized(CanvasPanel.this.m_sel_elem, this.selectedHandle, this.dragging_from.x, this.dragging_from.y, false);
                    CanvasPanel.this.m_sel_elem.normalize();
                    break;
                }
                case MOVING_SELECTED: {
                    if (!(this.dragging_from.distance(point) >= 1.0)) break;
                    MouseHandle mouseHandle = CanvasPanel.this.m_tpl.getReferenceElement().getAnchorHandle();
                    int n = mouseHandle.getX() - (this.dragging_from.x - this.dragging_offset.x);
                    int n2 = mouseHandle.getY() - (this.dragging_from.y - this.dragging_offset.y);
                    MoveResizeCommand moveResizeCommand = new MoveResizeCommand();
                    for (TemplateElement templateElement : CanvasPanel.this.m_tpl.getSelectedElements()) {
                        MouseHandle mouseHandle2 = templateElement.getAnchorHandle();
                        int n3 = mouseHandle2.getX() - n;
                        int n4 = mouseHandle2.getY() - n2;
                        moveResizeCommand.addChild(new MoveResizeCommand(templateElement, mouseHandle2, n3, n4, true));
                        templateElement.normalize();
                    }
                    CanvasPanel.this.m_app.elementsMoved(moveResizeCommand, false);
                    break;
                }
                case DRAWING_NEW: {
                    CanvasPanel.this.create_new_element(CanvasPanel.this.m_new_elem);
                    break;
                }
                case SELECTING: {
                    int n = CanvasPanel.this.m_selection_rect.getX();
                    int n5 = CanvasPanel.this.m_selection_rect.getY();
                    int n6 = CanvasPanel.this.m_selection_rect.getWidth();
                    int n7 = CanvasPanel.this.m_selection_rect.getHeight();
                    if (n6 < 0) {
                        n += n6;
                        n6 = -n6;
                    }
                    if (n7 < 0) {
                        n5 += n7;
                        n7 = -n7;
                    }
                    n = (int)((float)n / CanvasPanel.this.m_scale);
                    n5 = (int)((float)n5 / CanvasPanel.this.m_scale);
                    n6 = (int)((float)n6 / CanvasPanel.this.m_scale);
                    n7 = (int)((float)n7 / CanvasPanel.this.m_scale);
                    if (n6 == 0 || n7 == 0) {
                        this.net.setFrameFromCenter(point.getX(), point.getY(), point.getX() + (double)(this.netS / 2), point.getY() + (double)(this.netS / 2));
                    } else {
                        this.net.setBounds(n, n5, n6, n7);
                    }
                    LinkedList linkedList = CanvasPanel.this.m_tpl.getElements(this.net);
                    for (TemplateElement templateElement : linkedList) {
                        CanvasPanel.this.m_tpl.toggleSelection(templateElement);
                    }
                    CanvasPanel.this.m_selection_rect.setSize(0, 0);
                    CanvasPanel.this.repaint();
                    break;
                }
            }
            CanvasPanel.this.m_app.showStatusMessage(null, -1);
            this.selectedHandle = null;
            this.current_action = MouseAction.NONE;
        }

        public void cancel() {
            System.err.println("cancel() " + this.current_action);
            switch (this.current_action) {
                case MOVING_SELECTED: {
                    CanvasPanel.this.set_selected_pos(this.dragging_from.x - this.dragging_offset.x, this.dragging_from.y - this.dragging_offset.y);
                    break;
                }
                case MOVE_RESIZE_BY_HANDLE: {
                    CanvasPanel.this.m_sel_elem.setHandle(this.selectedHandle, this.dragging_from.x, this.dragging_from.y, false);
                    break;
                }
                case DRAWING_NEW: {
                    CanvasPanel.this.m_app.setSelectTool(true);
                    break;
                }
            }
            this.selectedHandle = null;
            CanvasPanel.this.m_new_elem = null;
            this.current_action = MouseAction.NONE;
            if (CanvasPanel.this.m_app.isCopyFormatTool()) {
                CanvasPanel.this.setCursor(Txt.getCursorCopyFormat());
            } else {
                CanvasPanel.this.setCursor(Txt.cursor_select);
            }
            CanvasPanel.this.repaint();
        }

        private void update_mouse_handle(Point point) {
            this.selectedHandle = null;
            if (CanvasPanel.this.m_sel_elem == null || !CanvasPanel.this.m_sel_elem.isMoveable()) {
                return;
            }
            this.selectedHandle = CanvasPanel.this.m_sel_elem.findHandle(point);
        }

        private TemplateElement find_element_by_label(int n, int n2) {
            for (Label label : CanvasPanel.this.m_labels.values()) {
                if (!label.contains(n, n2)) continue;
                return label.getElement();
            }
            return null;
        }
    }

    private static enum MouseAction {
        NONE,
        SELECTING,
        MOVE_RESIZE_BY_HANDLE,
        MOVING_SELECTED,
        DRAWING_NEW,
        CANVAS_DRAGGING;

    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 27: {
                    CanvasPanel.this.mouse_handler.cancel();
                    return;
                }
                case 9: {
                    CanvasPanel.this.m_tpl.selectNextElement();
                    return;
                }
                case 49: {
                    CanvasPanel.this.m_app.do_view_zoom_1();
                    return;
                }
                case 521: {
                    CanvasPanel.this.m_app.doZoomIn();
                    return;
                }
                case 45: {
                    CanvasPanel.this.m_app.doZoomOut();
                    return;
                }
            }
            if (n == 39 || n == 37 || n == 38 || n == 40) {
                keyEvent.consume();
                if (CanvasPanel.this.m_tpl.getSelectedElements().isEmpty() || !CanvasPanel.this.m_tpl.allSelectedMoveable()) {
                    return;
                }
                int n2 = 0;
                int n3 = 0;
                switch (keyEvent.getKeyCode()) {
                    case 39: {
                        n2 = 1;
                        break;
                    }
                    case 37: {
                        n2 = -1;
                        break;
                    }
                    case 38: {
                        n3 = -1;
                        break;
                    }
                    case 40: {
                        n3 = 1;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                MoveResizeCommand moveResizeCommand = new MoveResizeCommand();
                for (TemplateElement templateElement : CanvasPanel.this.m_tpl.getSelectedElements()) {
                    MouseHandle mouseHandle = templateElement.getAnchorHandle();
                    templateElement.setHandle(mouseHandle, mouseHandle.getX() + n2, mouseHandle.getY() + n3, true);
                    moveResizeCommand.addChild(new MoveResizeCommand(templateElement, mouseHandle, mouseHandle.getX() - n2, mouseHandle.getY() - n3, true));
                }
                CanvasPanel.this.m_app.elementsMoved(moveResizeCommand, CanvasPanel.this.m_last_key != null && keyEvent.getKeyCode() == CanvasPanel.this.m_last_key.getKeyCode());
                CanvasPanel.this.m_last_key = keyEvent;
                CanvasPanel.this.repaint();
            }
        }
    }
}

