/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor.canvas;

import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.templateeditor.canvas.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;

public class CanvasPreviewPanel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private BufferedImage _image = null;
    private Canvas _canvas = null;
    private Rectangle _sel_rect = null;
    private Rectangle _last_sel_rect = null;
    private float _sel_rect_ratio = 0.0f;
    private int x_offset = 0;
    private int y_offset = 0;
    private int _img_w = 0;
    private int _img_h = 0;
    private float _scale = 1.0f;
    private int _last_w = 0;
    private int _last_h = 0;
    private final TexturePaint checked_paint;

    public CanvasPreviewPanel() {
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        BufferedImage bufferedImage = WPApp.getFactoryImage((String)"chessboard.png");
        this.checked_paint = new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public void setImage(BufferedImage bufferedImage) {
        this._image = bufferedImage;
        this.calculate_dimensions();
        this.repaint();
    }

    public void setCanvas(Canvas canvas) {
        this._canvas = canvas;
    }

    public void setSelectionRectangle(Rectangle rectangle) {
        if (rectangle != null && this._last_sel_rect != null && rectangle.equals(this._last_sel_rect)) {
            return;
        }
        this._sel_rect = rectangle;
        this._last_sel_rect = this._sel_rect == null ? null : new Rectangle(this._sel_rect);
        this.calculate_dimensions();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this._img_w == 0 || this._last_w != this.getWidth() || this._last_h != this.getHeight()) {
            this.calculate_dimensions();
        }
        if (this.checked_paint != null) {
            ((Graphics2D)graphics).setPaint(this.checked_paint);
            graphics.fillRect(this.x_offset, this.y_offset, this._img_w, this._img_h);
        }
        if (this._image != null) {
            graphics.drawImage(this._image, this.x_offset, this.y_offset, this._img_w, this._img_h, null);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(this.x_offset, this.y_offset, this._img_w, this._img_h);
        }
        if (this._sel_rect != null) {
            graphics.drawRect(this.x_offset + this._sel_rect.x, this.y_offset + this._sel_rect.y, this._sel_rect.width, this._sel_rect.height);
        }
    }

    public void setScale(float f) {
        this._scale = f;
        this.calculate_dimensions();
        this.repaint();
    }

    private void calculate_dimensions() {
        if (this._image == null || this.getWidth() == 0) {
            return;
        }
        this._img_w = (int)((float)this._image.getWidth() * this._scale);
        this._img_h = (int)((float)this._image.getHeight() * this._scale);
        float f = (float)this._img_w / (float)this._img_h;
        int n = this.getWidth() - 10;
        int n2 = this.getHeight() - 10;
        if (this._img_w > n) {
            this._img_w = n;
            this._img_h = (int)((float)this._img_w / f);
        }
        if (this._img_h > n2) {
            this._img_h = n2;
            this._img_w = (int)(f * (float)this._img_h);
        }
        this.x_offset = (this.getWidth() - this._img_w) / 2;
        this.y_offset = (this.getHeight() - this._img_h) / 2;
        if (this._sel_rect != null) {
            this._sel_rect_ratio = (float)this._img_w / (float)this._image.getWidth() * this._scale;
            this._sel_rect.x = (int)((float)this._last_sel_rect.x * this._sel_rect_ratio / this._scale);
            this._sel_rect.y = (int)((float)this._last_sel_rect.y * this._sel_rect_ratio / this._scale);
            this._sel_rect.width = (int)((float)this._last_sel_rect.width * this._sel_rect_ratio / this._scale);
            this._sel_rect.height = (int)((float)this._last_sel_rect.height * this._sel_rect_ratio / this._scale);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (CanvasPreviewPanel.this._sel_rect != null) {
                int n = (int)((float)(mouseEvent.getX() - CanvasPreviewPanel.this.x_offset) / CanvasPreviewPanel.this._sel_rect_ratio * CanvasPreviewPanel.this._scale);
                int n2 = (int)((float)(mouseEvent.getY() - CanvasPreviewPanel.this.y_offset) / CanvasPreviewPanel.this._sel_rect_ratio * CanvasPreviewPanel.this._scale);
                CanvasPreviewPanel.this._canvas.setPreviewCenter(n, n2);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (CanvasPreviewPanel.this._sel_rect != null) {
                int n = (int)((float)(mouseEvent.getX() - CanvasPreviewPanel.this.x_offset) / CanvasPreviewPanel.this._sel_rect_ratio * CanvasPreviewPanel.this._scale);
                int n2 = (int)((float)(mouseEvent.getY() - CanvasPreviewPanel.this.y_offset) / CanvasPreviewPanel.this._sel_rect_ratio * CanvasPreviewPanel.this._scale);
                CanvasPreviewPanel.this._canvas.setPreviewCenter(n, n2);
            }
        }
    }
}

