/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor.canvas;

import de.wilke.wizepanel.templateeditor.Txt;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class CanvasRuler
extends JComponent {
    private static final long serialVersionUID = 0L;
    private Orientation m_orientation;
    private int m_increment;
    private int m_units;
    private float m_scale = 1.0f;
    private int m_tick_pos = -1;

    public CanvasRuler(Orientation orientation) {
        this.m_orientation = orientation;
        this.setIncrementAndUnits();
    }

    private void setIncrementAndUnits() {
        this.m_units = this.m_scale > 0.999f ? (int)(this.m_scale * 100.0f) / 100 * 100 : (int)(this.m_scale * 100.0f);
        this.m_increment = this.m_units / 10;
        if (this.m_increment == 0) {
            this.m_increment = 1;
        }
        if (this.m_units % this.m_increment != 0) {
            this.m_increment = 1;
            while (this.m_units % this.m_increment != 0) {
                ++this.m_increment;
            }
        }
    }

    public void setPreferredHeight(int n) {
        this.setPreferredSize(new Dimension(35, n));
    }

    public void setPreferredWidth(int n) {
        this.setPreferredSize(new Dimension(n, 35));
    }

    public void setTickPosition(int n) {
        this.m_tick_pos = n;
        this.repaint();
    }

    public void setScale(float f) {
        this.m_scale = f;
        this.setIncrementAndUnits();
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.m_orientation == Orientation.HORIZONTAL) {
            graphics2D.translate(100.0f * this.m_scale, 0.0);
        } else {
            graphics2D.translate(0.0, 100.0f * this.m_scale);
        }
        Rectangle rectangle = graphics.getClipBounds();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(Txt.RULER_LABEL_COLOR);
        int n3 = 0;
        String string = null;
        int n4 = 0;
        if (this.m_orientation == Orientation.HORIZONTAL) {
            n2 = rectangle.x / this.m_increment * this.m_increment;
            n = ((rectangle.x + rectangle.width) / this.m_increment + 1) * this.m_increment;
        } else {
            n2 = rectangle.y / this.m_increment * this.m_increment;
            n = ((rectangle.y + rectangle.height) / this.m_increment + 1) * this.m_increment;
        }
        for (int i = n2; i <= n; i += this.m_increment) {
            if (i % this.m_units == 0) {
                n3 = 20;
                string = Integer.toString((int)((float)i / this.m_scale));
                n4 = fontMetrics.stringWidth(string);
            } else {
                n3 = 5;
                string = null;
            }
            if (this.m_orientation == Orientation.HORIZONTAL) {
                graphics2D.drawLine(i, 34, i, 35 - n3 - 1);
                if (string == null) continue;
                graphics2D.drawString(string, i + 1, 29);
                continue;
            }
            graphics2D.drawLine(34, i, 35 - n3 - 1, i);
            if (string == null) continue;
            graphics2D.drawString(string, 29 - n4, i + fontMetrics.getHeight() - 2);
        }
        if (this.m_orientation == Orientation.HORIZONTAL) {
            graphics2D.drawLine((int)((float)this.m_tick_pos * this.m_scale), 0, (int)((float)this.m_tick_pos * this.m_scale), 10);
        } else {
            graphics2D.drawLine(0, (int)((float)this.m_tick_pos * this.m_scale), 10, (int)((float)this.m_tick_pos * this.m_scale));
        }
        if (this.m_orientation == Orientation.HORIZONTAL) {
            graphics2D.drawLine(rectangle.x, 34, rectangle.x + rectangle.width, 34);
        } else {
            graphics2D.drawLine(34, rectangle.y, 34, rectangle.y + rectangle.height);
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

