/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor.canvas;

import de.wilke.wizepanel.templates.elements.TemplateElement;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class Label {
    private String text;
    private final Color fill_color;
    private final Color text_color;
    private final int x;
    private final int y;
    private Rectangle bbox;
    private final TemplateElement m_elem;

    public Label(TemplateElement templateElement, String string, Color color, Color color2, int n, int n2, FontMetrics fontMetrics) {
        this.m_elem = templateElement;
        this.text = string;
        this.fill_color = color;
        this.text_color = color2;
        this.x = n;
        this.y = n2;
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getMaxAscent();
        this.bbox = new Rectangle(n - 5, n2 - n4 - 5, n3 + 10, n4 + 10);
    }

    public void draw(Graphics2D graphics2D, boolean bl) {
        graphics2D.setColor(this.fill_color);
        graphics2D.fill(this.bbox);
        graphics2D.setColor(this.text_color);
        graphics2D.drawString(this.text, this.x, this.y);
        graphics2D.draw(this.bbox);
        if (bl) {
            this.bbox.x += 2;
            this.bbox.y += 2;
            this.bbox.width -= 4;
            this.bbox.height -= 4;
            graphics2D.draw(this.bbox);
        }
    }

    public TemplateElement getElement() {
        return this.m_elem;
    }

    public boolean contains(int n, int n2) {
        return this.bbox.contains(n, n2);
    }

    public void addText(String string, FontMetrics fontMetrics) {
        this.text = this.text + " | " + string;
        int n = fontMetrics.stringWidth(this.text);
        int n2 = fontMetrics.getMaxAscent();
        this.bbox = new Rectangle(this.x - 5, this.y - n2 - 5, n + 10, n2 + 10);
    }
}

