/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor.properties;

import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.templateeditor.AppSettings;
import de.wilke.wizepanel.templateeditor.Txt;
import de.wilke.wizepanel.templateeditor.WPTemplates;
import de.wilke.wizepanel.templates.elements.TemplateElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class ElementListPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JList<TemplateElement> m_list;
    private final JPopupMenu _popup;
    private static final String SET_REF = "set.ref";
    private final WPTemplates m_app;

    public ElementListPanel(WPTemplates wPTemplates) {
        this.m_app = wPTemplates;
        this._popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(WPTemplates.tr((String)"reference-object"));
        jMenuItem.setActionCommand(SET_REF);
        jMenuItem.addActionListener(this);
        this._popup.add(jMenuItem);
        this.m_list = new JList(new DefaultListModel());
        this.m_list.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_list.setCellRenderer(new MyListRenderer());
        this.m_list.setSelectionMode(0);
        this.m_list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    ElementListPanel.this.m_app.template.setReferenceElement(ElementListPanel.this.m_list.getSelectedValue());
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) && !ElementListPanel.this.m_list.isSelectionEmpty()) {
                    ElementListPanel.this.m_list.setSelectedIndex(ElementListPanel.this.m_list.locationToIndex(mouseEvent.getPoint()));
                    ElementListPanel.this._popup.show(ElementListPanel.this.m_list, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        LinkedList<AlignButton> linkedList = new LinkedList<AlignButton>();
        linkedList.add(new AlignButton("edit.align.left", "small/align-horizontal-left.png"));
        linkedList.add(new AlignButton("edit.align.hcenter", "small/align-horizontal-center.png"));
        linkedList.add(new AlignButton("edit.align.right", "small/align-horizontal-right.png"));
        linkedList.add(new AlignButton("edit.align.top", "small/align-vertical-top.png"));
        linkedList.add(new AlignButton("edit.align.vcenter", "small/align-vertical-center.png"));
        linkedList.add(new AlignButton("edit.align.bottom", "small/align-vertical-bottom.png"));
        for (AlignButton object2 : linkedList) {
            JButton jButton = new JButton();
            jButton.setIcon(WPApp.getIcon((String)object2.icon));
            jButton.setActionCommand(object2.action);
            jButton.addActionListener(this);
            jButton.setToolTipText(WPApp.tr((String)object2.action));
            object2.button = jButton;
        }
        JScrollPane jScrollPane = new JScrollPane(this.m_list);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        for (AlignButton alignButton : linkedList) {
            jToolBar.add(alignButton.button);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)jToolBar, "North");
        this.add((Component)jScrollPane, "Center");
    }

    public void setElements(LinkedList<TemplateElement> linkedList) {
        DefaultListModel defaultListModel = (DefaultListModel)this.m_list.getModel();
        defaultListModel.clear();
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            defaultListModel.addElement(linkedList.get(i));
        }
        this.m_list.setSelectedIndex(0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (SET_REF.equals(actionEvent.getActionCommand())) {
            this.m_app.template.setReferenceElement(this.m_list.getSelectedValue());
        } else {
            this.m_app.do_edit_alignment(actionEvent.getActionCommand());
        }
    }

    class MyListRenderer
    extends JLabel
    implements ListCellRenderer<TemplateElement> {
        private static final long serialVersionUID = 1L;
        private final Font default_font = this.getFont().deriveFont(0);
        private final Font top_font = this.default_font.deriveFont(1);

        @Override
        public Component getListCellRendererComponent(JList<? extends TemplateElement> jList, TemplateElement templateElement, int n, boolean bl, boolean bl2) {
            TemplateElement templateElement2 = templateElement;
            boolean bl3 = templateElement2 == ElementListPanel.this.m_app.template.getReferenceElement();
            ImageIcon imageIcon = Txt.getTypeIcon(templateElement2.type());
            if (bl3) {
                imageIcon = this.add_reference_icon(imageIcon);
            }
            this.setIcon(imageIcon);
            this.setText(WPApp.tr((String)templateElement2.type()) + (String)(bl3 ? " [" + WPApp.tr((String)"reference-object") + "]" : ""));
            this.setFont(bl3 ? this.top_font : this.default_font);
            return this;
        }

        private ImageIcon add_reference_icon(ImageIcon imageIcon) {
            BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(imageIcon.getImage(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), imageIcon.getImageObserver());
            graphics2D.setColor(AppSettings.referenceHandleColor());
            graphics2D.fillRect(bufferedImage.getWidth() / 2 - 5, bufferedImage.getHeight() / 2 - 5, 10, 10);
            return new ImageIcon(bufferedImage);
        }
    }

    private class AlignButton {
        public JButton button;
        public String action;
        public String icon;

        private AlignButton(String string, String string2) {
            this.action = string;
            this.icon = string2;
        }
    }
}

