/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor.properties;

import de.wilke.misc.treetable.JTreeTable;
import de.wilke.misc.treetable.PropertiesModel;
import de.wilke.misc.treetable.attributes.AbstractAttribute;
import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.templateeditor.Txt;
import de.wilke.wizepanel.templateeditor.WPTemplates;
import de.wilke.wizepanel.templateeditor.properties.ElementListPanel;
import de.wilke.wizepanel.templateeditor.properties.EllipseElement;
import de.wilke.wizepanel.templateeditor.properties.GraphicsElement;
import de.wilke.wizepanel.templateeditor.properties.LineElement;
import de.wilke.wizepanel.templateeditor.properties.PropertyBase;
import de.wilke.wizepanel.templateeditor.properties.PropertyListener;
import de.wilke.wizepanel.templateeditor.properties.QRElement;
import de.wilke.wizepanel.templateeditor.properties.RectElement;
import de.wilke.wizepanel.templateeditor.properties.TextElement;
import de.wilke.wizepanel.templateeditor.properties.TimetableElement;
import de.wilke.wizepanel.templates.elements.TemplateElement;
import de.wilke.wizepanel.templates.elements.TemplateElementEllipse;
import de.wilke.wizepanel.templates.elements.TemplateElementGraphics;
import de.wilke.wizepanel.templates.elements.TemplateElementLine;
import de.wilke.wizepanel.templates.elements.TemplateElementQR;
import de.wilke.wizepanel.templates.elements.TemplateElementRect;
import de.wilke.wizepanel.templates.elements.TemplateElementText;
import de.wilke.wizepanel.templates.elements.TemplateElementTimetable;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;

public class PropertiesPanel
extends JPanel
implements PropertyListener {
    private static final long serialVersionUID = 0L;
    private boolean m_ignore_changes = false;
    private WPTemplates m_app;
    private PropertyBase m_elem_props = null;
    private TemplateElement m_elem = null;
    static final String ELEMENT_CARD = "element.card";
    static final String ELEMENT_LIST_CARD = "element.list.card";
    private final JPanel m_cards;
    private final ElementListPanel m_elements_list;
    private final JPanel m_elem_panel;
    private final JTreeTable m_props_tree;
    private final PropertiesModel prop_model;
    private JEditorPane m_help;
    private JLabel m_type;
    private JLabel m_type_icon;
    private JLabel m_type_is_new;
    private JCheckBox m_locked_all;

    public PropertiesPanel(WPTemplates wPTemplates) {
        this.m_app = wPTemplates;
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setBorder(border);
        this.m_help = new JEditorPane("text/html", "");
        this.m_help.setEditable(false);
        this.m_help.setOpaque(true);
        this.m_help.setBackground(UIManager.getColor("ToolTip.background"));
        this.m_help.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.m_help.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.m_type = new JLabel();
        this.m_type_icon = new JLabel();
        this.m_type_is_new = new JLabel();
        this.m_type_is_new.setFont(this.m_type_is_new.getFont().deriveFont(2));
        this.m_locked_all = new JCheckBox(WPApp.tr((String)"edit.lock"));
        this.m_locked_all.setActionCommand("edit.lock-all");
        this.m_locked_all.addActionListener(wPTemplates);
        this.m_locked_all.setAlignmentX(0.0f);
        this.m_elements_list = new ElementListPanel(this.m_app);
        this.prop_model = new PropertiesModel();
        this.m_props_tree = new JTreeTable(this.m_app, this.prop_model);
        JScrollPane jScrollPane = new JScrollPane(this.m_props_tree);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this.m_type_icon, "West");
        jPanel.add((Component)this.m_type, "Center");
        jPanel.add((Component)this.m_type_is_new, "East");
        this.m_elem_panel = new JPanel(new BorderLayout());
        this.m_elem_panel.setLayout(new BorderLayout(5, 5));
        this.m_elem_panel.add((Component)jPanel, "North");
        this.m_elem_panel.add((Component)jScrollPane, "Center");
        this.m_cards = new JPanel(new CardLayout());
        this.m_cards.add((Component)this.m_elem_panel, ELEMENT_CARD);
        this.m_cards.add((Component)this.m_elements_list, ELEMENT_LIST_CARD);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add((Component)new JLabel(WPApp.getFactoryIcon((String)"small/document-encrypt.png")), "West");
        jPanel2.add((Component)this.m_locked_all, "Center");
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.m_help, "North");
        this.add((Component)this.m_cards, "Center");
        this.add((Component)jPanel2, "South");
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    public void setElements(LinkedList<TemplateElement> linkedList) {
        CardLayout cardLayout = (CardLayout)this.m_cards.getLayout();
        switch (linkedList.size()) {
            case 0: {
                this.setElement(null);
                break;
            }
            case 1: {
                this.setElement(linkedList.get(0));
                break;
            }
            default: {
                this.m_locked_all.setVisible(true);
                this.m_locked_all.setSelected(!this.m_app.template.getReferenceElement().isMoveable());
                this.m_elements_list.setElements(linkedList);
                cardLayout.show(this.m_cards, ELEMENT_LIST_CARD);
            }
        }
    }

    public void setElement(TemplateElement templateElement) {
        CardLayout cardLayout = (CardLayout)this.m_cards.getLayout();
        cardLayout.show(this.m_cards, ELEMENT_CARD);
        TableCellEditor tableCellEditor = this.m_props_tree.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        if (templateElement == null) {
            this.setHelp(WPApp.tr((String)"select_an_element"));
            this.m_elem_panel.setVisible(false);
            this.m_props_tree.setVisible(false);
            this.m_locked_all.setEnabled(false);
            this.m_type_icon.setIcon(null);
            this.m_type.setText(null);
            this.m_type_is_new.setText(null);
            this.m_elem = null;
        } else if (this.m_elem != null && this.m_elem == templateElement) {
            LinkedHashMap<String, AbstractAttribute> linkedHashMap = new LinkedHashMap<String, AbstractAttribute>();
            this.m_elem_props.getAttributes(linkedHashMap);
            this.update_properties(linkedHashMap);
        } else {
            this.m_elem = templateElement;
            if (this.m_elem.type().equals("tool.rect")) {
                this.m_elem_props = new RectElement(this.m_app, (TemplateElementRect)this.m_elem);
            } else if (this.m_elem.type().equals("tool.line")) {
                this.m_elem_props = new LineElement(this.m_app, (TemplateElementLine)this.m_elem);
            } else if (this.m_elem.type().equals("tool.ellipse")) {
                this.m_elem_props = new EllipseElement(this.m_app, (TemplateElementEllipse)this.m_elem);
            } else if (this.m_elem.type().equals("tool.text")) {
                this.m_elem_props = new TextElement(this.m_app, (TemplateElementText)this.m_elem);
            } else if (this.m_elem.type().equals("tool.graphics")) {
                this.m_elem_props = new GraphicsElement(this.m_app, (TemplateElementGraphics)this.m_elem);
            } else if (this.m_elem.type().equals("tool.qr")) {
                this.m_elem_props = new QRElement(this.m_app, (TemplateElementQR)this.m_elem);
            } else if (this.m_elem.type().equals("tool.timetable")) {
                this.m_elem_props = new TimetableElement(this.m_app, (TemplateElementTimetable)this.m_elem);
            }
            this.m_type.setText(WPApp.tr((String)this.m_elem.type()));
            this.m_type_icon.setIcon(Txt.getTypeIcon(this.m_elem.type()));
            this.m_type_is_new.setText(this.m_elem.isValid() ? null : WPApp.tr((String)"new"));
            LinkedHashMap<String, AbstractAttribute> linkedHashMap = new LinkedHashMap<String, AbstractAttribute>();
            this.m_elem_props.getAttributes(linkedHashMap);
            this.set_properties(linkedHashMap);
            this.m_props_tree.expandAll();
            this.m_props_tree.setVisible(true);
            if (this.m_elem.isValid()) {
                this.setHelp(WPApp.tr((String)"move_resize_element"));
            } else {
                this.setHelp(WPApp.tr((String)"draw_new_element"));
            }
            this.m_elem_panel.setVisible(true);
            boolean bl = this.m_ignore_changes;
            this.m_ignore_changes = true;
            this.m_locked_all.setVisible(true);
            this.m_locked_all.setSelected(!this.m_elem.isMoveable());
            this.m_locked_all.setEnabled(this.m_elem.isValid());
            this.m_ignore_changes = bl;
        }
    }

    private void setHelp(String string) {
        if (string.length() > 0) {
            this.m_help.setText("<strong>" + string + "</strong>");
        } else {
            this.m_help.setText("");
        }
    }

    private void set_properties(LinkedHashMap<String, AbstractAttribute> linkedHashMap) {
        if (this.m_ignore_changes) {
            return;
        }
        boolean bl = this.m_ignore_changes;
        this.m_ignore_changes = true;
        this.prop_model.clear();
        for (AbstractAttribute abstractAttribute : linkedHashMap.values()) {
            if (abstractAttribute == null) continue;
            abstractAttribute.setGUI(this);
            this.prop_model.addProperty(abstractAttribute);
        }
        this.m_ignore_changes = bl;
    }

    private void update_properties(LinkedHashMap<String, AbstractAttribute> linkedHashMap) {
        for (AbstractAttribute abstractAttribute : linkedHashMap.values()) {
            this.prop_model.setProperty(abstractAttribute);
        }
    }

    public ElementListPanel getElementsList() {
        return this.m_elements_list;
    }

    @Override
    public void propertyModified(AbstractAttribute abstractAttribute, boolean bl) {
        TemplateElement templateElement = this.m_elem_props.getElement();
        if (this.m_ignore_changes) {
            return;
        }
        String string = templateElement.getAttribute(abstractAttribute.getName());
        if (string != null && string.equals(abstractAttribute.getValue())) {
            return;
        }
        if (templateElement.setAttribute(abstractAttribute.getName(), abstractAttribute.getValue()) && templateElement.name() != null) {
            templateElement.rebuild();
            boolean bl2 = this.m_ignore_changes;
            this.m_ignore_changes = true;
            this.m_app.elementModified(this.m_elem_props.getElement(), abstractAttribute.getName(), string, bl);
            this.m_ignore_changes = bl2;
        }
    }

    public static enum Type {
        TEXT,
        IMAGE,
        LINECLOSE,
        LINE,
        PLACEHOLDER,
        RECT_GEOMETRY,
        LINE_GEOMETRY,
        ROUNDCORNER;

    }
}

