/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor.undo;

import de.wilke.wizepanel.templateeditor.undo.UndoCommand;
import de.wilke.wizepanel.templates.MouseHandle;
import de.wilke.wizepanel.templates.elements.TemplateElement;
import de.wilke.wizepanel.templates.elements.TemplateElementText;

public class MoveResizeCommand
extends UndoCommand {
    private MouseHandle m_mouse_handle;
    private int m_old_x;
    private int m_old_y;
    private int m_new_x;
    private int m_new_y;
    private boolean _move_all;

    public MoveResizeCommand(TemplateElement templateElement, MouseHandle mouseHandle, int n, int n2, boolean bl) {
        super(templateElement);
        this.m_mouse_handle = mouseHandle;
        this.m_old_x = n;
        this.m_old_y = n2;
        if (templateElement == null) {
            this.m_new_y = -1;
            this.m_new_x = -1;
        } else {
            this.m_new_x = this.m_mouse_handle.getX();
            this.m_new_y = this.m_mouse_handle.getY();
        }
        this._move_all = bl;
    }

    public MoveResizeCommand() {
        super(null);
    }

    @Override
    protected void undoCommand() {
        this.m_elem.setHandle(this.m_mouse_handle, this.m_old_x, this.m_old_y, this._move_all);
    }

    @Override
    protected void redoCommand() {
        this.m_elem.setHandle(this.m_mouse_handle, this.m_new_x, this.m_new_y, this._move_all);
    }

    public MouseHandle getMouseHandle() {
        return this.m_mouse_handle;
    }

    public int getNewX() {
        return this.m_new_x;
    }

    public int getNewY() {
        return this.m_new_y;
    }

    @Override
    protected String description() {
        if (this.m_elem == null) {
            return "NULL";
        }
        if (this.m_elem instanceof TemplateElementText) {
            return this.m_elem.toString();
        }
        return "";
    }

    @Override
    protected void doSingleMerge(UndoCommand undoCommand) {
        MoveResizeCommand moveResizeCommand = (MoveResizeCommand)undoCommand;
        this.m_new_x = moveResizeCommand.getNewX();
        this.m_new_y = moveResizeCommand.getNewY();
    }

    @Override
    protected boolean canSingleMerge(UndoCommand undoCommand) {
        MoveResizeCommand moveResizeCommand;
        if (this.m_elem == null || this.m_elem != undoCommand.getElement()) {
            return false;
        }
        return undoCommand instanceof MoveResizeCommand && (moveResizeCommand = (MoveResizeCommand)undoCommand).getMouseHandle() == this.m_mouse_handle;
    }
}

